/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import java.util.Arrays;
import java.util.Objects;

@Internal
public record MatchesPresenceOfBeansCondition(AnnotationClassValue<?>[] beans) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        for (AnnotationClassValue<?> bean : this.beans) {
            Class type = bean.getType().orElse(null);
            if (type != null && beanContext.containsBean(type)) continue;
            context.fail("No bean of type [" + bean.getName() + "] present within context");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesPresenceOfBeansCondition that = (MatchesPresenceOfBeansCondition)o;
        return Objects.deepEquals(this.beans, that.beans);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.beans);
    }

    @Override
    public String toString() {
        return "MatchesPresenceOfBeansCondition{beans=" + Arrays.toString(this.beans) + "}";
    }
}

