/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.CompositeQualifier;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import java.util.Arrays;
import java.util.stream.Collectors;

@Internal
final class FilteringCompositeQualifier<T>
extends FilteringQualifier<T> {
    private final FilteringQualifier<T>[] qualifiers;

    FilteringCompositeQualifier(FilteringQualifier<T>[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        for (FilteringQualifier<T> qualifier : this.qualifiers) {
            if (qualifier.doesQualify(beanType, candidate)) continue;
            return false;
        }
        return true;
    }

    public FilteringQualifier<T>[] getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public boolean contains(Qualifier<T> qualifier) {
        if (qualifier instanceof FilteringCompositeQualifier) {
            FilteringCompositeQualifier filteringCompositeQualifier = (FilteringCompositeQualifier)qualifier;
            for (FilteringQualifier<T> q : filteringCompositeQualifier.qualifiers) {
                if (this.contains(q)) continue;
                return false;
            }
            return true;
        }
        if (qualifier instanceof CompositeQualifier) {
            CompositeQualifier compositeQualifier = (CompositeQualifier)qualifier;
            for (Qualifier q : compositeQualifier.getQualifiers()) {
                if (this.contains(q)) continue;
                return false;
            }
            return true;
        }
        for (FilteringQualifier<T> q : this.qualifiers) {
            if (!q.contains(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringCompositeQualifier that = (FilteringCompositeQualifier)o;
        return Arrays.equals(this.qualifiers, that.qualifiers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.qualifiers);
    }

    public String toString() {
        return Arrays.stream(this.qualifiers).map(Object::toString).collect(Collectors.joining(" and "));
    }
}

