/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.AbstractInitializableBeanDefinitionAndReference;
import io.micronaut.context.AnnotationProcessorListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanDisposingRegistration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.BeanResolutionTraceConfiguration;
import io.micronaut.context.BeanResolutionTraceMode;
import io.micronaut.context.ConfigurableBeanContext;
import io.micronaut.context.DefaultCustomScopeRegistry;
import io.micronaut.context.DisabledBean;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.InitializableBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.SingletonScope;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Infrastructure;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.Failure;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanDestroyedEvent;
import io.micronaut.context.event.BeanDestroyedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanPreDestroyEvent;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.exceptions.NonUniqueBeanException;
import io.micronaut.context.processor.AnnotationProcessor;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.MicronautMetaServiceLoaderUtils;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.type.UnsafeExecutable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectableBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.ParametrizedInstantiatableBeanDefinition;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.QualifiedBeanType;
import io.micronaut.inject.UnsafeExecutionHandle;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.provider.AbstractProviderDefinition;
import io.micronaut.inject.proxy.InterceptedBeanProxy;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.Qualified;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanContext
implements InitializableBeanContext,
ConfigurableBeanContext {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);
    protected static final Logger LOG_LIFECYCLE = LoggerFactory.getLogger((String)(DefaultBeanContext.class.getPackage().getName() + ".lifecycle"));
    private static final String SCOPED_PROXY_ANN = "io.micronaut.runtime.context.scope.ScopedProxy";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String ADAPTER_TYPE = "io.micronaut.aop.Adapter";
    private static final String PARALLEL_TYPE = Parallel.class.getName();
    private static final String INDEXES_TYPE = Indexes.class.getName();
    private static final String REPLACES_ANN = Replaces.class.getName();
    private static final String MSG_COULD_NOT_BE_LOADED = "] could not be loaded: ";
    public static final String MSG_BEAN_DEFINITION = "Bean definition [";
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicBoolean configured = new AtomicBoolean(false);
    protected final AtomicBoolean initializing = new AtomicBoolean(false);
    protected final AtomicBoolean terminating = new AtomicBoolean(false);
    @NonNull
    final BeanResolutionTraceMode traceMode;
    @NonNull
    final Set<String> tracePatterns;
    final Map<BeanIdentifier, BeanRegistration<?>> singlesInCreation = new ConcurrentHashMap(5);
    protected final SingletonScope singletonScope = new SingletonScope();
    private final BeanContextConfiguration beanContextConfiguration;
    private final Collection<BeanDefinitionProducer> beanDefinitionsClasses = new CopyOnWriteArrayList<BeanDefinitionProducer>();
    private final Collection<BeanDefinitionProducer> proxyTargetBeans = new CopyOnWriteArrayList<BeanDefinitionProducer>();
    private final Map<BeanKey<?>, BeanDefinitionProducer> disabledBeans = new ConcurrentHashMap(20);
    private final Map<String, List<String>> disabledConfigurations = new ConcurrentHashMap<String, List<String>>(5);
    private final Map<String, BeanConfiguration> beanConfigurations = new HashMap<String, BeanConfiguration>(10);
    private final Map<BeanKey, Boolean> containsBeanCache = new ConcurrentHashMap<BeanKey, Boolean>(30);
    private final Map<CharSequence, Object> attributes = Collections.synchronizedMap(new HashMap(5));
    private final Map<BeanKey, CollectionHolder> singletonBeanRegistrations = new ConcurrentHashMap<BeanKey, CollectionHolder>(50);
    private final Map<BeanCandidateKey, Optional<BeanDefinition>> beanConcreteCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<BeanCandidateKey, Optional<BeanDefinition>> beanProxyTargetCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Argument, Collection<BeanDefinition>> beanCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class<?>, Collection<BeanDefinitionProducer>> beanIndex = new ConcurrentHashMap(12);
    private final ClassLoader classLoader;
    private final Set<Class<?>> thisInterfaces = CollectionUtils.setOf((Object[])new Class[]{BeanDefinitionRegistry.class, BeanContext.class, AnnotationMetadataResolver.class, BeanLocator.class, ExecutionHandleLocator.class, ApplicationContext.class, PropertyResolver.class, ValueResolver.class, PropertyPlaceholderResolver.class});
    private final Set<Class<?>> indexedTypes = CollectionUtils.setOf((Object[])new Class[]{ResourceLoader.class, TypeConverter.class, TypeConverterRegistrar.class, ApplicationEventListener.class, BeanCreatedEventListener.class, BeanInitializedEventListener.class});
    private final CustomScopeRegistry customScopeRegistry;
    private final String[] eagerInitStereotypes;
    private final boolean eagerInitStereotypesPresent;
    private final boolean eagerInitSingletons;
    private BeanDefinitionValidator beanValidator;
    private List<BeanDefinitionReference> beanDefinitionReferences;
    private List<BeanConfiguration> beanConfigurationsList;
    private StartupBeans startupBeans;
    List<Map.Entry<Class<?>, ListenersSupplier<BeanInitializedEventListener>>> beanInitializedEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanCreatedEventListener>>> beanCreationEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanPreDestroyEventListener>>> beanPreDestroyEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanDestroyedEventListener>>> beanDestroyedEventListeners;
    @Nullable
    private MutableConversionService conversionService;

    public DefaultBeanContext() {
        this(BeanContext.class.getClassLoader());
    }

    public DefaultBeanContext(final @NonNull ClassLoader classLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
                return classLoader;
            }
        });
    }

    public DefaultBeanContext(final @NonNull ClassPathResourceLoader resourceLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader.getClassLoader();
            }
        });
    }

    public DefaultBeanContext(@NonNull BeanContextConfiguration contextConfiguration) {
        ArgumentUtils.requireNonNull((String)"contextConfiguration", (Object)contextConfiguration);
        System.setProperty("micronaut.classloader.logging", "true");
        this.classLoader = contextConfiguration.getClassLoader();
        this.customScopeRegistry = Objects.requireNonNull(this.createCustomScopeRegistry(), "Scope registry cannot be null");
        Set<Class<? extends Annotation>> eagerInitAnnotated = contextConfiguration.getEagerInitAnnotated();
        ArrayList<String> configuredEagerSingletonAnnotations = new ArrayList<String>(eagerInitAnnotated.size());
        for (Class<? extends Annotation> ann : eagerInitAnnotated) {
            configuredEagerSingletonAnnotations.add(ann.getName());
        }
        this.eagerInitStereotypes = configuredEagerSingletonAnnotations.toArray(StringUtils.EMPTY_STRING_ARRAY);
        this.eagerInitStereotypesPresent = !configuredEagerSingletonAnnotations.isEmpty();
        this.eagerInitSingletons = this.eagerInitStereotypesPresent && (configuredEagerSingletonAnnotations.contains("jakarta.inject.Singleton") || configuredEagerSingletonAnnotations.contains(Singleton.class.getName()));
        this.beanContextConfiguration = contextConfiguration;
        BeanResolutionTraceConfiguration traceConfiguration = this.beanContextConfiguration.getTraceConfiguration();
        this.traceMode = traceConfiguration.mode();
        this.tracePatterns = traceConfiguration.classPatterns();
    }

    @NonNull
    protected CustomScopeRegistry createCustomScopeRegistry() {
        return new DefaultCustomScopeRegistry(this);
    }

    @Internal
    @NonNull
    CustomScopeRegistry getCustomScopeRegistry() {
        return this.customScopeRegistry;
    }

    @Override
    public boolean isRunning() {
        return this.running.get() && !this.initializing.get();
    }

    @Override
    public synchronized BeanContext start() {
        if (!this.isRunning()) {
            if (this.initializing.compareAndSet(false, true)) {
                String activeConfigurations;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting BeanContext");
                }
                this.registerConversionService();
                this.configureAndStartContext();
                if (LOG.isDebugEnabled() && StringUtils.isNotEmpty((CharSequence)(activeConfigurations = this.beanConfigurations.values().stream().filter(config -> config.isEnabled(this)).map(BeanConfiguration::getName).collect(Collectors.joining(","))))) {
                    LOG.debug("Loaded active configurations: {}", (Object)activeConfigurations);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BeanContext Started.");
                }
                this.publishEvent(new StartupEvent(this));
            }
            this.running.set(true);
            this.initializing.set(false);
        }
        return this;
    }

    protected void registerConversionService() {
        this.conversionService = MutableConversionService.create();
        this.registerSingleton(MutableConversionService.class, this.conversionService, (Qualifier)null, false);
    }

    @Internal
    <C extends AnnotationMetadataProvider> void trackDisabledComponent(@NonNull ConditionContext<C> conditionContext) {
        C component = conditionContext.getComponent();
        List<String> reasons = conditionContext.getFailures().stream().map(Failure::getMessage).toList();
        if (component instanceof QualifiedBeanType) {
            QualifiedBeanType beanType = (QualifiedBeanType)component;
            try {
                Argument argument = beanType.getGenericBeanType();
                Qualifier declaredQualifier = beanType.getDeclaredQualifier();
                this.disabledBeans.put(new BeanKey(argument, declaredQualifier), new BeanDefinitionProducer(new DisabledBean(argument, declaredQualifier, reasons)));
            }
            catch (Exception | NoClassDefFoundError throwable) {}
        } else if (component instanceof BeanConfiguration) {
            BeanConfiguration configuration = (BeanConfiguration)component;
            this.disabledConfigurations.put(configuration.getName(), reasons);
        }
    }

    @Override
    public synchronized BeanContext stop() {
        if (this.terminating.compareAndSet(false, true) && this.isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping BeanContext");
            }
            this.publishEvent(new ShutdownEvent(this));
            this.attributes.clear();
            List<BeanRegistration> objects = this.topologicalSort(this.singletonScope.getBeanRegistrations());
            Map<Boolean, List<BeanRegistration>> result = objects.stream().collect(Collectors.groupingBy(br -> br.bean != null && (br.bean instanceof BeanPreDestroyEventListener || br.bean instanceof BeanDestroyedEventListener)));
            List<BeanRegistration> listeners = result.get(true);
            if (listeners != null) {
                objects.clear();
                objects.addAll((Collection<BeanRegistration>)result.get(false));
                objects.addAll(listeners);
            }
            HashSet<Integer> processed = new HashSet<Integer>();
            for (BeanRegistration beanRegistration : objects) {
                Object bean = beanRegistration.bean;
                int sysId = System.identityHashCode(bean);
                if (processed.contains(sysId)) continue;
                if (LOG_LIFECYCLE.isDebugEnabled()) {
                    LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, (Object)beanRegistration.identifier);
                }
                processed.add(sysId);
                try {
                    this.destroyBean(beanRegistration);
                }
                catch (BeanDestructionException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.singlesInCreation.clear();
            this.singletonBeanRegistrations.clear();
            this.beanConcreteCandidateCache.clear();
            this.beanCandidateCache.clear();
            this.beanProxyTargetCache.clear();
            this.containsBeanCache.clear();
            this.beanConfigurations.clear();
            this.disabledConfigurations.clear();
            this.singletonScope.clear();
            this.beanDefinitionsClasses.clear();
            this.disabledBeans.clear();
            this.proxyTargetBeans.clear();
            this.attributes.clear();
            this.beanIndex.clear();
            this.beanConfigurationsList = null;
            this.beanDefinitionReferences = null;
            this.beanInitializedEventListeners = null;
            this.beanCreationEventListeners = null;
            this.beanPreDestroyEventListeners = null;
            this.beanDestroyedEventListeners = null;
            this.conversionService = null;
            this.startupBeans = null;
            this.terminating.set(false);
            this.running.set(false);
            this.configured.set(false);
            if (this.traceMode != BeanResolutionTraceMode.NONE) {
                this.traceMode.getTracer().ifPresent(tracer -> tracer.traceContextShutdown(this));
            }
        }
        return this;
    }

    @NonNull
    public AnnotationMetadata resolveMetadata(Class<?> type) {
        if (type == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        return this.findBeanDefinitionInternal(Argument.of(type), null).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public <T> Optional<T> refreshBean(@Nullable BeanIdentifier identifier) {
        if (identifier == null) {
            return Optional.empty();
        }
        BeanRegistration<BeanIdentifier> beanRegistration = this.singletonScope.findBeanRegistration(identifier);
        if (beanRegistration != null) {
            this.refreshBean(beanRegistration);
            return Optional.of(beanRegistration.bean);
        }
        return Optional.empty();
    }

    @Override
    public <T> void refreshBean(@NonNull BeanRegistration<T> beanRegistration) {
        BeanDefinition<T> definition;
        Objects.requireNonNull(beanRegistration, "BeanRegistration cannot be null");
        Object bean = beanRegistration.bean;
        if (bean != null && (definition = beanRegistration.definition()) instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)definition;
            injectableBeanDefinition.inject(this, bean);
        }
    }

    @Override
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(beanType);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType, Qualifier<T> qualifier) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistrations(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(BeanDefinition<T> beanDefinition) {
        return this.resolveBeanRegistration(null, beanDefinition);
    }

    @Override
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        if (bean == null) {
            return Optional.empty();
        }
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(bean);
        if (beanRegistration != null) {
            return Optional.of(beanRegistration);
        }
        return this.customScopeRegistry.findBeanRegistration(bean);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class<?> ... arguments) {
        return this.findExecutionHandle(beanType, null, method, arguments);
    }

    @Override
    public MethodExecutionHandle<?, Object> createExecutionHandle(BeanDefinition<?> beanDefinition, ExecutableMethod<Object, ?> method) {
        if (method instanceof UnsafeExecutable) {
            return new BeanContextUnsafeExecutionHandle(method, beanDefinition, (UnsafeExecutable<Object, Object>)((UnsafeExecutable)method));
        }
        return new BeanContextExecutionHandle(method, beanDefinition);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> q, String method, Class<?> ... arguments) {
        Qualifier<?> qualifier = q;
        Optional<BeanDefinition<T>> foundBean = this.findBeanDefinition(beanType, qualifier);
        if (foundBean.isEmpty()) {
            return Optional.empty();
        }
        BeanDefinition beanDefinition = foundBean.get();
        Optional foundMethod = beanDefinition.findMethod(method, arguments);
        if (foundMethod.isEmpty()) {
            foundMethod = beanDefinition.findPossibleMethods(method).findFirst().filter(m -> {
                Class[] argTypes = m.getArgumentTypes();
                if (argTypes.length == arguments.length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (arguments[i].isAssignableFrom(argTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            });
        }
        return foundMethod.map(executableMethod -> new BeanExecutionHandle(this, beanDefinition, beanType, qualifier, executableMethod));
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class<?>[] arguments) {
        if (beanType == null) {
            return Optional.empty();
        }
        Collection<BeanDefinition<T>> definitions = this.getBeanDefinitions(beanType);
        if (definitions.isEmpty()) {
            return Optional.empty();
        }
        BeanDefinition<T> beanDefinition = definitions.iterator().next();
        Optional foundMethod = beanDefinition.findMethod(method, arguments);
        if (foundMethod.isPresent()) {
            return foundMethod;
        }
        return beanDefinition.findPossibleMethods(method).findFirst();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class<?>[] arguments) {
        Optional<BeanDefinition<?>> foundBean;
        if (bean != null && (foundBean = this.findBeanDefinition(bean.getClass())).isPresent()) {
            BeanDefinition<?> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton, Qualifier<T> qualifier, boolean inject) {
        BeanDefinition beanDefinition;
        this.purgeCacheForBeanInstance(singleton);
        if (inject && this.running.get()) {
            beanDefinition = this.findConcreteCandidate(null, Argument.of(type), qualifier, false).orElse(null);
            if (beanDefinition == null) {
                this.purgeCacheForBeanInstance(singleton);
            }
        } else {
            beanDefinition = null;
        }
        if (beanDefinition != null && !(beanDefinition instanceof RuntimeBeanDefinition) && beanDefinition.getBeanType().isInstance(singleton)) {
            try (BeanResolutionContext context = this.newResolutionContext(beanDefinition, null);){
                if (inject) {
                    this.doInjectAndInitialize(context, singleton, beanDefinition);
                }
                BeanKey key = new BeanKey(beanDefinition.asArgument(), qualifier);
                this.singletonScope.registerSingletonBean(BeanRegistration.of(this, key, beanDefinition, singleton), qualifier);
            }
        } else {
            RuntimeBeanDefinition<Object> runtimeBeanDefinition = RuntimeBeanDefinition.builder(type, () -> singleton).singleton(true).qualifier(qualifier).build();
            BeanRegistration<Object> registration = BeanRegistration.of(this, new BeanKey<Object>(runtimeBeanDefinition, qualifier), runtimeBeanDefinition, singleton);
            this.singletonScope.registerSingletonBean(registration, qualifier);
            this.registerBeanDefinition(runtimeBeanDefinition);
        }
        return this;
    }

    private <T> void purgeCacheForBeanInstance(T singleton) {
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isInstance(singleton));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isInstance(singleton));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
    }

    @NonNull
    final BeanResolutionContext newResolutionContext(BeanDefinition<?> beanDefinition, @Nullable BeanResolutionContext currentContext) {
        if (currentContext == null) {
            return new SingletonBeanResolutionContext(beanDefinition);
        }
        return currentContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public BeanDefinitionValidator getBeanValidator() {
        if (this.beanValidator == null) {
            this.beanValidator = this.findBean(BeanDefinitionValidator.class).orElse(BeanDefinitionValidator.DEFAULT);
        }
        return this.beanValidator;
    }

    @Override
    public Optional<BeanConfiguration> findBeanConfiguration(String configurationName) {
        BeanConfiguration configuration = this.beanConfigurations.get(configurationName);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanDefinition<T> getBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> this.newNoSuchBeanException(null, beanType, qualifier, null));
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.singletonScope.findCachedSingletonBeanDefinition(beanType, qualifier);
        if (beanDefinition != null) {
            return Optional.of(beanDefinition);
        }
        return this.findConcreteCandidate(null, beanType, qualifier, true);
    }

    private <T> Optional<BeanDefinition<T>> findBeanDefinitionInternal(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findConcreteCandidate(null, beanType, qualifier, false);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType) {
        return this.getBeanDefinitions(Argument.of(beanType));
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, beanType);
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanDefinitions(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, beanType);
        if (qualifier != null) {
            candidates = qualifier.filter(beanType.getType(), candidates);
        }
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> boolean containsBean(@NonNull Class<T> beanType, Qualifier<T> qualifier) {
        return this.containsBean(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> boolean containsBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (this.containsBeanCache.containsKey(beanKey)) {
            return this.containsBeanCache.get(beanKey);
        }
        boolean result = this.singletonScope.containsBean(beanType, qualifier) || this.isCandidatePresent(beanKey.beanType, qualifier);
        this.containsBeanCache.put(beanKey, result);
        return result;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        try {
            return this.getBean(null, beanType, qualifier);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", new Object[]{beanType.getSimpleName(), e.getMessage(), e});
            }
            throw this.newNoSuchBeanException(null, beanType, qualifier, "Bean of type [" + beanType.getTypeString(true) + "] disabled for reason: " + e.getMessage());
        }
    }

    @Override
    public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Optional<T> findBean(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType) {
        return this.getBeansOfType(null, Argument.of(beanType));
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType) {
        return this.getBeansOfType(null, beanType);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <V> Map<String, V> mapOfType(Argument<V> beanType, Qualifier<V> qualifier) {
        return this.mapOfType(null, beanType, qualifier);
    }

    protected <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    protected <V> Map<String, V> mapOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<V> beanType, @Nullable Qualifier<V> qualifier) {
        Qualifier<V> mapQualifier;
        Argument mapType = Argument.mapOf((Argument)Argument.STRING, beanType);
        BeanDefinition existingBean = this.findBeanDefinitionInternal(mapType, mapQualifier = qualifier).orElse(null);
        if (existingBean != null) {
            return (Map)this.getBean(existingBean);
        }
        Collection<BeanRegistration<V>> beanRegistrations = this.getBeanRegistrations(resolutionContext, beanType, qualifier);
        if (beanRegistrations.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return beanRegistrations.stream().collect(Collectors.toUnmodifiableMap(DefaultBeanContext::resolveKey, reg -> reg.bean));
        }
        catch (IllegalStateException e) {
            throw new DependencyInjectionException(resolutionContext, "Injecting a map of beans requires `@Named` qualifier. Multiple beans were found missing a qualifier resulting in duplicate keys: " + e.getMessage(), (Throwable)new NonUniqueBeanException(beanType.getType(), beanRegistrations.stream().map(reg -> reg.beanDefinition).iterator()));
        }
    }

    @NonNull
    private static String resolveKey(BeanRegistration<?> reg) {
        String name;
        NameResolver resolver;
        BeanDefinition definition = reg.beanDefinition;
        if (definition instanceof NameResolver && (resolver = (NameResolver)definition).resolveName().isPresent()) {
            return (String)resolver.resolveName().get();
        }
        Qualifier declaredQualifier = definition.getDeclaredQualifier();
        if (declaredQualifier != null && (name = Qualifiers.findName(declaredQualifier)) != null) {
            return name;
        }
        Class candidateType = reg.beanDefinition.getBeanType();
        String candidateSimpleName = candidateType.getSimpleName();
        return NameUtils.decapitalize((String)candidateSimpleName);
    }

    @Internal
    public <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanRegistrations(resolutionContext, beanType, qualifier).stream().map(BeanRegistration::getBean);
    }

    @Override
    @NonNull
    public <T> T inject(@NonNull T instance) {
        Objects.requireNonNull(instance, "Instance cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesForInstance(instance);
        BeanDefinition<T> beanDefinition = candidates.size() == 1 ? candidates.iterator().next() : (!candidates.isEmpty() ? this.lastChanceResolve(Argument.of(instance.getClass()), null, true, candidates) : null);
        if (beanDefinition != null && !(beanDefinition instanceof RuntimeBeanDefinition)) {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                BeanKey<T> beanKey = new BeanKey<T>(beanDefinition.getBeanType(), null, new Class[0]);
                resolutionContext.addInFlightBean(beanKey, new BeanRegistration<T>(beanKey, beanDefinition, instance));
                this.doInjectAndInitialize(resolutionContext, instance, beanDefinition);
            }
        }
        return instance;
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.createBean(null, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(Argument.of(beanType), qualifier);
        if (candidate.isPresent()) {
            BeanDefinition<T> beanDefinition = candidate.get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                if (beanDefinition instanceof InstantiatableBeanDefinition) {
                    InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)beanDefinition;
                    T bean = this.resolveByBeanFactory(resolutionContext, instantiatableBeanDefinition, qualifier, argumentValues);
                    T t = this.postBeanCreated(resolutionContext, beanDefinition, qualifier, bean);
                    return t;
                }
            }
        }
        throw this.newNoSuchBeanException(null, Argument.of(beanType), qualifier, null);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Argument beanArg = Argument.of(beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(beanArg, qualifier);
        if (candidate.isPresent()) {
            BeanDefinition<T> definition = candidate.get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(definition, null);){
                T t = this.doCreateBeanWithArguments(resolutionContext, definition, qualifier, args);
                return t;
            }
        }
        throw this.newNoSuchBeanException(null, Argument.of(beanType), qualifier, null);
    }

    @NonNull
    private <T> T doCreateBeanWithArguments(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @Nullable Qualifier<T> qualifier, Object ... args) {
        Map<String, Object> argumentValues = this.resolveArgumentValues(resolutionContext, definition, args);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed bean argument values: {}", argumentValues);
        }
        if (definition instanceof InstantiatableBeanDefinition) {
            InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)definition;
            T bean = this.resolveByBeanFactory(resolutionContext, instantiatableBeanDefinition, qualifier, argumentValues);
            return this.postBeanCreated(resolutionContext, definition, qualifier, bean);
        }
        throw new BeanInstantiationException("BeanDefinition doesn't support creating a new instance of the bean");
    }

    @NonNull
    private <T> Map<String, Object> resolveArgumentValues(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Object[] args) {
        if (!(definition instanceof ParametrizedInstantiatableBeanDefinition)) {
            return null;
        }
        ParametrizedInstantiatableBeanDefinition parametrizedInstantiatableBeanDefinition = (ParametrizedInstantiatableBeanDefinition)definition;
        Argument<Object>[] requiredArguments = parametrizedInstantiatableBeanDefinition.getRequiredArguments();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating bean for parameters: {}", (Object)ArrayUtils.toString((Object[])args));
        }
        MutableConversionService conversionService = this.getConversionService();
        LinkedHashMap argumentValues = CollectionUtils.newLinkedHashMap((int)requiredArguments.length);
        BeanResolutionContext.Path currentPath = resolutionContext.getPath();
        for (int i = 0; i < requiredArguments.length; ++i) {
            Argument<Object> requiredArgument = requiredArguments[i];
            try (BeanResolutionContext.Path ignored = currentPath.pushConstructorResolve(definition, requiredArgument);){
                Class argumentType = requiredArgument.getType();
                if (args.length > i) {
                    Object val = args[i];
                    if (val != null) {
                        if (argumentType.isInstance(val) && !CollectionUtils.isIterableOrMap((Class)argumentType)) {
                            argumentValues.put(requiredArgument.getName(), val);
                            continue;
                        }
                        argumentValues.put(requiredArgument.getName(), conversionService.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + String.valueOf(requiredArgument) + "]. Cannot convert object [" + String.valueOf(val) + "] to required type: " + String.valueOf(argumentType))));
                        continue;
                    }
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + String.valueOf(requiredArgument) + "]. Argument cannot be null");
                }
                Optional<T> existingBean = this.findBean(resolutionContext, argumentType, null);
                if (existingBean.isPresent()) {
                    argumentValues.put(requiredArgument.getName(), existingBean.get());
                    continue;
                }
                if (requiredArgument.isDeclaredNullable()) continue;
                throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + String.valueOf(requiredArgument) + "]. No bean found for type: " + String.valueOf(argumentType));
            }
        }
        return argumentValues;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.findBeanDefinition(beanType, qualifier).map(this::destroyBean).orElse(null);
    }

    @Override
    @NonNull
    public <T> T destroyBean(@NonNull T bean) {
        ArgumentUtils.requireNonNull((String)"bean", bean);
        Optional<BeanRegistration<T>> beanRegistration = this.findBeanRegistration(bean);
        if (beanRegistration.isPresent()) {
            this.destroyBean(beanRegistration.get());
        } else {
            Optional<BeanDefinition<?>> beanDefinition = this.findBeanDefinition(bean.getClass());
            if (beanDefinition.isPresent()) {
                BeanDefinition<?> definition = beanDefinition.get();
                BeanKey key = new BeanKey(definition, definition.getDeclaredQualifier());
                this.destroyBean(BeanRegistration.of(this, key, definition, bean));
            }
        }
        return bean;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.destroyBean(Argument.of(beanType), null);
    }

    @Nullable
    private <T> T destroyBean(@NonNull BeanDefinition<T> beanDefinition) {
        BeanRegistration<T> beanRegistration;
        if (beanDefinition.isSingleton() && (beanRegistration = this.singletonScope.findBeanRegistration(beanDefinition)) != null) {
            this.destroyBean(beanRegistration);
            return beanRegistration.bean;
        }
        throw new IllegalArgumentException("Cannot destroy non-singleton bean using bean definition! Use 'destroyBean(BeanRegistration)` or `destroyBean(<BeanInstance>)`.");
    }

    @Override
    public <T> void destroyBean(@NonNull BeanRegistration<T> registration) {
        this.destroyBean(registration, false);
    }

    private <T> void destroyBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition<T> definition;
        T beanToDestroy;
        block17: {
            if (LOG_LIFECYCLE.isDebugEnabled()) {
                LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", registration.bean, (Object)registration.identifier);
            }
            if (registration.beanDefinition instanceof ProxyBeanDefinition) {
                if (registration.bean instanceof InterceptedBeanProxy) {
                    this.destroyProxyTargetBean(registration, dependent);
                    return;
                }
                if (dependent && registration.beanDefinition.isSingleton()) {
                    return;
                }
            }
            beanToDestroy = registration.getBean();
            definition = registration.getBeanDefinition();
            if (beanToDestroy != null) {
                this.purgeCacheForBeanInstance(beanToDestroy);
                if (definition.isSingleton()) {
                    this.singletonScope.purgeCacheForBeanInstance(definition, beanToDestroy);
                }
            }
            beanToDestroy = this.triggerPreDestroyListeners(definition, beanToDestroy);
            if (definition instanceof DisposableBeanDefinition) {
                try {
                    ((DisposableBeanDefinition)definition).dispose(this, beanToDestroy);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block17;
                    LOG.warn("Error disposing bean [{}]... Continuing...", beanToDestroy, (Object)e);
                }
            }
        }
        if (beanToDestroy instanceof LifeCycle) {
            LifeCycle cycle = (LifeCycle)beanToDestroy;
            if (!dependent) {
                this.destroyLifeCycleBean(cycle, definition);
            }
        }
        if (registration instanceof BeanDisposingRegistration) {
            List<BeanRegistration<?>> dependents = ((BeanDisposingRegistration)registration).getDependents();
            if (CollectionUtils.isNotEmpty(dependents)) {
                ListIterator<BeanRegistration<?>> i = dependents.listIterator(dependents.size());
                while (i.hasPrevious()) {
                    this.destroyBean(i.previous(), true);
                }
            }
        } else {
            try {
                registration.close();
            }
            catch (Exception e) {
                throw new BeanDestructionException(definition, (Throwable)e);
            }
        }
        this.triggerBeanDestroyedListeners(definition, beanToDestroy);
    }

    @Internal
    protected <T> void destroyLifeCycleBean(LifeCycle<?> cycle, BeanDefinition<T> definition) {
        try {
            cycle.stop();
        }
        catch (Exception e) {
            throw new BeanDestructionException(definition, (Throwable)e);
        }
    }

    @NonNull
    private <T> T triggerPreDestroyListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanPreDestroyEventListeners == null) {
            this.beanPreDestroyEventListeners = this.loadListeners(BeanPreDestroyEventListener.class);
        }
        if (!this.beanPreDestroyEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, ListenersSupplier<BeanPreDestroyEventListener>> entry : this.beanPreDestroyEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanPreDestroyEvent<T> event = new BeanPreDestroyEvent<T>(this, beanDefinition, bean);
                for (BeanPreDestroyEventListener listener : entry.getValue().get(null)) {
                    try {
                        bean = Objects.requireNonNull(listener.onPreDestroy(event), "PreDestroy event listener illegally returned null: " + String.valueOf(listener.getClass()));
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
        return bean;
    }

    private <T> void destroyProxyTargetBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition proxyTargetBeanDefinition;
        Optional<CustomScope<?>> declaredScope;
        BeanDisposingRegistration disposingRegistration;
        Set<Object> destroyed = Collections.emptySet();
        if (registration instanceof BeanDisposingRegistration && (disposingRegistration = (BeanDisposingRegistration)registration).getDependents() != null) {
            destroyed = Collections.newSetFromMap(new IdentityHashMap());
            for (BeanRegistration<?> beanRegistration : disposingRegistration.getDependents()) {
                this.destroyBean(beanRegistration, true);
                destroyed.add(beanRegistration.bean);
            }
        }
        if ((declaredScope = this.customScopeRegistry.findDeclaredScope(proxyTargetBeanDefinition = this.findProxyTargetBeanDefinition(registration.beanDefinition).orElseThrow(() -> new IllegalStateException("Cannot find a proxy target bean definition for: " + String.valueOf(registration.beanDefinition))))).isEmpty()) {
            InterceptedBeanProxy interceptedProxy;
            if (proxyTargetBeanDefinition.isSingleton()) {
                return;
            }
            if (registration.bean instanceof InterceptedBeanProxy && (interceptedProxy = (InterceptedBeanProxy)registration.bean).hasCachedInterceptedTarget()) {
                Object interceptedTarget = interceptedProxy.interceptedTarget();
                if (destroyed.contains(interceptedTarget)) {
                    return;
                }
                this.destroyBean(BeanRegistration.of(this, new BeanKey(proxyTargetBeanDefinition, proxyTargetBeanDefinition.getDeclaredQualifier()), proxyTargetBeanDefinition, interceptedTarget, registration instanceof BeanDisposingRegistration ? ((BeanDisposingRegistration)registration).getDependents() : null));
            }
            return;
        }
        CustomScope<?> customScope = declaredScope.get();
        if (dependent) {
            return;
        }
        Optional targetBeanRegistration = customScope.findBeanRegistration(proxyTargetBeanDefinition);
        if (targetBeanRegistration.isPresent()) {
            BeanRegistration targetRegistration = targetBeanRegistration.get();
            customScope.remove(targetRegistration.identifier);
        }
    }

    @NonNull
    private <T> void triggerBeanDestroyedListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanDestroyedEventListeners == null) {
            this.beanDestroyedEventListeners = this.loadListeners(BeanDestroyedEventListener.class);
        }
        if (!this.beanDestroyedEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, ListenersSupplier<BeanDestroyedEventListener>> entry : this.beanDestroyedEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanDestroyedEvent<T> event = new BeanDestroyedEvent<T>(this, beanDefinition, bean);
                for (BeanDestroyedEventListener listener : entry.getValue().get(null)) {
                    try {
                        listener.onDestroyed(event);
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
    }

    @NonNull
    private <T> Class<T> getBeanType(@NonNull BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof ProxyBeanDefinition) {
            return ((ProxyBeanDefinition)beanDefinition).getTargetType();
        }
        return beanDefinition.getBeanType();
    }

    @Nullable
    protected <T> BeanRegistration<T> getActiveBeanRegistration(BeanDefinition<T> beanDefinition, Qualifier qualifier) {
        if (beanDefinition == null) {
            return null;
        }
        return this.singletonScope.findBeanRegistration(beanDefinition, qualifier);
    }

    @NonNull
    protected <T> T createBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> candidate = concreteCandidate.get();
            try (BeanResolutionContext context = this.newResolutionContext(candidate, resolutionContext);){
                if (candidate instanceof InstantiatableBeanDefinition) {
                    InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)candidate;
                    T bean = this.resolveByBeanFactory(context, instantiatableBeanDefinition, qualifier, Collections.emptyMap());
                    T t = this.postBeanCreated(context, candidate, qualifier, bean);
                    return t;
                }
                throw new BeanInstantiationException("BeanDefinition doesn't support creating a new instance of the bean");
            }
        }
        throw this.newNoSuchBeanException(resolutionContext, Argument.of(beanType), qualifier, null);
    }

    @Internal
    @NonNull
    protected <T> T inject(@NonNull BeanResolutionContext resolutionContext, @Nullable BeanDefinition<?> requestingBeanDefinition, @NonNull T instance) {
        Class<?> beanType = instance.getClass();
        Optional<BeanDefinition<?>> concreteCandidate = this.findBeanDefinition(beanType, null);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<?> definition = concreteCandidate.get();
            if (requestingBeanDefinition != null && requestingBeanDefinition.equals(definition)) {
                return instance;
            }
            this.doInjectAndInitialize(resolutionContext, instance, definition);
        }
        return instance;
    }

    @NonNull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType) {
        return this.getBeansOfType(resolutionContext, beanType, null);
    }

    @Internal
    @NonNull
    public <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations = this.getBeanRegistrations(resolutionContext, beanType, qualifier);
        ArrayList<T> list = new ArrayList<T>(beanRegistrations.size());
        for (BeanRegistration<T> beanRegistration : beanRegistrations) {
            list.add(beanRegistration.getBean());
        }
        return list;
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getProxyTargetBean(null, Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getProxyTargetBean(null, beanType, qualifier);
    }

    @NonNull
    public <T> T getProxyTargetBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, definition, beanType, qualifier).bean;
    }

    @Internal
    @NonNull
    public <T> T getProxyTargetBean(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, definition, beanType, qualifier).bean;
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, @NonNull String method, @NonNull Class<?>[] arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, null);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class<?> ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Argument<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class<?> ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanCandidateKey<T> key = new BeanCandidateKey<T>(beanType, qualifier, true);
        Optional<BeanDefinition<T>> beanDefinition = this.beanProxyTargetCache.get(key);
        if (beanDefinition == null) {
            beanDefinition = this.findProxyTargetNoCache(null, beanType, qualifier);
            this.beanProxyTargetCache.put(key, beanDefinition);
        }
        return beanDefinition;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nullable Qualifier<Object> qualifier) {
        Collection<BeanDefinition<Object>> candidates;
        if (qualifier == null) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for qualifier: {}", qualifier);
        }
        if (this.beanDefinitionsClasses.isEmpty()) {
            return Collections.emptyList();
        }
        if (qualifier instanceof FilteringQualifier) {
            FilteringQualifier filteringQualifier = (FilteringQualifier)qualifier;
            ArrayList bdCandidates = new ArrayList(20);
            for (BeanDefinitionProducer producer : this.beanDefinitionsClasses) {
                BeanDefinition beanDefinition;
                BeanDefinitionReference reference = producer.getReferenceIfEnabled(this);
                if (reference == null || !filteringQualifier.doesQualify(Object.class, reference) || !(beanDefinition = reference.load(this)).isEnabled(this) || !filteringQualifier.doesQualify(Object.class, beanDefinition)) continue;
                bdCandidates.add(beanDefinition);
            }
            candidates = bdCandidates;
        } else {
            Stream<BeanDefinitionReference> reduced = qualifier.reduce(Object.class, this.beanDefinitionsClasses.stream().map(p -> p.getReferenceIfEnabled(this)).filter(Objects::nonNull));
            Stream<BeanDefinition> candidateStream = qualifier.reduce(Object.class, reduced.map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)));
            candidates = candidateStream.collect(Collectors.toList());
        }
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(null, candidates);
        }
        return candidates;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding all bean definitions");
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            return this.beanDefinitionsClasses.stream().map(p -> p.getDefinitionIfEnabled(this)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return (Collection)((Object)Collections.emptyMap());
    }

    @Override
    public Collection<DisabledBean<?>> getDisabledBeans() {
        return this.disabledBeans.values().stream().map(producer -> (DisabledBean)producer.reference).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences() {
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinitionReference<?>> refs = this.beanDefinitionsClasses.stream().map(p -> p.getReferenceIfEnabled(this)).filter(Objects::nonNull).toList();
            return refs;
        }
        return Collections.emptyList();
    }

    @Override
    public BeanContext registerBeanConfiguration(BeanConfiguration configuration) {
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        this.beanConfigurations.put(configuration.getName(), configuration);
        return this;
    }

    @Override
    @NonNull
    public <B> BeanContext registerBeanDefinition(@NonNull RuntimeBeanDefinition<B> definition) {
        Objects.requireNonNull(definition, "Bean definition cannot be null");
        Class beanType = definition.getBeanType();
        BeanDefinitionProducer producer = new BeanDefinitionProducer(definition);
        this.beanDefinitionsClasses.add(producer);
        for (Class clazz : this.indexedTypes) {
            if (clazz != beanType && !clazz.isAssignableFrom(beanType)) continue;
            Collection<BeanDefinitionProducer> indexed = this.resolveTypeIndex(clazz);
            indexed.add(producer);
            break;
        }
        this.purgeCacheForBeanType(beanType);
        return this;
    }

    private <B> void purgeCacheForBeanType(Class<B> beanType) {
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isAssignableFrom(beanType));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isAssignableFrom(beanType));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(beanType));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(beanType));
    }

    @Internal
    <B> void removeBeanDefinition(RuntimeBeanDefinition<B> definition) {
        Class beanType = definition.getBeanType();
        for (Class clazz : this.indexedTypes) {
            if (clazz != beanType && !clazz.isAssignableFrom(beanType)) continue;
            this.resolveTypeIndex(clazz).forEach(p -> p.disableIfMatch(definition));
            break;
        }
        this.beanDefinitionsClasses.forEach(p -> p.disableIfMatch(definition));
        this.purgeCacheForBeanType(definition.getBeanType());
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBean(resolutionContext, Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull BeanDefinition<T> definition) {
        ArgumentUtils.requireNonNull((String)"definition", definition);
        return this.resolveBeanRegistration(null, definition).bean;
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanType, qualifier, (boolean)true).bean;
    }

    @Internal
    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanDefinition", beanDefinition);
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanDefinition, beanType, qualifier).bean;
    }

    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @Internal
    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        if (this.thisInterfaces.contains(beanType.getType())) {
            return Optional.of(this);
        }
        try {
            BeanRegistration<T> beanRegistration = this.resolveBeanRegistration(resolutionContext, beanType, qualifier, false);
            if (beanRegistration == null || beanRegistration.bean == null) {
                return Optional.empty();
            }
            return Optional.of(beanRegistration.bean);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            return Optional.empty();
        }
    }

    @Override
    public BeanContextConfiguration getContextConfiguration() {
        return this.beanContextConfiguration;
    }

    @Override
    public void publishEvent(@NonNull Object event) {
        if (event != null) {
            ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEvent(event);
        }
    }

    @Override
    @NonNull
    public Future<Void> publishEventAsync(@NonNull Object event) {
        Objects.requireNonNull(event, "Event cannot be null");
        return ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEventAsync(event);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.findProxyBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        for (BeanDefinition<T> beanDefinition : this.getBeanDefinitions(beanType, qualifier)) {
            if (!beanDefinition.isProxy()) continue;
            return Optional.of(beanDefinition);
        }
        return Optional.empty();
    }

    @Internal
    protected void invalidateCaches() {
        this.beanCandidateCache.clear();
        this.beanConcreteCandidateCache.clear();
        this.singletonBeanRegistrations.clear();
    }

    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.beanDefinitionReferences == null) {
            this.beanDefinitionReferences = MicronautMetaServiceLoaderUtils.findMetaMicronautServiceEntries((ClassLoader)this.classLoader, BeanDefinitionReference.class, BeanDefinitionReference::isPresent);
        }
        return this.beanDefinitionReferences;
    }

    @NonNull
    @Deprecated
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(@Nullable Predicate<BeanDefinitionReference> predicate) {
        if (predicate != null) {
            List<BeanDefinitionReference> allRefs = this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionReference> newRefs = new ArrayList<BeanDefinitionReference>(allRefs.size());
            for (BeanDefinitionReference reference : allRefs) {
                if (!predicate.test(reference)) continue;
                newRefs.add(reference);
            }
            return newRefs;
        }
        return this.resolveBeanDefinitionReferences();
    }

    @NonNull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.beanConfigurationsList == null) {
            this.beanConfigurationsList = MicronautMetaServiceLoaderUtils.findMetaMicronautServiceEntries((ClassLoader)this.classLoader, BeanConfiguration.class, null);
        }
        return this.beanConfigurationsList;
    }

    protected void initializeEventListeners() {
        this.beanCreationEventListeners = this.loadListeners(BeanCreatedEventListener.class);
        this.beanCreationEventListeners.add(new AbstractMap.SimpleEntry<Class<AnnotationProcessor>, AnnotationProcessorListenersSupplier>(AnnotationProcessor.class, new AnnotationProcessorListenersSupplier()));
        this.beanInitializedEventListeners = this.loadListeners(BeanInitializedEventListener.class);
    }

    @NonNull
    private <T extends EventListener> List<Map.Entry<Class<?>, ListenersSupplier<T>>> loadListeners(@NonNull Class<T> listenerType) {
        Map<Class<?>, List<BeanDefinition<T>>> typeToListener = this.getTypeToListenerMap(listenerType);
        if (typeToListener.isEmpty()) {
            return new ArrayList(1);
        }
        ArrayList eventToListeners = new ArrayList(typeToListener.size());
        for (Map.Entry<Class<?>, List<BeanDefinition<T>>> e : typeToListener.entrySet()) {
            eventToListeners.add(new AbstractMap.SimpleEntry(e.getKey(), new EventListenerListenersSupplier<T>(Argument.of(listenerType, (Class[])new Class[]{e.getKey()}), e.getValue())));
        }
        return eventToListeners;
    }

    @NonNull
    private <T extends EventListener> Map<Class<?>, List<BeanDefinition<T>>> getTypeToListenerMap(@NonNull Class<T> listenerType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.getBeanDefinitions(listenerType);
        if (beanDefinitions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap typeToListener = CollectionUtils.newHashMap((int)beanDefinitions.size());
        for (BeanDefinition<T> beanCreatedDefinition : beanDefinitions) {
            List<Argument<T>> typeArguments = beanCreatedDefinition.getTypeArguments(listenerType);
            Argument argument = (Argument)CollectionUtils.last(typeArguments);
            if (argument == null) {
                argument = Argument.OBJECT_ARGUMENT;
            }
            typeToListener.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(beanCreatedDefinition);
        }
        return typeToListener;
    }

    @Internal
    protected void initializeContext(@NonNull List<BeanDefinitionProducer> eagerInitBeans, @NonNull List<BeanDefinitionProducer> processedBeans, @NonNull List<BeanDefinitionProducer> parallelBeans) {
        if (CollectionUtils.isNotEmpty(eagerInitBeans)) {
            ArrayList<BeanDefinition<Object>> eagerInit = new ArrayList<BeanDefinition<Object>>(eagerInitBeans.size());
            for (BeanDefinitionProducer beanDefinitionProducer : eagerInitBeans) {
                try {
                    this.loadEagerBeans(beanDefinitionProducer, eagerInit);
                }
                catch (Throwable throwable) {
                    BeanDefinitionReference<?> ref = beanDefinitionProducer.getReferenceBestEffort();
                    throw new BeanInstantiationException(MSG_BEAN_DEFINITION + (ref == null ? "<ref discarded>" : ref.getName()) + MSG_COULD_NOT_BE_LOADED + throwable.getMessage(), throwable);
                }
            }
            this.filterReplacedBeans(null, eagerInit);
            OrderUtil.sortOrdered(eagerInit);
            for (BeanDefinition beanDefinition : eagerInit) {
                try {
                    this.initializeEagerBean(beanDefinition);
                }
                catch (DisabledBeanException disabledBeanException) {
                    if (!AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) continue;
                    AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanDefinition.getBeanType().getSimpleName(), (Object)disabledBeanException.getMessage());
                }
                catch (Throwable throwable) {
                    throw new BeanInstantiationException(MSG_BEAN_DEFINITION + beanDefinition.getName() + MSG_COULD_NOT_BE_LOADED + throwable.getMessage(), throwable);
                }
            }
        }
        if (!processedBeans.isEmpty()) {
            ArrayList methodsToProcess = new ArrayList();
            for (BeanDefinitionProducer beanDefinitionProducer : processedBeans) {
                BeanDefinition beanDefinition = beanDefinitionProducer.getDefinitionIfEnabled(this);
                if (beanDefinition == null) continue;
                for (ExecutableMethod method : beanDefinition.getExecutableMethods()) {
                    if (!method.hasStereotype(Executable.class)) continue;
                    methodsToProcess.add(BeanDefinitionMethodReference.of(beanDefinition, method));
                }
            }
            HashMap byAnnotation = CollectionUtils.newHashMap((int)methodsToProcess.size());
            for (BeanDefinitionMethodReference beanDefinitionMethodReference : methodsToProcess) {
                List annotations = beanDefinitionMethodReference.getAnnotationTypesByStereotype(Executable.class);
                for (Class annotation : annotations) {
                    ArrayList<BeanDefinitionMethodReference> references = (ArrayList<BeanDefinitionMethodReference>)byAnnotation.get(annotation);
                    if (references == null) {
                        references = new ArrayList<BeanDefinitionMethodReference>(10);
                        byAnnotation.put(annotation, references);
                    }
                    references.add(beanDefinitionMethodReference);
                }
            }
            for (Map.Entry entry : byAnnotation.entrySet()) {
                Class annotationType = (Class)entry.getKey();
                List methods = (List)entry.getValue();
                this.streamOfType(ExecutableMethodProcessor.class, Qualifiers.byTypeArguments(annotationType)).forEach(processor -> {
                    Object cycle;
                    if (processor instanceof LifeCycle) {
                        cycle = (LifeCycle)((Object)processor);
                        cycle.start();
                    }
                    for (BeanDefinitionMethodReference method : methods) {
                        BeanDefinition beanDefinition = method.getBeanDefinition();
                        if (beanDefinition.hasStereotype(annotationType)) continue;
                        if (method.hasDeclaredStereotype(Parallel.class)) {
                            ForkJoinPool.commonPool().execute(() -> {
                                block3: {
                                    try {
                                        processor.process((BeanDefinition<?>)beanDefinition, method);
                                    }
                                    catch (Throwable e) {
                                        Boolean shutdownOnError;
                                        if (LOG.isErrorEnabled()) {
                                            LOG.error("Error processing bean method {}.{} with processor ({}): {}", new Object[]{beanDefinition, method, processor, e.getMessage(), e});
                                        }
                                        if (!(shutdownOnError = method.booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block3;
                                        this.stop();
                                    }
                                }
                            });
                            continue;
                        }
                        processor.process((BeanDefinition<?>)beanDefinition, method);
                    }
                    if (processor instanceof LifeCycle) {
                        cycle = (LifeCycle)((Object)processor);
                        cycle.stop();
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(parallelBeans)) {
            this.processParallelBeans(parallelBeans);
        }
        ForkJoinPool.commonPool().execute(() -> this.beanDefinitionsClasses.forEach(p -> p.getReferenceIfEnabled(this)));
    }

    @NonNull
    @Internal
    public final <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable BeanDefinition<?> filter) {
        Predicate<BeanDefinition<BeanDefinition<BeanDefinition<BeanDefinition<T>>>>> predicate = filter == null ? null : definition -> !definition.equals(filter);
        return this.findBeanCandidates(resolutionContext, beanType, true, predicate);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, boolean collectIterables, Predicate<BeanDefinition<T>> predicate) {
        Collection<BeanDefinitionProducer> beanDefinitionsClasses;
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Class beanClass = beanType.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for type: {}", beanType);
        }
        if (this.indexedTypes.contains(beanClass)) {
            beanDefinitionsClasses = this.beanIndex.get(beanClass);
            if (beanDefinitionsClasses == null) {
                beanDefinitionsClasses = Collections.emptyList();
            }
        } else {
            beanDefinitionsClasses = this.beanDefinitionsClasses;
        }
        return this.collectBeanCandidates(resolutionContext, beanType, collectIterables, predicate, beanDefinitionsClasses);
    }

    @NonNull
    private <T> Set<BeanDefinition<T>> collectBeanCandidates(BeanResolutionContext resolutionContext, Argument<T> beanType, boolean collectIterables, @Nullable Predicate<BeanDefinition<T>> predicate, Collection<BeanDefinitionProducer> beanDefinitionProducers) {
        Set<BeanDefinition<T>> candidates;
        if (!beanDefinitionProducers.isEmpty()) {
            candidates = new HashSet();
            for (BeanDefinitionProducer beanDefinitionProducer : beanDefinitionProducers) {
                BeanDefinition<T> loadedBean;
                if (beanDefinitionProducer.isDisabledOptimistic() || !beanDefinitionProducer.isReferenceCandidateBean(beanType) || (loadedBean = beanDefinitionProducer.getDefinitionIfEnabled(this, null, beanType, predicate)) == null) continue;
                if (collectIterables && loadedBean.isConfigurationProperties()) {
                    this.collectIterableBeans(resolutionContext, loadedBean, candidates, beanType);
                    continue;
                }
                candidates.add(loadedBean);
            }
            if (!candidates.isEmpty()) {
                this.filterReplacedBeans(resolutionContext, candidates);
            }
        } else {
            candidates = Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOG.debug("No bean candidates found for type: {}", beanType);
            } else {
                for (BeanDefinition beanDefinition : candidates) {
                    LOG.debug("  {} {} {}", new Object[]{beanDefinition.getBeanType(), beanDefinition.getDeclaredQualifier(), beanDefinition});
                }
            }
        }
        return candidates;
    }

    protected <T> void collectIterableBeans(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> iterableBean, @NonNull Set<BeanDefinition<T>> targetSet, @NonNull Argument<T> beanType) {
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidatesForInstance(@NonNull T instance) {
        ArgumentUtils.requireNonNull((String)"instance", instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for instance: {}", instance);
        }
        Collection<BeanDefinitionProducer> beanProducers = this.beanDefinitionsClasses;
        Class<?> beanClass = instance.getClass();
        Argument beanType = Argument.of(beanClass);
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions != null) {
            return beanDefinitions;
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            ArrayList<BeanDefinition<Object>> candidates = new ArrayList<BeanDefinition<T>>();
            for (BeanDefinitionProducer producer : beanProducers) {
                BeanDefinition candidate;
                Class candidateType;
                BeanDefinitionReference beanDefinitionReference;
                if (producer.isDisabledOptimistic() || (beanDefinitionReference = producer.getReferenceIfEnabled(this)) == null || (candidateType = beanDefinitionReference.getBeanType()) == null || !candidateType.isInstance(instance) || (candidate = producer.getDefinitionIfEnabled(this)) == null) continue;
                candidates.add(candidate);
            }
            if (candidates.size() > 1) {
                ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>(2);
                for (BeanDefinition beanDefinition : candidates) {
                    if (beanDefinition.getBeanType() != beanClass) continue;
                    list.add(beanDefinition);
                }
                candidates = list;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved bean candidates {} for instance: {}", candidates, instance);
            }
            beanDefinitions = candidates;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No bean candidates found for instance: {}", instance);
            }
            beanDefinitions = Collections.emptySet();
        }
        this.beanCandidateCache.put(beanType, beanDefinitions);
        return beanDefinitions;
    }

    protected synchronized void registerConfiguration(@NonNull BeanConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.beanConfigurations.put(configuration.getName(), configuration);
    }

    @NonNull
    private <T> T resolveByBeanFactory(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        Qualifier<T> declaredQualifier = beanDefinition.getDeclaredQualifier();
        Qualifier<?> prevQualifier = resolutionContext.getCurrentQualifier();
        try {
            Object bean;
            resolutionContext.setCurrentQualifier(declaredQualifier != null && !AnyQualifier.INSTANCE.equals(declaredQualifier) ? declaredQualifier : qualifier);
            if (beanDefinition instanceof ParametrizedInstantiatableBeanDefinition) {
                ParametrizedInstantiatableBeanDefinition parametrizedInstantiatableBeanDefinition = (ParametrizedInstantiatableBeanDefinition)beanDefinition;
                Argument<Object>[] requiredArguments = parametrizedInstantiatableBeanDefinition.getRequiredArguments();
                Map<String, Object> convertedValues = this.getRequiredArgumentValues(resolutionContext, requiredArguments, argumentValues, beanDefinition);
                bean = parametrizedInstantiatableBeanDefinition.instantiate(resolutionContext, this, convertedValues);
            } else if (beanDefinition instanceof InstantiatableBeanDefinition) {
                InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)beanDefinition;
                bean = instantiatableBeanDefinition.instantiate(resolutionContext, this);
            } else {
                throw new BeanInstantiationException(resolutionContext, "Expected InstantiatableBeanDefinition [" + String.valueOf(beanDefinition) + "]");
            }
            if (bean == null) {
                throw new BeanInstantiationException(resolutionContext, "InstantiatableBeanDefinition [" + String.valueOf(beanDefinition) + "] returned null");
            }
            if (bean instanceof Qualified) {
                Qualified qualified = (Qualified)bean;
                qualified.$withBeanQualifier(declaredQualifier);
            }
            Object t = bean;
            return t;
        }
        catch (BeanInstantiationException | DependencyInjectionException | DisabledBeanException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!resolutionContext.getPath().isEmpty()) {
                throw new BeanInstantiationException(resolutionContext, e);
            }
            throw new BeanInstantiationException(beanDefinition, e);
        }
        finally {
            resolutionContext.setCurrentQualifier(prevQualifier);
        }
    }

    @NonNull
    private <T> T postBeanCreated(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @NonNull T bean) {
        Qualifier<T> finalQualifier = qualifier != null ? qualifier : beanDefinition.getDeclaredQualifier();
        bean = this.triggerBeanCreatedEventListener(resolutionContext, beanDefinition, bean, finalQualifier);
        if (beanDefinition instanceof ValidatedBeanDefinition) {
            ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)beanDefinition;
            bean = validatedBeanDefinition.validate(resolutionContext, bean);
        }
        if (LOG_LIFECYCLE.isDebugEnabled()) {
            LOG_LIFECYCLE.debug("Created bean [{}] from definition [{}] with qualifier [{}]", new Object[]{bean, beanDefinition, finalQualifier});
        }
        return bean;
    }

    @NonNull
    private <T> T triggerBeanCreatedEventListener(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull T bean, @Nullable Qualifier<T> finalQualifier) {
        if (!(beanDefinition instanceof AbstractProviderDefinition)) {
            Class<T> beanType = beanDefinition.getBeanType();
            if (!(bean instanceof BeanCreatedEventListener) && CollectionUtils.isNotEmpty(this.beanCreationEventListeners)) {
                for (Map.Entry<Class<?>, ListenersSupplier<BeanCreatedEventListener>> entry : this.beanCreationEventListeners) {
                    if (!entry.getKey().isAssignableFrom(beanType)) continue;
                    BeanKey<T> beanKey = new BeanKey<T>(beanDefinition, finalQualifier);
                    for (BeanCreatedEventListener listener : entry.getValue().get(resolutionContext)) {
                        bean = listener.onCreated(new BeanCreatedEvent<T>(this, beanDefinition, beanKey, bean));
                        if (bean != null) continue;
                        throw new BeanInstantiationException(resolutionContext, "Listener [" + String.valueOf(listener) + "] returned null from onCreated event");
                    }
                }
            }
        }
        return bean;
    }

    @NonNull
    private <T> Map<String, Object> getRequiredArgumentValues(@NonNull BeanResolutionContext resolutionContext, @NonNull Argument<?>[] requiredArguments, @Nullable Map<String, Object> argumentValues, @NonNull BeanDefinition<T> beanDefinition) {
        LinkedHashMap convertedValues;
        if (argumentValues == null) {
            convertedValues = requiredArguments.length == 0 ? null : CollectionUtils.newLinkedHashMap((int)requiredArguments.length);
            argumentValues = Collections.emptyMap();
        } else {
            convertedValues = CollectionUtils.newLinkedHashMap((int)requiredArguments.length);
        }
        if (convertedValues == null) {
            return Collections.emptyMap();
        }
        MutableConversionService conversionService = this.getConversionService();
        for (Argument<?> requiredArgument : requiredArguments) {
            String argumentName = requiredArgument.getName();
            Object val = argumentValues.get(argumentName);
            if (val == null) {
                if (requiredArgument.isDeclaredNullable()) continue;
                throw new BeanInstantiationException(resolutionContext, "Missing bean argument [" + String.valueOf(requiredArgument) + "] for type: " + beanDefinition.getBeanType().getName() + ". Required arguments: " + ArrayUtils.toString((Object[])requiredArguments));
            }
            Object convertedValue = requiredArgument.getType().isInstance(val) ? val : conversionService.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean argument [" + String.valueOf(requiredArgument) + "]. Cannot convert object [" + String.valueOf(val) + "] to required type: " + String.valueOf(requiredArgument.getType())));
            convertedValues.put(argumentName, convertedValue);
        }
        return convertedValues;
    }

    @NonNull
    protected <T> BeanDefinition<T> findConcreteCandidate(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanDefinition<T>> candidates) {
        if (qualifier instanceof AnyQualifier) {
            return candidates.iterator().next();
        }
        throw new NonUniqueBeanException(beanType, candidates.iterator());
    }

    @Internal
    protected void processParallelBeans(List<BeanDefinitionProducer> parallelBeans) {
        List<BeanDefinitionProducer> finalParallelBeans;
        if (!parallelBeans.isEmpty() && !(finalParallelBeans = parallelBeans.stream().filter(p -> p.getReferenceIfEnabled(this) != null).toList()).isEmpty()) {
            new Thread(() -> {
                ArrayList<BeanDefinition<BeanDefinition>> parallelDefinitions = new ArrayList<BeanDefinition<BeanDefinition>>();
                finalParallelBeans.forEach(producer -> {
                    block2: {
                        try {
                            this.loadEagerBeans((BeanDefinitionProducer)producer, (Collection<BeanDefinition<Object>>)parallelDefinitions);
                        }
                        catch (Throwable e) {
                            boolean shutdownOnError;
                            BeanDefinitionReference<?> beanDefinitionReference = producer.getReferenceBestEffort();
                            LOG.error("Parallel Bean definition [{}{}{}]", new Object[]{beanDefinitionReference == null ? "<ref discarded>" : beanDefinitionReference.getName(), MSG_COULD_NOT_BE_LOADED, e.getMessage(), e});
                            boolean bl = shutdownOnError = beanDefinitionReference != null && beanDefinitionReference.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true) != false;
                            if (!shutdownOnError) break block2;
                            this.stop();
                        }
                    }
                });
                this.filterReplacedBeans(null, parallelDefinitions);
                parallelDefinitions.forEach(beanDefinition -> ForkJoinPool.commonPool().execute(() -> {
                    block2: {
                        try {
                            this.initializeEagerBean((BeanDefinition<Object>)beanDefinition);
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [{}{}{}]", new Object[]{beanDefinition.getName(), MSG_COULD_NOT_BE_LOADED, e.getMessage(), e});
                            Boolean shutdownOnError = beanDefinition.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block2;
                            this.stop();
                        }
                    }
                }));
                parallelDefinitions.clear();
            }).start();
        }
    }

    private <T> void filterReplacedBeans(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates) {
        if (candidates.size() > 1) {
            ArrayList replacementTypes = new ArrayList(2);
            for (BeanDefinition<T> candidate : candidates) {
                if (!candidate.getAnnotationMetadata().hasStereotype(REPLACES_ANN)) continue;
                replacementTypes.add(candidate);
            }
            if (!replacementTypes.isEmpty()) {
                candidates.removeIf(definition -> this.checkIfReplacementExists(resolutionContext, replacementTypes, (BeanDefinition)definition));
            }
        }
    }

    private <T> boolean checkIfReplacementExists(BeanResolutionContext resolutionContext, List<BeanDefinition<T>> replacementTypes, BeanDefinition<T> definitionToBeReplaced) {
        if (!definitionToBeReplaced.isEnabled(this, resolutionContext)) {
            return true;
        }
        AnnotationMetadata annotationMetadata = definitionToBeReplaced.getAnnotationMetadata();
        if (annotationMetadata.hasDeclaredStereotype(Infrastructure.class)) {
            return false;
        }
        for (BeanDefinition<T> replacementType : replacementTypes) {
            if (!this.isNotTheSameDefinition(replacementType, definitionToBeReplaced) || !this.isNotProxy(replacementType, definitionToBeReplaced) || !this.checkIfReplaces(replacementType, definitionToBeReplaced, annotationMetadata)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean isNotTheSameDefinition(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced) {
        BeanDefinitionDelegate beanDefinitionDelegate;
        if (replacingCandidate instanceof BeanDefinitionDelegate) {
            beanDefinitionDelegate = (BeanDefinitionDelegate)replacingCandidate;
            replacingCandidate = beanDefinitionDelegate.getDelegate();
        }
        if (definitionToBeReplaced instanceof BeanDefinitionDelegate) {
            beanDefinitionDelegate = (BeanDefinitionDelegate)definitionToBeReplaced;
            definitionToBeReplaced = beanDefinitionDelegate.getDelegate();
        }
        return replacingCandidate != definitionToBeReplaced;
    }

    private <T> boolean isNotProxy(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced) {
        return !(replacingCandidate instanceof ProxyBeanDefinition) || ((ProxyBeanDefinition)replacingCandidate).getTargetDefinitionType() != definitionToBeReplaced.getClass();
    }

    private <T> boolean checkIfReplaces(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata) {
        AnnotationValue replacesAnnotation = replacingCandidate.getAnnotation(Replaces.class);
        Class<T> replacedBeanType = replacesAnnotation.classValue("bean").orElse(this.getCanonicalBeanType(replacingCandidate));
        Optional named = replacesAnnotation.stringValue("named");
        Optional qualifier = replacesAnnotation.annotationClassValue("qualifier");
        if (named.isPresent() && qualifier.isPresent()) {
            throw new ConfigurationException("Both \"named\" and \"qualifier\" should not be present: " + String.valueOf(replacesAnnotation));
        }
        if (named.isPresent()) {
            String name = (String)named.get();
            if (this.qualifiedByNamed(definitionToBeReplaced, replacedBeanType, name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by name [{}]", new Object[]{replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), name});
                }
                return true;
            }
            return false;
        }
        if (qualifier.isPresent()) {
            AnnotationClassValue qualifierClassValue = (AnnotationClassValue)qualifier.get();
            if (this.qualifiedByQualifier(definitionToBeReplaced, replacedBeanType, qualifierClassValue)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by qualifier [{}]", new Object[]{replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), qualifierClassValue});
                }
                return true;
            }
            return false;
        }
        Optional factory = replacesAnnotation.classValue("factory");
        if (factory.isPresent()) {
            Optional<Class<?>> declaringType = definitionToBeReplaced.getDeclaringType();
            if (declaringType.isPresent()) {
                boolean factoryReplaces;
                Class factoryClass = (Class)factory.get();
                boolean bl = factoryReplaces = factoryClass == declaringType.get() && this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
                if (factoryReplaces) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Bean [{}] replaces existing bean of type [{}] in factory type [{}]", new Object[]{replacingCandidate.getBeanType(), replacedBeanType, factoryClass});
                    }
                    return true;
                }
            }
            return false;
        }
        boolean isTypeMatches = this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
        if (isTypeMatches && LOG.isDebugEnabled()) {
            LOG.debug("Bean [{}] replaces existing bean of type [{}]", replacingCandidate.getBeanType(), replacedBeanType);
        }
        return isTypeMatches;
    }

    private <T> boolean qualifiedByQualifier(BeanDefinition<T> definitionToBeReplaced, Class<T> replacedBeanType, AnnotationClassValue<?> qualifier) {
        Class qualifierClass = qualifier.getType().orElse(null);
        if (qualifierClass != null && !qualifierClass.isAssignableFrom(Annotation.class)) {
            return Qualifiers.byStereotype(qualifierClass).doesQualify(replacedBeanType, definitionToBeReplaced);
        }
        throw new ConfigurationException("Default qualifier value was used while replacing %s".formatted(replacedBeanType));
    }

    private <T> boolean qualifiedByNamed(BeanType<T> definitionToBeReplaced, Class<T> replacedBeanType, String named) {
        return Qualifiers.byName(named).doesQualify(replacedBeanType, definitionToBeReplaced);
    }

    private <T> Class<T> getCanonicalBeanType(BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof BeanDefinitionDelegate) {
            BeanDefinitionDelegate beanDefinitionDelegate = (BeanDefinitionDelegate)beanDefinition;
            beanDefinition = beanDefinitionDelegate.getDelegate();
        }
        if (beanDefinition instanceof AdvisedBeanType) {
            AdvisedBeanType advisedBeanType = (AdvisedBeanType)((Object)beanDefinition);
            return advisedBeanType.getInterceptedType();
        }
        if (beanDefinition instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)beanDefinition;
            return proxyBeanDefinition.getTargetType();
        }
        return beanDefinition.getBeanType();
    }

    private <T> boolean checkIfTypeMatches(BeanDefinition<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata, Class replacingCandidate) {
        Class bt = this.getCanonicalBeanType(definitionToBeReplaced);
        if (annotationMetadata.hasAnnotation(DefaultImplementation.class)) {
            Optional defaultImpl = annotationMetadata.classValue(DefaultImplementation.class);
            if (defaultImpl.isEmpty()) {
                defaultImpl = annotationMetadata.classValue(DefaultImplementation.class, "name");
            }
            if (defaultImpl.filter(impl -> impl == bt).isPresent()) {
                return replacingCandidate.isAssignableFrom(bt);
            }
            return replacingCandidate == bt;
        }
        return replacingCandidate != Object.class && replacingCandidate.isAssignableFrom(bt);
    }

    private <T> void doInjectAndInitialize(BeanResolutionContext resolutionContext, T instance, BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)beanDefinition;
            injectableBeanDefinition.inject(resolutionContext, this, instance);
            if (beanDefinition instanceof InitializingBeanDefinition) {
                InitializingBeanDefinition initializingBeanDefinition = (InitializingBeanDefinition)beanDefinition;
                initializingBeanDefinition.initialize(resolutionContext, this, instance);
            }
        } else {
            throw new BeanContextException(MSG_BEAN_DEFINITION + String.valueOf(beanDefinition) + "] doesn't support injection!");
        }
    }

    private void loadEagerBeans(BeanDefinitionProducer producer, Collection<BeanDefinition<Object>> collector) {
        BeanDefinitionReference reference = producer.getReferenceIfEnabled(this, null);
        if (reference != null) {
            BeanDefinition beanDefinition = reference.load(this);
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                if (beanDefinition.isEnabled(this, resolutionContext)) {
                    collector.add(beanDefinition);
                }
            }
        }
    }

    private void initializeEagerBean(BeanDefinition<Object> beanDefinition) {
        if (beanDefinition.isIterable() || beanDefinition.hasStereotype(ConfigurationReader.class.getName())) {
            HashSet beanCandidates = new HashSet(5);
            this.collectIterableBeans(null, beanDefinition, beanCandidates, Argument.OBJECT_ARGUMENT);
            for (BeanDefinition beanDefinition2 : beanCandidates) {
                this.intializeEagerBean(null, beanDefinition2, beanDefinition2.asArgument(), beanDefinition2.hasAnnotation(Context.class) ? null : beanDefinition.getDeclaredQualifier());
            }
        } else {
            this.intializeEagerBean(null, beanDefinition, beanDefinition.asArgument(), null);
        }
    }

    @Nullable
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNoSuchBean) {
        BeanRegistration<T> registration;
        BeanRegistration inFlightBeanRegistration;
        Class beanClass = beanType.getType();
        if (this.thisInterfaces.contains(beanClass)) {
            return new BeanRegistration<DefaultBeanContext>(BeanIdentifier.of(beanClass.getName()), null, this);
        }
        if (InjectionPoint.class.isAssignableFrom(beanClass)) {
            return this.provideInjectionPoint(resolutionContext, beanType, qualifier, throwNoSuchBean);
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing bean for key: {}", beanKey);
        }
        BeanRegistration beanRegistration = inFlightBeanRegistration = resolutionContext != null ? resolutionContext.getInFlightBean(beanKey) : null;
        if (inFlightBeanRegistration != null) {
            return inFlightBeanRegistration;
        }
        BeanRegistration<T> beanRegistration2 = this.singletonScope.findCachedSingletonBeanRegistration(beanType, qualifier);
        if (beanRegistration2 != null) {
            return beanRegistration2;
        }
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(resolutionContext, beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> definition = concreteCandidate.get();
            if (definition.isContainerType() && beanClass != definition.getBeanType()) {
                throw new NonUniqueBeanException(beanClass, Collections.singletonList(definition).iterator());
            }
            registration = this.resolveBeanRegistration(resolutionContext, definition, beanType, qualifier);
        } else {
            registration = null;
        }
        if ((registration == null || registration.bean == null) && throwNoSuchBean) {
            throw this.newNoSuchBeanException(resolutionContext, beanType, qualifier, null);
        }
        return registration;
    }

    private void assertContextState() {
        if (!this.running.get() && !this.initializing.get()) {
            throw new BeanContextException("Cannot resolve beans until the context is running");
        }
    }

    private <T> Optional<BeanDefinition<T>> findBeanDefinition(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.singletonScope.findCachedSingletonBeanDefinition(beanType, qualifier);
        if (beanDefinition != null) {
            return Optional.of(beanDefinition);
        }
        return this.findConcreteCandidate(resolutionContext, beanType, qualifier, true);
    }

    @Internal
    @NonNull
    protected <T> NoSuchBeanException newNoSuchBeanException(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @NonNull Qualifier<T> qualifier, @Nullable String message) {
        if (message != null) {
            return new NoSuchBeanException(beanType, qualifier, message);
        }
        String disabledMessage = this.resolveDisabledBeanMessage(resolutionContext, beanType, qualifier);
        if (disabledMessage != null) {
            return new NoSuchBeanException(beanType, qualifier, disabledMessage);
        }
        return new NoSuchBeanException(beanType, qualifier);
    }

    @Nullable
    protected <T> String resolveDisabledBeanMessage(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        StringBuilder stringBuilder = new StringBuilder();
        this.resolveDisabledBeanMessage("", stringBuilder, CachedEnvironment.getProperty("line.separator"), resolutionContext, beanType, qualifier);
        return stringBuilder.isEmpty() ? null : stringBuilder.toString();
    }

    @Internal
    final <T> void resolveDisabledBeanMessage(String linePrefix, StringBuilder messageBuilder, String lineSeparator, @Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        if (linePrefix.length() == 10) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : this.disabledConfigurations.entrySet()) {
            String pkg = entry.getKey();
            if (!beanType.getTypeName().startsWith(pkg + ".")) continue;
            messageBuilder.append(lineSeparator).append(linePrefix).append("* [").append(beanType.getTypeString(true)).append("] is disabled because it is within the package [").append(pkg).append("] which is disabled due to bean requirements: ").append(lineSeparator);
            for (String failure : entry.getValue()) {
                messageBuilder.append(linePrefix).append(" - ").append(failure).append(lineSeparator);
            }
            messageBuilder.setLength(messageBuilder.length() - lineSeparator.length());
            return;
        }
        Collection<BeanDefinition> beanDefinitions = this.collectBeanCandidates(resolutionContext, beanType, false, null, this.disabledBeans.values()).stream().sorted(Comparator.comparing(BeanDefinition::getName)).toList();
        if (qualifier != null) {
            beanDefinitions = qualifier.filter(beanType.getType(), beanDefinitions);
        }
        if (!beanDefinitions.isEmpty()) {
            for (BeanDefinition beanDefinition : beanDefinitions) {
                messageBuilder.append(lineSeparator).append(linePrefix).append("* [").append(beanDefinition.asArgument().getTypeString(true));
                if (!beanDefinition.getBeanType().equals(beanType.getType())) {
                    messageBuilder.append("] a candidate of [").append(beanType.getTypeString(true));
                }
                messageBuilder.append("] is disabled because:").append(lineSeparator);
                if (!(beanDefinition instanceof DisabledBean)) continue;
                DisabledBean disabledBean = (DisabledBean)beanDefinition;
                for (String failure : disabledBean.reasons()) {
                    messageBuilder.append(linePrefix).append(" - ").append(failure).append(lineSeparator);
                    String prefix = "No bean of type [";
                    if (!failure.startsWith(prefix)) continue;
                    ClassUtils.forName((String)failure.substring(prefix.length(), failure.indexOf("]")), (ClassLoader)this.classLoader).ifPresent(beanClass -> {
                        messageBuilder.setLength(messageBuilder.length() - lineSeparator.length());
                        this.resolveDisabledBeanMessage(linePrefix + " ", messageBuilder, lineSeparator, resolutionContext, Argument.of((Class)beanClass), null);
                        messageBuilder.append(lineSeparator);
                    });
                }
                messageBuilder.setLength(messageBuilder.length() - lineSeparator.length());
            }
        }
    }

    @Nullable
    private <T> BeanRegistration<T> provideInjectionPoint(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, boolean throwNoSuchBean) {
        Iterator i;
        BeanResolutionContext.Path path = resolutionContext != null ? resolutionContext.getPath() : null;
        BeanResolutionContext.Segment injectionPointSegment = null;
        if (path != null && (i = path.iterator()).hasNext()) {
            InjectionPoint ip;
            injectionPointSegment = (BeanResolutionContext.Segment)i.next();
            BeanResolutionContext.Segment segment = null;
            if (i.hasNext() && (segment = (BeanResolutionContext.Segment)i.next()).getDeclaringType().hasStereotype(INTRODUCTION_TYPE)) {
                BeanResolutionContext.Segment segment2 = segment = i.hasNext() ? (BeanResolutionContext.Segment)i.next() : null;
            }
            if (segment != null && (ip = segment.getInjectionPoint()) != null && beanType.isInstance(ip)) {
                return new BeanRegistration(BeanIdentifier.of(InjectionPoint.class.getName()), null, ip);
            }
        }
        if (injectionPointSegment == null || !injectionPointSegment.getArgument().isNullable()) {
            throw new BeanContextException("Failed to obtain injection point. No valid injection path present in path: " + String.valueOf(path));
        }
        if (throwNoSuchBean) {
            throw this.newNoSuchBeanException(resolutionContext, beanType, qualifier, null);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition) {
        return this.resolveBeanRegistration(resolutionContext, definition, definition.asArgument(), definition.getDeclaredQualifier());
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        this.assertContextState();
        boolean isScopedProxyDefinition = definition.hasStereotype(SCOPED_PROXY_ANN);
        if (qualifier != null && AnyQualifier.INSTANCE.equals(definition.getDeclaredQualifier())) {
            definition = BeanDefinitionDelegate.create(definition, qualifier);
        }
        if (definition.isSingleton() && !isScopedProxyDefinition) {
            BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(definition, beanType, qualifier);
            if (beanRegistration != null) {
                return beanRegistration;
            }
            return this.singletonScope.getOrCreate(this, resolutionContext, definition, beanType, qualifier);
        }
        boolean isProxy = definition.isProxy();
        if (isProxy && isScopedProxyDefinition) {
            Qualifier<T> q = qualifier;
            if (q == null) {
                q = definition.getDeclaredQualifier();
            }
            BeanRegistration<T> registration = this.createRegistration(resolutionContext, beanType, q, definition, true);
            Object bean = registration.bean;
            if (bean instanceof Qualified) {
                ((Qualified)bean).$withBeanQualifier(q);
            }
            return registration;
        }
        CustomScope<?> customScope = this.findCustomScope(resolutionContext, definition, isProxy, isScopedProxyDefinition);
        if (customScope != null) {
            if (isProxy) {
                definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
            }
            return this.getOrCreateScopedRegistration(resolutionContext, customScope, qualifier, beanType, definition);
        }
        return this.createRegistration(resolutionContext, beanType, qualifier, definition, true);
    }

    @NonNull
    private <T> BeanRegistration<T> intializeEagerBean(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(definition, beanType, qualifier);
        if (beanRegistration != null) {
            return beanRegistration;
        }
        return this.singletonScope.getOrCreate(this, resolutionContext, definition, beanType, qualifier);
    }

    @Nullable
    private <T> CustomScope<?> findCustomScope(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, boolean isProxy, boolean isScopedProxyDefinition) {
        Argument argument;
        BeanResolutionContext.Segment currentSegment;
        CustomScope customScope;
        Optional<Class<Annotation>> scope = definition.getScope();
        if (scope.isPresent()) {
            Class<Annotation> scopeAnnotation = scope.get();
            if (scopeAnnotation == Prototype.class) {
                return null;
            }
            CustomScope customScope2 = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
            if (customScope2 != null) {
                return customScope2;
            }
        } else {
            Optional<String> scopeName = definition.getScopeName();
            if (scopeName.isPresent()) {
                String scopeAnnotation = scopeName.get();
                if (Prototype.class.getName().equals(scopeAnnotation)) {
                    return null;
                }
                customScope = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
                if (customScope != null) {
                    return customScope;
                }
            }
        }
        if (resolutionContext != null && (currentSegment = (BeanResolutionContext.Segment)resolutionContext.getPath().currentSegment().orElse(null)) != null && (customScope = (CustomScope)this.customScopeRegistry.findDeclaredScope(argument = currentSegment.getArgument()).orElse(null)) != null) {
            return customScope;
        }
        if (!isScopedProxyDefinition || !isProxy) {
            return this.customScopeRegistry.findDeclaredScope(definition).orElse(null);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> getOrCreateScopedRegistration(final @Nullable BeanResolutionContext resolutionContext, @NonNull CustomScope<?> registeredScope, final @Nullable Qualifier<T> qualifier, @NonNull Argument<T> beanType, final @NonNull BeanDefinition<T> definition) {
        final BeanKey<T> beanKey = new BeanKey<T>(definition.asArgument(), qualifier);
        Object bean = registeredScope.getOrCreate(new BeanCreationContext<T>(){

            @Override
            @NonNull
            public BeanDefinition<T> definition() {
                return definition;
            }

            @Override
            @NonNull
            public BeanIdentifier id() {
                return beanKey;
            }

            @Override
            @NonNull
            public CreatedBean<T> create() throws BeanCreationException {
                return DefaultBeanContext.this.createRegistration(resolutionContext == null ? null : resolutionContext.copy(), beanKey.beanType, qualifier, definition, true);
            }
        });
        return BeanRegistration.of(this, beanKey, definition, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Internal
    final <T> BeanRegistration<T> createRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull BeanDefinition<T> definition, boolean dependent) {
        try (BeanResolutionContext context = this.newResolutionContext(definition, resolutionContext);){
            BeanResolutionContext.Path path = context.getPath();
            boolean isNewPath = path.isEmpty();
            if (isNewPath) {
                Argument resolvedBeanType;
                if (qualifier instanceof TypeArgumentQualifier) {
                    TypeArgumentQualifier taq = (TypeArgumentQualifier)qualifier;
                    Class[] typeArguments = taq.getTypeArguments();
                    resolvedBeanType = Argument.of((Class)beanType.getType(), (AnnotationMetadata)beanType.getAnnotationMetadata(), (Class[])typeArguments);
                } else {
                    resolvedBeanType = beanType;
                }
                path.pushBeanCreate(definition, resolvedBeanType);
            }
            try {
                List<BeanRegistration<?>> parentDependentBeans = context.popDependentBeans();
                if (!(definition instanceof InstantiatableBeanDefinition)) {
                    throw new BeanInstantiationException("BeanDefinition doesn't support creating a new instance of the bean");
                }
                InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)definition;
                T bean = this.resolveByBeanFactory(context, instantiatableBeanDefinition, qualifier, Collections.emptyMap());
                bean = this.postBeanCreated(context, definition, qualifier, bean);
                BeanRegistration<?> dependentFactoryBean = context.getAndResetDependentFactoryBean();
                if (dependentFactoryBean != null) {
                    this.destroyBean(dependentFactoryBean);
                }
                BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
                List<BeanRegistration<?>> dependentBeans = context.getAndResetDependentBeans();
                BeanRegistration<T> beanRegistration = BeanRegistration.of(this, beanKey, definition, bean, dependentBeans);
                context.pushDependentBeans(parentDependentBeans);
                if (dependent) {
                    context.addDependentBean(beanRegistration);
                }
                BeanRegistration<T> beanRegistration2 = beanRegistration;
                if (isNewPath) {
                    path.close();
                }
                return beanRegistration2;
            }
            catch (Throwable throwable) {
                if (isNewPath) {
                    path.close();
                }
                throw throwable;
            }
        }
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidate(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNonUnique) {
        if (beanType.getType() == Object.class && qualifier == null) {
            return Optional.empty();
        }
        BeanCandidateKey<T> bk = new BeanCandidateKey<T>(beanType, qualifier, throwNonUnique);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(bk);
        if (beanDefinition == null) {
            beanDefinition = this.findConcreteCandidateNoCache(resolutionContext, beanType, qualifier, throwNonUnique);
            this.beanConcreteCandidateCache.put(bk, beanDefinition);
        }
        return beanDefinition;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidateNoCache(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNonUnique) {
        Predicate<BeanDefinition<T>> predicate = candidate -> !candidate.isAbstract();
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(resolutionContext, beanType, true, predicate);
        return this.pickOneBean(beanType, qualifier, throwNonUnique, candidates);
    }

    private <T> Optional<BeanDefinition<T>> findProxyTargetNoCache(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Set<BeanDefinition<T>> candidates = this.collectBeanCandidates(resolutionContext, beanType, true, null, this.proxyTargetBeans);
        return this.pickOneBean(beanType, qualifier, false, candidates);
    }

    @NonNull
    private <T> Optional<BeanDefinition<T>> pickOneBean(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        BeanDefinition<T> definition;
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        if (qualifier != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Qualifying bean [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
            }
            if ((candidates = qualifier.filter(beanType.getType(), candidates)).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No qualifying beans of type [{}] found for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                return Optional.empty();
            }
        }
        if (candidates.size() == 1) {
            definition = candidates.iterator().next();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching for @Primary for type [{}] from candidates: {} ", (Object)beanType.getName(), candidates);
            }
            definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, candidates);
        }
        if (LOG.isDebugEnabled() && definition != null) {
            if (qualifier != null) {
                LOG.debug("Found concrete candidate [{}] for type: {} {} ", new Object[]{definition, qualifier, beanType.getName()});
            } else {
                LOG.debug("Found concrete candidate [{}] for type: {} ", definition, (Object)beanType.getName());
            }
        }
        return Optional.ofNullable(definition);
    }

    @Nullable
    private <T> BeanDefinition<T> lastChanceResolve(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        Collection<BeanDefinition<T>> exactMatches;
        String n;
        List<BeanDefinition> primary;
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).toList()).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if ((candidates = candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype(Secondary.class)).toList()).size() == 1) {
            return candidates.iterator().next();
        }
        ArrayList<BeanDefinition<T>> listCandidates = new ArrayList<BeanDefinition<T>>(candidates);
        listCandidates.sort(OrderUtil.ORDERED_COMPARATOR);
        Iterator<BeanDefinition<T>> iterator = listCandidates.iterator();
        BeanDefinition<T> bean = iterator.next();
        BeanDefinition<T> next = iterator.next();
        if (bean.getOrder() != next.getOrder()) {
            LOG.debug("Picked bean {} with the highest precedence for type {} and qualifier {}", new Object[]{bean, beanType, null});
            return bean;
        }
        BeanDefinition<T> first = candidates.iterator().next();
        if (first.hasStereotype(DefaultImplementation.class) && (n = (String)first.stringValue(DefaultImplementation.class, "name").orElse(null)) != null) {
            for (BeanDefinition<T> bd : candidates) {
                if (!bd.getBeanType().getName().equals(n)) continue;
                return bd;
            }
        }
        if ((exactMatches = this.filterExactMatch(beanType.getType(), candidates)).size() == 1) {
            return exactMatches.iterator().next();
        }
        if (throwNonUnique) {
            return this.findConcreteCandidate(beanType.getType(), qualifier, candidates);
        }
        return null;
    }

    private void readAllBeanConfigurations() {
        if (this.beanConfigurations.isEmpty()) {
            Iterable<BeanConfiguration> beanConfigurations = this.resolveBeanConfigurations();
            for (BeanConfiguration beanConfiguration : beanConfigurations) {
                this.registerConfiguration(beanConfiguration);
            }
        }
    }

    private <T> Collection<BeanDefinition<T>> filterExactMatch(Class<T> beanType, Collection<BeanDefinition<T>> candidates) {
        ArrayList<BeanDefinition<T>> list = new ArrayList<BeanDefinition<T>>(candidates.size());
        for (BeanDefinition<T> candidate : candidates) {
            if (candidate.getBeanType() != beanType) continue;
            list.add(candidate);
        }
        return list;
    }

    private void configureAndStartContext() {
        this.configureContextInternal();
        this.initializeEventListeners();
        this.initializeContext(this.startupBeans.eagerInitBeans, this.startupBeans.processedBeans, this.startupBeans.parallelBeans);
    }

    @NonNull
    private StartupBeans readBeanDefinitionReferences() {
        if (this.startupBeans == null) {
            ArrayList<BeanDefinitionProducer> eagerInitBeans = new ArrayList<BeanDefinitionProducer>(20);
            ArrayList<BeanDefinitionProducer> processedBeans = new ArrayList<BeanDefinitionProducer>(10);
            ArrayList<BeanDefinitionProducer> parallelBeans = new ArrayList<BeanDefinitionProducer>(10);
            List<BeanDefinitionReference> beanDefinitionReferences = this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionProducer> producers = new ArrayList<BeanDefinitionProducer>(beanDefinitionReferences.size());
            ArrayList<BeanDefinitionProducer> proxyTargetBeans = new ArrayList<BeanDefinitionProducer>(beanDefinitionReferences.size());
            for (BeanDefinitionReference beanDefinitionReference : beanDefinitionReferences) {
                producers.add(new BeanDefinitionProducer(beanDefinitionReference));
            }
            this.beanDefinitionsClasses.addAll(producers);
            Collection<BeanConfiguration> allConfigurations = this.beanConfigurations.values();
            ArrayList<BeanConfiguration> configurationsDisabled = new ArrayList<BeanConfiguration>(allConfigurations.size());
            for (BeanConfiguration bc : allConfigurations) {
                if (bc.isEnabled(this)) continue;
                configurationsDisabled.add(bc);
            }
            block2: for (BeanDefinitionProducer beanDefinitionProducer : producers) {
                Class aClass;
                if (beanDefinitionProducer.isDisabledOptimistic()) continue;
                BeanDefinitionReference beanDefinitionReference = beanDefinitionProducer.reference;
                for (BeanConfiguration disableConfiguration : configurationsDisabled) {
                    if (!disableConfiguration.isWithin(beanDefinitionReference)) continue;
                    beanDefinitionProducer.disable();
                    continue block2;
                }
                if (beanDefinitionReference.isProxiedBean()) {
                    beanDefinitionProducer.disable();
                    BeanDefinitionProducer proxyBeanProducer = new BeanDefinitionProducer(beanDefinitionReference);
                    if (!beanDefinitionReference.isProxyTarget()) continue;
                    proxyTargetBeans.add(proxyBeanProducer);
                    continue;
                }
                AnnotationMetadata annotationMetadata = beanDefinitionReference.getAnnotationMetadata();
                Class[] indexes = annotationMetadata.classValues(INDEXES_TYPE);
                if (indexes.length > 0) {
                    for (int i = 0; i < indexes.length; ++i) {
                        Class indexedType = indexes[i];
                        this.resolveTypeIndex(indexedType).add(beanDefinitionProducer);
                    }
                } else if (annotationMetadata.hasStereotype(ADAPTER_TYPE) && this.indexedTypes.contains(aClass = (Class)annotationMetadata.classValue(ADAPTER_TYPE, "value").orElse(null))) {
                    this.resolveTypeIndex(aClass).add(beanDefinitionProducer);
                }
                if (this.isEagerInit(beanDefinitionReference)) {
                    eagerInitBeans.add(beanDefinitionProducer);
                } else if (annotationMetadata.hasDeclaredStereotype(PARALLEL_TYPE)) {
                    parallelBeans.add(beanDefinitionProducer);
                }
                if (!beanDefinitionReference.requiresMethodProcessing()) continue;
                processedBeans.add(beanDefinitionProducer);
            }
            this.beanDefinitionReferences = null;
            this.beanConfigurationsList = null;
            this.proxyTargetBeans.addAll(proxyTargetBeans);
            this.startupBeans = new StartupBeans(eagerInitBeans, processedBeans, parallelBeans);
        }
        return this.startupBeans;
    }

    private boolean isEagerInit(BeanDefinitionReference beanDefinitionReference) {
        return beanDefinitionReference.isContextScope() || this.eagerInitSingletons && beanDefinitionReference.isSingleton() || this.eagerInitStereotypesPresent && beanDefinitionReference.getAnnotationMetadata().hasDeclaredStereotype(this.eagerInitStereotypes);
    }

    @NonNull
    private Collection<BeanDefinitionProducer> resolveTypeIndex(Class<?> indexedType) {
        return this.beanIndex.computeIfAbsent(indexedType, aClass -> {
            this.indexedTypes.add(indexedType);
            return new ArrayList(20);
        });
    }

    private <T> Collection<BeanDefinition<T>> findBeanCandidatesInternal(BeanResolutionContext resolutionContext, Argument<T> beanType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            beanDefinitions = this.findBeanCandidates(resolutionContext, beanType, true, null);
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    @Internal
    public <T> BeanRegistration<T> getBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.resolveBeanRegistration(resolutionContext, beanType, qualifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations;
        CollectionHolder existing;
        boolean hasQualifier;
        this.assertContextState();
        boolean bl = hasQualifier = qualifier != null;
        if (LOG.isDebugEnabled()) {
            if (hasQualifier) {
                LOG.debug("Resolving beans for type: {} {} ", qualifier, (Object)beanType.getTypeName());
            } else {
                LOG.debug("Resolving beans for type: {}", (Object)beanType.getTypeName());
            }
        }
        BeanKey<T> key = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing beans for key: {}", key);
        }
        if ((existing = this.singletonBeanRegistrations.get(key)) != null && existing.registrations != null) {
            this.logResolvedExistingBeanRegistrations(beanType, qualifier, existing.registrations);
            return existing.registrations;
        }
        Collection<BeanDefinition<T>> beanDefinitions = this.findBeanCandidatesInternal(resolutionContext, beanType);
        if (!beanDefinitions.isEmpty()) {
            beanDefinitions = this.applyBeanResolutionFilters(resolutionContext, beanDefinitions);
            if (qualifier != null) {
                beanDefinitions = qualifier.filter(beanType.getType(), beanDefinitions);
            }
        }
        if (beanDefinitions.isEmpty()) {
            beanRegistrations = Collections.emptySet();
        } else {
            boolean allCandidatesAreSingleton = true;
            for (BeanDefinition<T> definition : beanDefinitions) {
                if (definition.isSingleton()) continue;
                allCandidatesAreSingleton = false;
            }
            if (allCandidatesAreSingleton) {
                CollectionHolder holder;
                CollectionHolder collectionHolder = holder = this.singletonBeanRegistrations.computeIfAbsent(key, beanKey -> new CollectionHolder());
                synchronized (collectionHolder) {
                    if (holder.registrations != null) {
                        this.logResolvedExistingBeanRegistrations(beanType, qualifier, holder.registrations);
                        return holder.registrations;
                    }
                    holder.registrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
                    return holder.registrations;
                }
            }
            beanRegistrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
        }
        if (LOG.isDebugEnabled() && !beanRegistrations.isEmpty()) {
            if (hasQualifier) {
                LOG.debug("Found {} bean registrations for type [{} {}]", new Object[]{beanRegistrations.size(), qualifier, beanType.getName()});
            } else {
                LOG.debug("Found {} bean registrations for type [{}]", (Object)beanRegistrations.size(), (Object)beanType.getName());
            }
            for (BeanRegistration<T> beanRegistration : beanRegistrations) {
                LOG.debug("  {} {}", beanRegistration.definition(), beanRegistration.definition().getDeclaredQualifier());
            }
        }
        return beanRegistrations;
    }

    private <T> Collection<BeanRegistration<T>> resolveBeanRegistrations(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> beanDefinitions, Argument<T> beanType, Qualifier<T> qualifier) {
        ArrayList<BeanRegistration<T>> beansOfTypeList = new ArrayList<BeanRegistration<T>>(beanDefinitions.size());
        for (BeanDefinition<T> definition : beanDefinitions) {
            this.addCandidateToList(resolutionContext, definition, beanType, qualifier, beansOfTypeList);
        }
        beansOfTypeList.sort(OrderUtil.ORDERED_COMPARATOR);
        return beansOfTypeList;
    }

    private <T> void logResolvedExistingBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier, Collection<BeanRegistration<T>> existing) {
        if (LOG.isDebugEnabled()) {
            if (qualifier == null) {
                LOG.debug("Found {} existing beans for type [{}]: {} ", new Object[]{existing.size(), beanType.getName(), existing});
            } else {
                LOG.debug("Found {} existing beans for type [{} {}]: {} ", new Object[]{existing.size(), qualifier, beanType.getName(), existing});
            }
        }
    }

    private <T> Collection<BeanDefinition<T>> applyBeanResolutionFilters(@Nullable BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates) {
        BeanResolutionContext.Segment segment = resolutionContext != null ? (BeanResolutionContext.Segment)resolutionContext.getPath().peek() : null;
        BeanDefinition declaringBean = null;
        Class proxyTargetDefinitionType = null;
        if ((segment instanceof AbstractBeanResolutionContext.ConstructorSegment || segment instanceof AbstractBeanResolutionContext.MethodSegment) && (declaringBean = segment.getDeclaringType()) instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringBean;
            proxyTargetDefinitionType = proxyBeanDefinition.getTargetDefinitionType();
        }
        candidates = new LinkedHashSet<BeanDefinition<T>>(candidates);
        Iterator<BeanDefinition<T>> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            BeanDefinition<T> c = iterator.next();
            if (!c.isAbstract() && (declaringBean == null || !c.equals(declaringBean)) && (proxyTargetDefinitionType == null || !proxyTargetDefinitionType.equals(c.getClass()))) continue;
            iterator.remove();
        }
        return candidates;
    }

    private <T> void addCandidateToList(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> candidate, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanRegistration<T>> beansOfTypeList) {
        BeanRegistration<T> beanRegistration;
        block9: {
            beanRegistration = null;
            try {
                beanRegistration = this.resolveBeanRegistration(resolutionContext, candidate, candidate.asArgument(), candidate.getDeclaredQualifier());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found a registration {} for candidate: {} with qualifier: {}", new Object[]{beanRegistration, candidate, qualifier});
                }
            }
            catch (DisabledBeanException e) {
                if (!AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) break block9;
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getTypeName(), (Object)e.getMessage());
            }
        }
        if (beanRegistration != null) {
            if (candidate.isContainerType()) {
                Object container = beanRegistration.bean;
                if (container instanceof Object[]) {
                    Object[] array = (Object[])container;
                    container = Arrays.asList(array);
                }
                if (container instanceof Iterable) {
                    Iterable iterable = (Iterable)container;
                    int i = 0;
                    for (Object o : iterable) {
                        if (o == null || !beanType.isInstance(o)) continue;
                        beansOfTypeList.add(BeanRegistration.of(this, new BeanKey<T>(beanType, Qualifiers.byQualifiers(Qualifiers.byName(String.valueOf(i++)), qualifier)), candidate, o));
                    }
                }
            } else {
                beansOfTypeList.add(beanRegistration);
            }
        }
    }

    private <T> boolean isCandidatePresent(Argument<T> beanType, Qualifier<T> qualifier) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(null, beanType, true, null);
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(null, candidates);
            if (qualifier != null) {
                return qualifier.doesQualify(beanType.getType(), candidates);
            }
            return true;
        }
        return false;
    }

    private static <T> List<T> nullSafe(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private List<BeanRegistration> topologicalSort(Collection<BeanRegistration> beans) {
        Map<Boolean, List<BeanRegistration>> initial = beans.stream().sorted(Comparator.comparing(s -> s.getBeanDefinition().getRequiredComponents().size())).collect(Collectors.groupingBy(b -> b.getBeanDefinition().getRequiredComponents().isEmpty()));
        ArrayList<BeanRegistration> sorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(true)));
        ArrayList<BeanRegistration> unsorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(false)));
        HashSet satisfied = new HashSet();
        HashSet unsatisfied = new HashSet();
        while (!unsorted.isEmpty()) {
            boolean acyclic = false;
            unsatisfied.clear();
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                BeanRegistration bean = (BeanRegistration)i.next();
                boolean found = false;
                Collection<Class<?>> components = bean.getBeanDefinition().getRequiredComponents();
                for (Class<?> clazz : components) {
                    block6: {
                        block5: {
                            if (satisfied.contains(clazz)) continue;
                            if (unsatisfied.contains(clazz)) break block5;
                            if (!unsorted.stream().map(BeanRegistration::getBeanDefinition).map(BeanDefinition::getBeanType).anyMatch(clazz::isAssignableFrom)) break block6;
                        }
                        found = true;
                        unsatisfied.add(clazz);
                        break;
                    }
                    satisfied.add(clazz);
                }
                if (found) continue;
                acyclic = true;
                i.remove();
                sorted.add(0, bean);
            }
            if (acyclic) continue;
            sorted.add(0, (BeanRegistration)unsorted.remove(0));
        }
        return sorted;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return MutableConvertibleValues.of(this.attributes);
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        if (name != null) {
            return Optional.ofNullable(this.attributes.get(name));
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        if (name != null) {
            Object o = this.attributes.get(name);
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            if (o != null) {
                return this.getConversionService().convert(o, type);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public BeanContext setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (name != null) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
        return this;
    }

    @NonNull
    public <T> Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        Object o = this.attributes.remove(name);
        if (type.isInstance(o)) {
            return Optional.of(o);
        }
        return Optional.empty();
    }

    @Override
    public void finalizeConfiguration() {
        this.configureAndStartContext();
    }

    public MutableConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public final synchronized void configure() {
        if (this.running.get()) {
            DefaultBeanContext.configurationFailure("already running");
        }
        if (this.terminating.get()) {
            DefaultBeanContext.configurationFailure("currently terminating");
        }
        if (this.initializing.get()) {
            DefaultBeanContext.configurationFailure("currently initializing");
        }
        this.configureContextInternal();
    }

    @Internal
    void configureContextInternal() {
        if (this.configured.compareAndSet(false, true)) {
            this.readAllBeanConfigurations();
            this.readBeanDefinitionReferences();
        }
    }

    private static void configurationFailure(String message) {
        throw new ConfigurationException("Bean context is " + message + ". The configure() method can only be called prior to startup");
    }

    static final class BeanKey<T>
    implements BeanIdentifier {
        final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final int hashCode;

        BeanKey(BeanDefinition<T> definition, Qualifier<T> qualifier) {
            this(definition.asArgument(), qualifier);
        }

        BeanKey(Argument<T> argument, Qualifier<T> qualifier) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
        }

        BeanKey(Class<T> beanType, Qualifier<T> qualifier, Class<?> ... typeArguments) {
            this(Argument.of(beanType, (Class[])typeArguments), qualifier);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return (String)(this.qualifier != null ? String.valueOf(this.qualifier) + " " : "") + this.beanType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getName() {
            Qualifier<T> qualifier = this.qualifier;
            if (qualifier instanceof Named) {
                Named named = (Named)qualifier;
                return named.getName();
            }
            return Primary.SIMPLE_NAME;
        }
    }

    @Internal
    static final class BeanDefinitionProducer {
        private static final AtomicReferenceFieldUpdater<BeanDefinitionProducer, Object> DEFINITION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BeanDefinitionProducer.class, Object.class, "definition");
        private static final Object DEFINITION_DISABLED_SENTINEL = "";
        @Nullable
        private volatile BeanDefinitionReference reference;
        @Nullable
        private volatile Object definition;

        BeanDefinitionProducer(@NonNull BeanDefinitionReference reference) {
            this.reference = reference;
        }

        private static boolean isReferenceEnabled(BeanDefinitionReference<?> ref, DefaultBeanContext context, BeanResolutionContext resolutionContext) {
            if (ref == null) {
                return false;
            }
            if (ref instanceof AbstractInitializableBeanDefinitionAndReference) {
                AbstractInitializableBeanDefinitionAndReference referenceAndDefinition = (AbstractInitializableBeanDefinitionAndReference)ref;
                return referenceAndDefinition.isEnabled(context, resolutionContext, true);
            }
            return ref.isEnabled(context);
        }

        private static boolean isDefinitionEnabled(@NonNull DefaultBeanContext context, @Nullable BeanResolutionContext resolutionContext, @Nullable BeanDefinition<?> def) {
            if (def == null) {
                return false;
            }
            if (def instanceof AbstractInitializableBeanDefinitionAndReference) {
                AbstractInitializableBeanDefinitionAndReference definitionAndReference = (AbstractInitializableBeanDefinitionAndReference)def;
                return definitionAndReference.isEnabled(context, resolutionContext, false);
            }
            return def.isEnabled(context, resolutionContext);
        }

        boolean isDisabledOptimistic() {
            return this.reference == null || this.definition == DEFINITION_DISABLED_SENTINEL;
        }

        @Nullable
        <T> BeanDefinitionReference<T> getReferenceIfEnabled(DefaultBeanContext context) {
            return this.getReferenceIfEnabled(context, null);
        }

        @Nullable
        <T> BeanDefinitionReference<T> getReferenceIfEnabled(DefaultBeanContext context, @Nullable BeanResolutionContext resolutionContext) {
            BeanDefinitionReference ref = this.reference;
            if (ref == null) {
                return null;
            }
            if (BeanDefinitionProducer.isReferenceEnabled(ref, context, resolutionContext)) {
                return ref;
            }
            this.reference = null;
            return null;
        }

        @Nullable
        BeanDefinitionReference<?> getReferenceBestEffort() {
            return this.reference;
        }

        @Nullable
        <T> BeanDefinition<T> getDefinitionIfEnabled(DefaultBeanContext context) {
            return this.getDefinitionIfEnabled(context, null, null, null);
        }

        @Nullable
        <T> BeanDefinition<T> getDefinitionIfEnabled(DefaultBeanContext context, @Nullable BeanResolutionContext resolutionContext, @Nullable Argument<T> beanType, @Nullable Predicate<BeanDefinition<T>> predicate) {
            Object defObject = this.definition;
            if (defObject != DEFINITION_DISABLED_SENTINEL && defObject != null) {
                BeanDefinition def = (BeanDefinition)defObject;
                if (beanType != null && !def.isCandidateBean(beanType)) {
                    return null;
                }
                if (predicate != null && !predicate.test(def)) {
                    return null;
                }
                return def;
            }
            BeanDefinitionReference<T> ref = this.getReferenceIfEnabled(context, resolutionContext);
            if (ref == null) {
                this.definition = DEFINITION_DISABLED_SENTINEL;
                return null;
            }
            BeanDefinition<T> def = ref.load(context);
            if (beanType != null && !def.isCandidateBean(beanType)) {
                return null;
            }
            if (predicate != null && !predicate.test(def)) {
                return null;
            }
            if (BeanDefinitionProducer.isDefinitionEnabled(context, resolutionContext, def)) {
                if (DEFINITION_UPDATER.compareAndSet(this, null, def)) {
                    return def;
                }
                defObject = this.definition;
                return defObject != DEFINITION_DISABLED_SENTINEL && defObject != null ? (BeanDefinition)defObject : null;
            }
            this.definition = DEFINITION_DISABLED_SENTINEL;
            return null;
        }

        <T> boolean isReferenceCandidateBean(Argument<T> beanType) {
            BeanDefinitionReference ref = this.reference;
            return ref != null && ref.isCandidateBean(beanType);
        }

        void disableIfMatch(BeanDefinitionReference<?> toDisable) {
            if (Objects.equals(toDisable, this.reference)) {
                this.disable();
            }
        }

        void disable() {
            this.reference = null;
            this.definition = DEFINITION_DISABLED_SENTINEL;
        }
    }

    private record StartupBeans(List<BeanDefinitionProducer> eagerInitBeans, List<BeanDefinitionProducer> processedBeans, List<BeanDefinitionProducer> parallelBeans) {
    }

    private final class BeanContextUnsafeExecutionHandle
    extends BeanContextExecutionHandle
    implements UnsafeExecutionHandle<Object, Object> {
        private final UnsafeExecutable<Object, Object> unsafeExecutionHandle;

        public BeanContextUnsafeExecutionHandle(ExecutableMethod<Object, ?> method, BeanDefinition<?> beanDefinition, UnsafeExecutable<Object, Object> unsafeExecutionHandle) {
            super(method, beanDefinition);
            this.unsafeExecutionHandle = unsafeExecutionHandle;
        }

        @Override
        public Object invokeUnsafe(Object ... arguments) {
            return this.unsafeExecutionHandle.invokeUnsafe(this.getTarget(), arguments);
        }

        @Override
        public String toString() {
            return this.unsafeExecutionHandle.toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private class BeanContextExecutionHandle
    implements MethodExecutionHandle<Object, Object> {
        private final ExecutableMethod<Object, ?> method;
        private final BeanDefinition<?> beanDefinition;
        private Object target;

        public BeanContextExecutionHandle(ExecutableMethod<Object, ?> method, BeanDefinition<? extends Object> beanDefinition) {
            this.method = method;
            this.beanDefinition = beanDefinition;
        }

        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getTarget() {
            Object target = this.target;
            if (target == null) {
                BeanContextExecutionHandle beanContextExecutionHandle = this;
                synchronized (beanContextExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = DefaultBeanContext.this.getBean(this.beanDefinition);
                    }
                }
            }
            return target;
        }

        @Override
        public Class getDeclaringType() {
            return this.beanDefinition.getBeanType();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public ReturnType getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Object invoke(Object ... arguments) {
            return this.method.invoke(this.getTarget(), arguments);
        }

        @Override
        @NonNull
        public ExecutableMethod<Object, Object> getExecutableMethod() {
            return this.method;
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private final class SingletonBeanResolutionContext
    extends AbstractBeanResolutionContext {
        public SingletonBeanResolutionContext(BeanDefinition<?> beanDefinition) {
            super(DefaultBeanContext.this, beanDefinition);
        }

        @Override
        public BeanResolutionContext copy() {
            SingletonBeanResolutionContext copy = new SingletonBeanResolutionContext(this.rootDefinition);
            copy.copyStateFrom(this);
            return copy;
        }

        @Override
        public <T> void addInFlightBean(BeanIdentifier beanIdentifier, BeanRegistration<T> beanRegistration) {
            DefaultBeanContext.this.singlesInCreation.put(beanIdentifier, beanRegistration);
        }

        @Override
        public void removeInFlightBean(BeanIdentifier beanIdentifier) {
            DefaultBeanContext.this.singlesInCreation.remove(beanIdentifier);
        }

        @Override
        @Nullable
        public <T> BeanRegistration<T> getInFlightBean(BeanIdentifier beanIdentifier) {
            return DefaultBeanContext.this.singlesInCreation.get(beanIdentifier);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Internal
    static interface ListenersSupplier<T extends EventListener> {
        @NonNull
        public Iterable<T> get(@Nullable BeanResolutionContext var1);
    }

    static final class BeanCandidateKey<T> {
        private final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean throwNonUnique;
        private final int hashCode;

        BeanCandidateKey(Argument<T> argument, Qualifier<T> qualifier, boolean throwNonUnique) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
            this.throwNonUnique = throwNonUnique;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanCandidateKey beanKey = (BeanCandidateKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier) && this.throwNonUnique == beanKey.throwNonUnique;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class AnnotationProcessorListenersSupplier
    implements ListenersSupplier<BeanCreatedEventListener> {
        private AnnotationProcessorListenersSupplier() {
        }

        @Override
        public Iterable<BeanCreatedEventListener> get(BeanResolutionContext beanResolutionContext) {
            return Collections.singletonList(new AnnotationProcessorListener());
        }
    }

    private final class EventListenerListenersSupplier<T extends EventListener>
    implements ListenersSupplier<T> {
        private final List<BeanDefinition<T>> listenersDefinitions;
        private final Argument<?> eventType;
        private volatile List<T> listeners;

        EventListenerListenersSupplier(Argument<?> eventType, List<BeanDefinition<T>> listenersDefinitions) {
            this.eventType = eventType;
            this.listenersDefinitions = listenersDefinitions;
        }

        @Override
        public Iterable<T> get(BeanResolutionContext beanResolutionContext) {
            if (this.listeners == null) {
                ArrayList<T> listeners = new ArrayList<T>(this.listenersDefinitions.size());
                for (BeanDefinition<T> listenersDefinition : this.listenersDefinitions) {
                    EventListener listener;
                    block21: {
                        if (beanResolutionContext == null) {
                            try (BeanResolutionContext context = DefaultBeanContext.this.newResolutionContext(listenersDefinition, null);
                                 BeanResolutionContext.Path ignored = context.getPath().pushEventListenerResolve(listenersDefinition, this.eventType);){
                                listener = (EventListener)DefaultBeanContext.this.resolveBeanRegistration((BeanResolutionContext)context, listenersDefinition).bean;
                                break block21;
                            }
                        }
                        try (BeanResolutionContext.Path ignored = beanResolutionContext.getPath().pushEventListenerResolve(listenersDefinition, this.eventType);){
                            listener = (EventListener)DefaultBeanContext.this.resolveBeanRegistration((BeanResolutionContext)beanResolutionContext, listenersDefinition).bean;
                        }
                    }
                    listeners.add(listener);
                }
                OrderUtil.sort(listeners);
                this.listeners = listeners;
            }
            return this.listeners;
        }
    }

    private static final class CollectionHolder<T> {
        Collection<BeanRegistration<T>> registrations;

        private CollectionHolder() {
        }
    }

    private static final class ObjectExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R>
    implements UnsafeExecutionHandle<T, R> {
        @Nullable
        private final UnsafeExecutable<T, R> unsafeExecutable;
        private final T target;

        ObjectExecutionHandle(T target, ExecutableMethod<T, R> method) {
            super(method);
            UnsafeExecutable unsafeExecutable;
            this.target = target;
            this.unsafeExecutable = method instanceof UnsafeExecutable ? (unsafeExecutable = (UnsafeExecutable)method) : null;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public R invoke(Object ... arguments) {
            return (R)this.method.invoke(this.target, arguments);
        }

        @Override
        public R invokeUnsafe(Object ... arguments) {
            if (this.unsafeExecutable == null) {
                return this.invoke(arguments);
            }
            return (R)this.unsafeExecutable.invokeUnsafe(this.target, arguments);
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.target.getClass();
        }
    }

    private static final class BeanExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final DefaultBeanContext beanContext;
        private final Class<T> beanType;
        private final Argument<T> beanArgument;
        private final Qualifier<T> qualifier;
        private final boolean isSingleton;
        private final BeanDefinition<T> definition;
        private T target;

        BeanExecutionHandle(DefaultBeanContext beanContext, BeanDefinition<T> definition, Class<T> beanType, Qualifier<T> qualifier, ExecutableMethod<T, R> method) {
            super(method);
            this.beanContext = beanContext;
            this.beanType = beanType;
            this.beanArgument = Argument.of(beanType);
            this.qualifier = qualifier;
            this.isSingleton = definition.isSingleton();
            this.definition = definition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getTarget() {
            T target = this.target;
            if (target == null) {
                BeanExecutionHandle beanExecutionHandle = this;
                synchronized (beanExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        try (BeanResolutionContext resolutionContext = this.beanContext.newResolutionContext(this.definition, null);){
                            this.target = target = this.beanContext.getBean(resolutionContext, this.beanArgument, this.qualifier);
                        }
                    }
                }
            }
            return target;
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.beanType;
        }

        @Override
        public R invoke(Object ... arguments) {
            if (this.isSingleton) {
                T target = this.getTarget();
                return (R)this.method.invoke(target, arguments);
            }
            return (R)this.method.invoke(this.beanContext.getBean(this.beanType, this.qualifier), arguments);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractExecutionHandle<T, R>
    implements MethodExecutionHandle<T, R> {
        protected final ExecutableMethod<T, R> method;

        AbstractExecutionHandle(ExecutableMethod<T, R> method) {
            this.method = method;
        }

        @Override
        @NonNull
        public ExecutableMethod<T, R> getExecutableMethod() {
            return this.method;
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public ReturnType<R> getReturnType() {
            return this.method.getReturnType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

