/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import groovy.lang.GroovySystem;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.version.SemanticVersion;
import io.micronaut.core.version.VersionUtils;
import java.util.Objects;
import kotlin.KotlinVersion;

@Internal
public record MatchesSdkCondition(Requires.Sdk sdk, String version) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        switch (this.sdk) {
            case GROOVY: {
                String groovyVersion = GroovySystem.getVersion();
                boolean versionMatch = SemanticVersion.isAtLeast((String)groovyVersion, (String)this.version);
                if (!versionMatch) {
                    context.fail("Groovy version [" + groovyVersion + "] must be at least " + this.version);
                }
                return versionMatch;
            }
            case KOTLIN: {
                String kotlinVersion = KotlinVersion.CURRENT.toString();
                boolean isSupported = SemanticVersion.isAtLeast((String)kotlinVersion, (String)this.version);
                if (!isSupported) {
                    context.fail("Kotlin version [" + kotlinVersion + "] must be at least " + this.version);
                }
                return isSupported;
            }
            case JAVA: {
                String javaVersion = CachedEnvironment.getProperty("java.version");
                try {
                    boolean result = SemanticVersion.isAtLeast((String)javaVersion, (String)this.version);
                    if (!result) {
                        context.fail("Java version [" + javaVersion + "] must be at least " + this.version);
                    }
                    return result;
                }
                catch (Exception e) {
                    if (javaVersion != null) {
                        int requiredVersion;
                        int majorVersion = this.resolveJavaMajorVersion(javaVersion);
                        if (majorVersion >= (requiredVersion = this.resolveJavaMajorVersion(this.version))) {
                            return true;
                        }
                        context.fail("Java major version [" + majorVersion + "] must be at least " + requiredVersion);
                    } else {
                        int requiredVersion = this.resolveJavaMajorVersion(this.version);
                        context.fail("Java major version must be at least " + requiredVersion);
                    }
                    return !context.isFailing();
                }
            }
            case MICRONAUT: {
                boolean versionCheck = VersionUtils.isAtLeastMicronautVersion((String)this.version);
                if (!versionCheck) {
                    context.fail("Micronaut version [" + VersionUtils.MICRONAUT_VERSION + "] must be at least " + this.version);
                }
                return versionCheck;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.sdk));
    }

    private int resolveJavaMajorVersion(String javaVersion) {
        int majorVersion = 0;
        if (javaVersion.indexOf(46) > -1) {
            String[] tokens = javaVersion.split("\\.");
            String first = tokens[0];
            if (first.length() == 1) {
                majorVersion = first.charAt(0);
                if (Character.isDigit(majorVersion) && majorVersion == 49 && tokens.length > 1) {
                    majorVersion = tokens[1].charAt(0);
                }
            } else {
                try {
                    majorVersion = Integer.parseInt(first);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (javaVersion.length() == 1) {
            char ch = javaVersion.charAt(0);
            if (Character.isDigit(ch)) {
                majorVersion = ch;
            }
        } else {
            try {
                majorVersion = Integer.parseInt(javaVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return majorVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesSdkCondition that = (MatchesSdkCondition)o;
        return Objects.equals(this.version, that.version) && this.sdk == that.sdk;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sdk, this.version});
    }

    @Override
    public String toString() {
        return "MatchesSdkCondition{sdk=" + String.valueOf((Object)this.sdk) + ", version='" + this.version + "'}";
    }
}

