/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public final class MatchArgumentQualifier<T>
implements Qualifier<T> {
    private static final Logger LOG = ClassUtils.getLogger(MatchArgumentQualifier.class);
    private final Argument<?> argument;
    private final Argument<?> covariantArgument;

    private MatchArgumentQualifier(Argument<?> argument, Argument<?> covariantArgument) {
        this.argument = argument;
        this.covariantArgument = covariantArgument;
    }

    public static <T> MatchArgumentQualifier<T> ofArgument(Argument<?> argument) {
        return new MatchArgumentQualifier<T>(argument, null);
    }

    @NonNull
    public static <T> MatchArgumentQualifier<T> covariant(@NonNull Class<T> beanType, @NonNull Argument<?> genericArgument) {
        Argument covariantArgument = Argument.ofTypeVariable((Class)genericArgument.getType(), null, (AnnotationMetadata)genericArgument.getAnnotationMetadata(), (Argument[])genericArgument.getTypeParameters());
        return new MatchArgumentQualifier<T>(Argument.of(beanType, (Argument[])new Argument[]{covariantArgument}), covariantArgument);
    }

    @NonNull
    public static <T> MatchArgumentQualifier<T> contravariant(@NonNull Class<T> beanType, @NonNull Argument<?> genericArgument) {
        return new MatchArgumentQualifier<T>(Argument.of(beanType, (Argument[])new Argument[]{Argument.ofTypeVariable((Class)genericArgument.getType(), null, (AnnotationMetadata)genericArgument.getAnnotationMetadata(), (Argument[])genericArgument.getTypeParameters())}), null);
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return this.filter(beanType, candidates.toList()).stream();
    }

    @Override
    public boolean doesQualify(Class<T> beanType, Collection<? extends BeanType<T>> candidates) {
        return !this.filter(beanType, candidates).isEmpty();
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        throw new IllegalStateException("Not supported!");
    }

    @Override
    public <BT extends BeanType<T>> Collection<BT> filter(Class<T> beanType, Collection<BT> candidates) {
        return this.filterArgumentTypeParameters(this.argument, candidates, null);
    }

    private boolean matchesArgumentTypeParameters(Argument<?> argument, Argument<?> candidateArgument) {
        Argument[] candidateTypeParameters;
        Argument[] argumentTypeParameters = argument.getTypeParameters();
        if (argumentTypeParameters.length != (candidateTypeParameters = candidateArgument.getTypeParameters()).length) {
            if (argumentTypeParameters.length == 0) {
                for (Argument candidateTypeParameter : candidateTypeParameters) {
                    if (candidateTypeParameter.getType().equals(Object.class)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        for (int i = 0; i < candidateTypeParameters.length; ++i) {
            Argument typeParameter = argumentTypeParameters[i];
            Argument candidateTypeParameter = candidateTypeParameters[i];
            if (this.doesMatch(candidateTypeParameter, candidateTypeParameter.getType(), typeParameter, typeParameter.getType())) continue;
            return false;
        }
        return true;
    }

    private <BT extends BeanType<T>> Collection<BT> filterArgumentTypeParameters(Argument<?> argument, Collection<BT> result, Function<BT, Argument<?>> typeArgumentExtractor) {
        Argument[] typeParameters = argument.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            int finalI = i;
            Argument typeParameter = typeParameters[i];
            Function<BeanType, Argument> getCandidateArgumentFunction = bd -> {
                if (typeArgumentExtractor == null) {
                    BeanDefinition beanDefinition;
                    List<Argument<?>> typeArguments;
                    if (bd instanceof BeanDefinition && finalI < (typeArguments = (beanDefinition = (BeanDefinition)bd).getTypeArguments(argument.getType())).size()) {
                        return typeArguments.get(finalI);
                    }
                    return null;
                }
                Argument apply = (Argument)typeArgumentExtractor.apply(bd);
                Argument[] candidateTypeParameters = apply.getTypeParameters();
                if (finalI < candidateTypeParameters.length) {
                    return candidateTypeParameters[finalI];
                }
                return Argument.OBJECT_ARGUMENT;
            };
            result = this.filterMatching(typeParameter, result, getCandidateArgumentFunction);
            result = this.filterArgumentTypeParameters(typeParameter, result, getCandidateArgumentFunction);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private <BT extends BeanType<T>> List<BT> filterMatching(Argument<?> argument, Collection<BT> candidates, Function<BT, Argument<?>> typeArgumentExtractor) {
        ArrayList<BeanType> selectedDirect = null;
        boolean directMatch = false;
        ArrayList closestMatches = null;
        block0: for (BeanType candidate : candidates) {
            void var9_9;
            Argument<?> candidateArgument;
            Class clazz = argument.getType();
            if (clazz.isPrimitive()) {
                Class clazz2 = ReflectionUtils.getWrapperType((Class)clazz);
            }
            if ((candidateArgument = typeArgumentExtractor.apply(candidate)) == null) continue;
            Class candidateType = candidateArgument.getType();
            if (var9_9.equals(candidateType)) {
                if (!this.matchesArgumentTypeParameters(argument, candidateArgument)) {
                    MatchArgumentQualifier.reject(argument, candidate);
                    continue;
                }
                if (!directMatch) {
                    selectedDirect = new ArrayList<BeanType>(3);
                    closestMatches = null;
                    directMatch = true;
                }
                selectedDirect.add(candidate);
                continue;
            }
            if (directMatch) {
                MatchArgumentQualifier.reject(argument, candidate);
                continue;
            }
            if (!this.doesMatch(candidateArgument, candidateType, argument, (Class<?>)var9_9)) {
                MatchArgumentQualifier.reject(argument, candidate);
                continue;
            }
            if (closestMatches != null) {
                Iterator iterator = closestMatches.iterator();
                while (iterator.hasNext()) {
                    Map.Entry e = (Map.Entry)iterator.next();
                    Class closestMatch = (Class)e.getKey();
                    List selected = (List)e.getValue();
                    if (closestMatch.equals(candidateType)) {
                        selected.add(candidate);
                        continue block0;
                    }
                    if (closestMatch.isAssignableFrom(candidateType)) {
                        iterator.remove();
                        if (LOG.isTraceEnabled()) {
                            for (BeanType bt : selected) {
                                MatchArgumentQualifier.reject(argument, bt);
                            }
                        }
                        ArrayList<BeanType> newSelected = new ArrayList<BeanType>();
                        newSelected.add(candidate);
                        closestMatches.add(new AbstractMap.SimpleEntry(candidateType, newSelected));
                        continue block0;
                    }
                    if (!candidateType.isAssignableFrom(closestMatch)) continue;
                    MatchArgumentQualifier.reject(argument, candidate);
                    continue block0;
                }
            } else {
                closestMatches = new ArrayList();
            }
            ArrayList<BeanType> newSelected = new ArrayList<BeanType>();
            newSelected.add(candidate);
            closestMatches.add(new AbstractMap.SimpleEntry(candidateType, newSelected));
        }
        if (directMatch) {
            return selectedDirect;
        }
        if (closestMatches != null) {
            if (closestMatches.size() == 1) {
                return (List)((Map.Entry)closestMatches.iterator().next()).getValue();
            }
            ArrayList result = new ArrayList();
            for (Map.Entry entry : closestMatches) {
                result.addAll((Collection)entry.getValue());
            }
            return result;
        }
        return List.of();
    }

    private boolean doesMatch(Argument<?> candidateArgument, Class<?> candidateType, Argument<?> argument, Class<?> argumentType) {
        if (candidateType.equals(argumentType)) {
            return true;
        }
        if (candidateType.equals(Enum.class)) {
            return candidateType.isAssignableFrom(argumentType);
        }
        if (argument.isTypeVariable()) {
            if (argument == this.covariantArgument) {
                if (candidateArgument.isTypeVariable() && candidateType.isAssignableFrom(argumentType)) {
                    return true;
                }
                return argumentType.isAssignableFrom(candidateType);
            }
            return candidateType.isAssignableFrom(argumentType);
        }
        if (candidateType.equals(Object.class)) {
            return true;
        }
        if (!candidateArgument.isTypeVariable()) {
            return false;
        }
        return candidateType.isAssignableFrom(argumentType);
    }

    private static <BT extends BeanType<?>> void reject(Argument<?> argument, BT candidate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bean candidate {} is not compatible with an argument {}", candidate, argument);
        }
    }

    public String toString() {
        return "Matches [" + this.argument.toString() + "]";
    }
}

