/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.json.JsonFeatures;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

@Internal
public final class JacksonFeatures
implements JsonFeatures {
    private final Map<SerializationFeature, Boolean> serializationFeatures = new EnumMap<SerializationFeature, Boolean>(SerializationFeature.class);
    private final Map<DeserializationFeature, Boolean> deserializationFeatures = new EnumMap<DeserializationFeature, Boolean>(DeserializationFeature.class);

    public static JacksonFeatures fromAnnotation(AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn) {
        DeserializationFeature[] disabledDeserializationFeatures;
        SerializationFeature[] disabledSerializationFeatures;
        DeserializationFeature[] enabledDeserializationFeatures;
        JacksonFeatures jacksonFeatures = new JacksonFeatures();
        SerializationFeature[] enabledSerializationFeatures = jacksonFeaturesAnn.get((CharSequence)"enabledSerializationFeatures", SerializationFeature[].class).orElse(null);
        if (enabledSerializationFeatures != null) {
            for (SerializationFeature serializationFeature : enabledSerializationFeatures) {
                jacksonFeatures.addFeature(serializationFeature, true);
            }
        }
        if ((enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"enabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
            for (DeserializationFeature deserializationFeature : enabledDeserializationFeatures) {
                jacksonFeatures.addFeature(deserializationFeature, true);
            }
        }
        if ((disabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
            for (SerializationFeature serializationFeature : disabledSerializationFeatures) {
                jacksonFeatures.addFeature(serializationFeature, false);
            }
        }
        if ((disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
            for (DeserializationFeature feature : disabledDeserializationFeatures) {
                jacksonFeatures.addFeature(feature, false);
            }
        }
        return jacksonFeatures;
    }

    public JacksonFeatures addFeature(SerializationFeature serializationFeature, boolean isEnabled) {
        this.serializationFeatures.put(serializationFeature, isEnabled);
        return this;
    }

    public JacksonFeatures addFeature(DeserializationFeature deserializationFeature, boolean isEnabled) {
        this.deserializationFeatures.put(deserializationFeature, isEnabled);
        return this;
    }

    public Map<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public Map<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonFeatures that = (JacksonFeatures)o;
        return Objects.equals(this.serializationFeatures, that.serializationFeatures) && Objects.equals(this.deserializationFeatures, that.deserializationFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.serializationFeatures, this.deserializationFeatures);
    }
}

