/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.core.parser.JacksonCoreProcessor;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.jackson.core.tree.TreeGenerator;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;

@Internal
@Singleton
@BootstrapContextCompatible
public final class JacksonDatabindMapper
implements JsonMapper {
    private final ObjectMapper objectMapper;
    private final JsonStreamConfig config;
    private final JsonNodeTreeCodec treeCodec;

    @Inject
    @Internal
    public JacksonDatabindMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.config = JsonStreamConfig.DEFAULT.withUseBigDecimalForFloats(objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)).withUseBigIntegerForInts(objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS));
        this.treeCodec = JsonNodeTreeCodec.getInstance().withConfig(this.config);
    }

    @Internal
    public JacksonDatabindMapper() {
        this(new ObjectMapperFactory().objectMapper(null, null));
    }

    @Internal
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <T> T readValueFromTree(@NonNull JsonNode tree, @NonNull Argument<T> type) throws IOException {
        return (T)this.objectMapper.readValue(this.treeAsTokens(tree), JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
    }

    @NonNull
    public JsonNode writeValueToTree(@Nullable Object value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        treeGenerator.setCodec((ObjectCodec)this.objectMapper);
        this.objectMapper.writeValue((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    public <T> T readValue(@NonNull InputStream inputStream, @NonNull Argument<T> type) throws IOException {
        return (T)this.objectMapper.readValue(inputStream, JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
    }

    public <T> T readValue(@NonNull byte[] byteArray, @NonNull Argument<T> type) throws IOException {
        return (T)this.objectMapper.readValue(byteArray, JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
    }

    public void writeValue(@NonNull OutputStream outputStream, @Nullable Object object) throws IOException {
        this.objectMapper.writeValue(outputStream, object);
    }

    public byte[] writeValueAsBytes(@Nullable Object object) throws IOException {
        return this.objectMapper.writeValueAsBytes(object);
    }

    public void updateValueFromTree(Object value, @NonNull JsonNode tree) throws IOException {
        this.objectMapper.readerForUpdating(value).readValue(this.treeAsTokens(tree));
    }

    @NonNull
    public JsonMapper cloneWithFeatures(@NonNull JsonFeatures features) {
        JacksonFeatures jacksonFeatures = (JacksonFeatures)features;
        ObjectMapper objectMapper = this.objectMapper.copy();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        return new JacksonDatabindMapper(objectMapper);
    }

    @NonNull
    public JsonMapper cloneWithViewClass(@NonNull Class<?> viewClass) {
        ObjectMapper objectMapper = this.objectMapper.copy();
        objectMapper.setConfig(objectMapper.getSerializationConfig().withView(viewClass));
        objectMapper.setConfig(objectMapper.getDeserializationConfig().withView(viewClass));
        return new JacksonDatabindMapper(objectMapper);
    }

    @NonNull
    public JsonStreamConfig getStreamConfig() {
        return this.config;
    }

    @NonNull
    public Processor<byte[], JsonNode> createReactiveParser(final Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new JacksonCoreProcessor(streamArray, this.objectMapper.getFactory(), this.config){

            public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                onSubscribe.accept(this);
                super.subscribe(downstreamSubscriber);
            }
        };
    }

    @NonNull
    public Optional<JsonFeatures> detectFeatures(@NonNull AnnotationMetadata annotations) {
        return Optional.ofNullable(annotations.getAnnotation(io.micronaut.jackson.annotation.JacksonFeatures.class)).map(JacksonFeatures::fromAnnotation);
    }

    private JsonParser treeAsTokens(@NonNull JsonNode tree) {
        JsonParser parser = this.treeCodec.treeAsTokens(tree);
        parser.setCodec((ObjectCodec)this.objectMapper);
        return parser;
    }
}

