/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.modules;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.hateoas.Resource;
import io.micronaut.jackson.JacksonConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@Requires(property="jackson.bean-introspection-module", notEquals="false")
public class BeanIntrospectionModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(BeanIntrospectionModule.class);
    boolean ignoreReflectiveProperties = false;

    public BeanIntrospectionModule() {
        this.setDeserializerModifier(new BeanIntrospectionDeserializerModifier());
        this.setSerializerModifier(new BeanIntrospectionSerializerModifier());
    }

    @Nullable
    protected BeanIntrospection<Object> findIntrospection(Class<?> beanClass) {
        return BeanIntrospector.SHARED.findIntrospection(beanClass).orElse(null);
    }

    private JavaType newType(Argument<?> argument, TypeFactory typeFactory) {
        return JacksonConfiguration.constructType(argument, typeFactory);
    }

    private PropertyMetadata newPropertyMetadata(Argument<?> argument, AnnotationMetadata annotationMetadata) {
        Boolean required = argument.isNonNull() || annotationMetadata.booleanValue(JsonProperty.class, "required").orElse(false) != false;
        int index = annotationMetadata.intValue(JsonProperty.class, "index").orElse(-1);
        return PropertyMetadata.construct((Boolean)required, (String)annotationMetadata.stringValue(JsonPropertyDescription.class).orElse(null), (Integer)(index > -1 ? Integer.valueOf(index) : null), (String)annotationMetadata.stringValue(JsonProperty.class, "defaultValue").orElse(null));
    }

    private AnnotatedMember createVirtualMember(TypeResolutionContext typeResolutionContext, Class<?> beanClass, String name, JavaType javaType, final AnnotationMetadata annotationMetadata) {
        return new VirtualAnnotatedMember(typeResolutionContext, beanClass, name, javaType){

            public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
                return Arrays.stream(annoClasses).anyMatch(arg_0 -> ((AnnotationMetadata)annotationMetadata).hasAnnotation(arg_0));
            }
        };
    }

    private static boolean suppressNulls(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        return incl != JsonInclude.Include.ALWAYS && incl != JsonInclude.Include.USE_DEFAULTS;
    }

    private static Object suppressableValue(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        if (incl == JsonInclude.Include.ALWAYS || incl == JsonInclude.Include.NON_NULL || incl == JsonInclude.Include.USE_DEFAULTS) {
            return null;
        }
        return BeanPropertyWriter.MARKER_FOR_EMPTY;
    }

    private <T> T findSerializerFromAnnotation(BeanProperty<?, ?> beanProperty, Class<? extends Annotation> annotationType) {
        Class using;
        AnnotationValue jsonSerializeAnnotation = beanProperty.getAnnotation(annotationType);
        if (jsonSerializeAnnotation != null && (using = (Class)jsonSerializeAnnotation.classValue("using").orElse(null)) != null) {
            BeanIntrospection<Object> usingIntrospection = this.findIntrospection(using);
            if (usingIntrospection != null) {
                return (T)usingIntrospection.instantiate();
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Cannot construct {}, please add the @Introspected annotation to the class declaration", (Object)using.getName());
            }
        }
        return null;
    }

    @NonNull
    private JsonFormat.Value parseJsonFormat(@NonNull AnnotationValue<JsonFormat> formatAnnotation) {
        return new JsonFormat.Value(formatAnnotation.stringValue("pattern").orElse(""), formatAnnotation.enumValue("shape", JsonFormat.Shape.class).orElse(JsonFormat.Shape.ANY), formatAnnotation.stringValue("locale").orElse("##default"), formatAnnotation.stringValue("timezone").orElse("##default"), JsonFormat.Features.construct((JsonFormat.Feature[])((JsonFormat.Feature[])formatAnnotation.enumValues("with", JsonFormat.Feature.class)), (JsonFormat.Feature[])((JsonFormat.Feature[])formatAnnotation.enumValues("without", JsonFormat.Feature.class))), formatAnnotation.enumValue("lenient", OptBoolean.class).orElse(OptBoolean.DEFAULT).asBoolean());
    }

    private static class BeanIntrospectionSetter
    extends SettableBeanProperty.Delegating {
        final BeanProperty beanProperty;

        BeanIntrospectionSetter(SettableBeanProperty methodProperty, BeanProperty beanProperty) {
            super(methodProperty);
            this.beanProperty = beanProperty;
        }

        protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
            return new BeanIntrospectionSetter(d, this.beanProperty);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) {
            this.beanProperty.set(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) {
            this.beanProperty.set(instance, value);
            return null;
        }
    }

    private class BeanIntrospectionPropertyWriter
    extends BeanPropertyWriter {
        protected final Class<?>[] _views;
        final BeanProperty<Object, Object> beanProperty;
        final SerializableString fastName;
        private final JavaType type;
        private final boolean unwrapping;

        BeanIntrospectionPropertyWriter(BeanPropertyWriter src, BeanProperty<Object, Object> introspection, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            this(src.getSerializedName(), src, introspection, ser, typeFactory, views);
        }

        BeanIntrospectionPropertyWriter(SerializableString name, BeanPropertyWriter src, BeanProperty<Object, Object> introspection, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            super(src);
            this._serializer = ser != null ? ser : src.getSerializer();
            this.beanProperty = introspection;
            this.fastName = name;
            this._views = views;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = ser == null ? PropertySerializerMap.emptyForProperties() : null;
            this.unwrapping = introspection.hasAnnotation(JsonUnwrapped.class);
        }

        BeanIntrospectionPropertyWriter(AnnotatedMember virtualMember, SerializationConfig config, String name, BeanProperty<Object, Object> introspection, TypeFactory typeFactory, JsonSerializer<?> ser) {
            super((BeanPropertyDefinition)SimpleBeanPropertyDefinition.construct((MapperConfig)config, (AnnotatedMember)virtualMember), virtualMember, AnnotationCollector.emptyAnnotations(), null, ser, null, null, BeanIntrospectionModule.suppressNulls(config.getDefaultPropertyInclusion()), BeanIntrospectionModule.suppressableValue(config.getDefaultPropertyInclusion()), null);
            this.beanProperty = introspection;
            this.fastName = new SerializedString(name);
            this._views = null;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            this.unwrapping = introspection.hasAnnotation(JsonUnwrapped.class);
        }

        public boolean isUnwrapping() {
            return this.unwrapping;
        }

        public String getName() {
            return this.fastName.getValue();
        }

        public PropertyName getFullName() {
            return new PropertyName(this.getName());
        }

        public void fixAccess(SerializationConfig config) {
        }

        public JavaType getType() {
            return this.type;
        }

        private boolean inView(Class<?> activeView) {
            if (activeView == null || this._views == null) {
                return true;
            }
            int len = this._views.length;
            for (int i = 0; i < len; ++i) {
                if (!this._views[i].isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }

        public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    if (!this.isUnwrapping()) {
                        gen.writeFieldName(this.fastName);
                        this._nullSerializer.serialize(null, gen, prov);
                    }
                } else if (!willSuppressNulls) {
                    gen.writeFieldName(this.fastName);
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
                return;
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            if (this.isUnwrapping()) {
                JsonSerializer unwrappingSerializer = ser.unwrappingSerializer(null);
                unwrappingSerializer.serialize(value, gen, prov);
            } else {
                gen.writeFieldName(this.fastName);
                if (this._typeSerializer == null) {
                    ser.serialize(value, gen, prov);
                } else {
                    ser.serializeWithType(value, gen, prov, this._typeSerializer);
                }
            }
        }

        public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    this._nullSerializer.serialize(null, gen, prov);
                } else if (willSuppressNulls) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                } else {
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null) {
                if (MARKER_FOR_EMPTY == this._suppressableValue) {
                    if (ser.isEmpty(prov, value)) {
                        this.serializeAsPlaceholder(bean, gen, prov);
                        return;
                    }
                } else if (this._suppressableValue.equals(value)) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                    return;
                }
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            if (this._typeSerializer == null) {
                ser.serialize(value, gen, prov);
            } else {
                ser.serializeWithType(value, gen, prov, this._typeSerializer);
            }
        }

        public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
            JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
            JsonFormat.Value v2 = null;
            AnnotationValue formatAnnotation = this.beanProperty.getAnnotation(JsonFormat.class);
            if (formatAnnotation != null) {
                v2 = BeanIntrospectionModule.this.parseJsonFormat((AnnotationValue<JsonFormat>)formatAnnotation);
            }
            if (v1 == null) {
                return v2 == null ? EMPTY_FORMAT : v2;
            }
            return v2 == null ? v1 : v1.withOverrides(v2);
        }
    }

    private class VirtualSetter
    extends SettableBeanProperty {
        final BeanProperty beanProperty;
        final TypeResolutionContext typeResolutionContext;

        VirtualSetter(TypeResolutionContext typeResolutionContext, TypeFactory typeFactory, BeanProperty beanProperty, JsonDeserializer<Object> valueDeser) {
            super(new PropertyName(beanProperty.getName()), BeanIntrospectionModule.this.newType(beanProperty.asArgument(), typeFactory), BeanIntrospectionModule.this.newPropertyMetadata(beanProperty.asArgument(), beanProperty.getAnnotationMetadata()), valueDeser);
            this.beanProperty = beanProperty;
            this.typeResolutionContext = typeResolutionContext;
        }

        VirtualSetter(PropertyName propertyName, VirtualSetter src) {
            super(propertyName, src._type, src._metadata, src._valueDeserializer);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(NullValueProvider nullValueProvider, VirtualSetter src) {
            super((SettableBeanProperty)src, src._valueDeserializer, nullValueProvider);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(JsonDeserializer<Object> deser, VirtualSetter src) {
            super(src._propName, src._type, src._metadata, deser);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
            return new VirtualSetter(deser, this);
        }

        public SettableBeanProperty withName(PropertyName newName) {
            return new VirtualSetter(newName, this);
        }

        public SettableBeanProperty withNullProvider(NullValueProvider nva) {
            return new VirtualSetter(nva, this);
        }

        public AnnotatedMember getMember() {
            return BeanIntrospectionModule.this.createVirtualMember(this.typeResolutionContext, this.beanProperty.getDeclaringType(), this._propName.getSimpleName(), this._type, (AnnotationMetadata)this.beanProperty);
        }

        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A)this.beanProperty.getAnnotationMetadata().synthesize(acls);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.set(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) throws IOException {
            this.beanProperty.set(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) throws IOException {
            this.beanProperty.set(instance, value);
            return null;
        }

        public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
            JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
            JsonFormat.Value v2 = null;
            AnnotationValue formatAnnotation = this.beanProperty.getAnnotation(JsonFormat.class);
            if (formatAnnotation != null) {
                v2 = BeanIntrospectionModule.this.parseJsonFormat((AnnotationValue<JsonFormat>)formatAnnotation);
            }
            if (v1 == null) {
                return v2 == null ? EMPTY_FORMAT : v2;
            }
            return v2 == null ? v1 : v1.withOverrides(v2);
        }
    }

    private class BeanIntrospectionDeserializerModifier
    extends BeanDeserializerModifier {
        private BeanIntrospectionDeserializerModifier() {
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, final BeanDescription beanDesc, final BeanDeserializerBuilder builder) {
            if (builder.getValueInstantiator().getDelegateType(config) != null) {
                return builder;
            }
            final Class beanClass = beanDesc.getBeanClass();
            final BeanIntrospection introspection = BeanIntrospector.SHARED.findIntrospection(beanClass).orElse(null);
            if (introspection == null) {
                return builder;
            }
            Iterator properties = builder.getProperties();
            if ((BeanIntrospectionModule.this.ignoreReflectiveProperties || !properties.hasNext()) && introspection.getPropertyNames().length > 0) {
                for (BeanProperty beanProperty : introspection.getBeanProperties()) {
                    if (beanProperty.isReadOnly()) continue;
                    builder.addOrReplaceProperty((SettableBeanProperty)new VirtualSetter((TypeResolutionContext)beanDesc.getClassInfo(), config.getTypeFactory(), beanProperty, (JsonDeserializer<Object>)((JsonDeserializer)BeanIntrospectionModule.this.findSerializerFromAnnotation(beanProperty, JsonDeserialize.class))), true);
                }
            } else {
                LinkedHashMap<String, BeanProperty> remainingProperties = new LinkedHashMap<String, BeanProperty>();
                for (BeanProperty beanProperty : introspection.getBeanProperties()) {
                    remainingProperties.put(beanProperty.getName(), beanProperty);
                }
                while (properties.hasNext()) {
                    SettableBeanProperty settableBeanProperty = (SettableBeanProperty)properties.next();
                    if (!(settableBeanProperty instanceof MethodProperty)) continue;
                    MethodProperty methodProperty = (MethodProperty)settableBeanProperty;
                    BeanProperty beanProperty = (BeanProperty)remainingProperties.remove(settableBeanProperty.getName());
                    if (beanProperty == null || beanProperty.isReadOnly()) continue;
                    BeanIntrospectionSetter newProperty = new BeanIntrospectionSetter((SettableBeanProperty)methodProperty, beanProperty);
                    builder.addOrReplaceProperty((SettableBeanProperty)newProperty, true);
                }
                for (Map.Entry entry : remainingProperties.entrySet()) {
                    SettableBeanProperty existing;
                    if (((BeanProperty)entry.getValue()).isReadOnly() || (existing = builder.findProperty(PropertyName.construct((String)((String)entry.getKey())))) != null) continue;
                    builder.addOrReplaceProperty((SettableBeanProperty)new VirtualSetter((TypeResolutionContext)beanDesc.getClassInfo(), config.getTypeFactory(), (BeanProperty)entry.getValue(), (JsonDeserializer<Object>)((JsonDeserializer)BeanIntrospectionModule.this.findSerializerFromAnnotation((BeanProperty)entry.getValue(), JsonDeserialize.class))), true);
                }
            }
            final Argument[] constructorArguments = introspection.getConstructorArguments();
            final TypeFactory typeFactory = config.getTypeFactory();
            final ValueInstantiator valueInstantiator = builder.getValueInstantiator();
            builder.setValueInstantiator((ValueInstantiator)new StdValueInstantiator(config, typeFactory.constructType((Type)beanClass)){
                SettableBeanProperty[] props;

                public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                    SettableBeanProperty[] existing = valueInstantiator.getFromObjectArguments(config);
                    if (this.props == null) {
                        this.props = new SettableBeanProperty[constructorArguments.length];
                        for (int i = 0; i < constructorArguments.length; ++i) {
                            SettableBeanProperty settableBeanProperty;
                            TypeDeserializer typeDeserializer;
                            final Argument argument = constructorArguments[i];
                            SettableBeanProperty existingProperty = existing != null && existing.length > i ? existing[i] : null;
                            final JavaType javaType = existingProperty != null ? existingProperty.getType() : BeanIntrospectionModule.this.newType(argument, typeFactory);
                            final AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
                            PropertyMetadata propertyMetadata = BeanIntrospectionModule.this.newPropertyMetadata(argument, annotationMetadata);
                            String simpleName = existingProperty != null ? existingProperty.getName() : annotationMetadata.stringValue(JsonProperty.class).orElse(argument.getName());
                            try {
                                typeDeserializer = config.findTypeDeserializer(javaType);
                            }
                            catch (JsonMappingException e) {
                                typeDeserializer = null;
                            }
                            PropertyName propertyName = PropertyName.construct((String)simpleName);
                            if (typeDeserializer == null && (settableBeanProperty = builder.findProperty(propertyName)) != null) {
                                typeDeserializer = settableBeanProperty.getValueTypeDeserializer();
                            }
                            this.props[i] = new CreatorProperty(propertyName, javaType, null, typeDeserializer, null, null, i, null, propertyMetadata){
                                private final BeanProperty<Object, Object> property;
                                {
                                    super(x0, x1, x2, x3, x4, x5, x6, x7, x8);
                                    this.property = introspection.getProperty(argument.getName()).orElse(null);
                                }

                                public <A extends Annotation> A getAnnotation(Class<A> acls) {
                                    return (A)annotationMetadata.synthesize(acls);
                                }

                                public AnnotatedMember getMember() {
                                    return BeanIntrospectionModule.this.createVirtualMember((TypeResolutionContext)beanDesc.getClassInfo(), beanClass, argument.getName(), javaType, annotationMetadata);
                                }

                                public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                    if (this.property != null) {
                                        this.property.set(instance, this.deserialize(p, ctxt));
                                    }
                                }

                                public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                    if (this.property != null) {
                                        this.property.set(instance, this.deserialize(p, ctxt));
                                    }
                                    return null;
                                }

                                public void set(Object instance, Object value) {
                                    if (this.property != null) {
                                        this.property.set(instance, value);
                                    }
                                }

                                public Object setAndReturn(Object instance, Object value) throws IOException {
                                    if (this.property != null) {
                                        this.property.set(instance, value);
                                    }
                                    return null;
                                }
                            };
                        }
                    }
                    return this.props;
                }

                public boolean canInstantiate() {
                    return true;
                }

                public boolean canCreateUsingDefault() {
                    return constructorArguments.length == 0;
                }

                public boolean canCreateFromObjectWith() {
                    return constructorArguments.length > 0;
                }

                public boolean canCreateUsingArrayDelegate() {
                    return valueInstantiator.canCreateUsingArrayDelegate();
                }

                public boolean canCreateUsingDelegate() {
                    return false;
                }

                public JavaType getArrayDelegateType(DeserializationConfig config) {
                    return BeanIntrospectionModule.this.newType(constructorArguments[0], typeFactory);
                }

                public JavaType getDelegateType(DeserializationConfig config) {
                    return BeanIntrospectionModule.this.newType(constructorArguments[0], typeFactory);
                }

                public boolean canCreateFromString() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.STRING);
                }

                public boolean canCreateFromInt() {
                    return constructorArguments.length == 1 && (constructorArguments[0].equalsType(Argument.INT) || constructorArguments[0].equalsType(Argument.LONG));
                }

                public boolean canCreateFromLong() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.LONG);
                }

                public boolean canCreateFromDouble() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.DOUBLE);
                }

                public boolean canCreateFromBoolean() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.BOOLEAN);
                }

                public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
                    return introspection.instantiate();
                }

                public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
                    return introspection.instantiate(false, new Object[]{delegate});
                }

                public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                    return introspection.instantiate(false, args);
                }

                public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
                    return introspection.instantiate(false, new Object[]{delegate});
                }

                public Object createFromString(DeserializationContext ctxt, String value) throws IOException {
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromInt(DeserializationContext ctxt, int value) throws IOException {
                    try {
                        return introspection.instantiate(false, new Object[]{value});
                    }
                    catch (InstantiationException e) {
                        InstantiationException originalException = e;
                        try {
                            return introspection.instantiate(false, new Object[]{(long)value});
                        }
                        catch (InstantiationException e2) {
                            throw originalException;
                        }
                    }
                }

                public Object createFromLong(DeserializationContext ctxt, long value) throws IOException {
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromDouble(DeserializationContext ctxt, double value) throws IOException {
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws IOException {
                    return introspection.instantiate(false, new Object[]{value});
                }
            });
            return builder;
        }
    }

    private class BeanIntrospectionSerializerModifier
    extends BeanSerializerModifier {
        private BeanIntrospectionSerializerModifier() {
        }

        public BeanSerializerBuilder updateBuilder(final SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            final Class beanClass = beanDesc.getBeanClass();
            boolean isResource = Resource.class.isAssignableFrom(beanDesc.getBeanClass());
            BeanIntrospection<Object> introspection = BeanIntrospectionModule.this.findIntrospection(beanClass);
            if (introspection == null) {
                return super.updateBuilder(config, beanDesc, builder);
            }
            BeanSerializerBuilder newBuilder = new BeanSerializerBuilder(beanDesc){

                public JsonSerializer<?> build() {
                    this.setConfig(config);
                    try {
                        return super.build();
                    }
                    catch (RuntimeException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error building bean serializer for type [" + beanClass + "]: " + e.getMessage(), (Throwable)e);
                        }
                        throw e;
                    }
                }
            };
            newBuilder.setAnyGetter(builder.getAnyGetter());
            List properties = builder.getProperties();
            Collection beanProperties = introspection.getBeanProperties();
            if (BeanIntrospectionModule.this.ignoreReflectiveProperties || CollectionUtils.isEmpty((Collection)properties) && CollectionUtils.isNotEmpty((Collection)beanProperties)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean {} has no properties, while BeanIntrospection does. Recreating from introspection.", (Object)beanClass);
                }
                TypeResolutionContext.Empty typeResolutionContext = new TypeResolutionContext.Empty(config.getTypeFactory());
                ArrayList<BeanIntrospectionPropertyWriter> newProperties = new ArrayList<BeanIntrospectionPropertyWriter>(beanProperties.size());
                for (BeanProperty beanProperty : beanProperties) {
                    String n;
                    if (beanProperty.hasAnnotation(JsonIgnore.class)) continue;
                    String propertyName = isResource ? ("embedded".equals(n = beanProperty.getName()) ? "_embedded" : ("links".equals(n) ? "_links" : beanProperty.stringValue(JsonProperty.class).orElse(beanProperty.getName()))) : beanProperty.stringValue(JsonProperty.class).orElse(beanProperty.getName());
                    BeanIntrospectionPropertyWriter writer = new BeanIntrospectionPropertyWriter(BeanIntrospectionModule.this.createVirtualMember((TypeResolutionContext)typeResolutionContext, beanProperty.getDeclaringType(), propertyName, BeanIntrospectionModule.this.newType(beanProperty.asArgument(), config.getTypeFactory()), (AnnotationMetadata)beanProperty), config, propertyName, (BeanProperty<Object, Object>)beanProperty, config.getTypeFactory(), (JsonSerializer)BeanIntrospectionModule.this.findSerializerFromAnnotation(beanProperty, JsonSerialize.class));
                    newProperties.add(writer);
                }
                newBuilder.setProperties(newProperties);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating {} properties with BeanIntrospection data for type: {}", (Object)properties.size(), (Object)beanClass);
                }
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>(properties);
                LinkedHashMap named = new LinkedHashMap(properties.size());
                for (BeanProperty beanProperty : beanProperties) {
                    Optional n = beanProperty.stringValue(JsonProperty.class);
                    n.ifPresent(s -> named.put(s, beanProperty));
                }
                for (int i = 0; i < properties.size(); ++i) {
                    BeanPropertyWriter existing = (BeanPropertyWriter)properties.get(i);
                    String existingName = existing.getName();
                    Optional property = named.containsKey(existingName) ? Optional.of(named.get(existingName)) : introspection.getProperty(existingName);
                    if (property.isPresent()) {
                        BeanProperty beanProperty = (BeanProperty)property.get();
                        if (isResource) {
                            if ("embedded".equals(beanProperty.getName())) {
                                newProperties.set(i, new BeanIntrospectionPropertyWriter((SerializableString)new SerializedString("_embedded"), existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                                continue;
                            }
                            if ("links".equals(beanProperty.getName())) {
                                newProperties.set(i, new BeanIntrospectionPropertyWriter((SerializableString)new SerializedString("_links"), existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                                continue;
                            }
                        }
                        newProperties.set(i, new BeanIntrospectionPropertyWriter(existing, (BeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                        continue;
                    }
                    newProperties.set(i, existing);
                }
                newBuilder.setProperties(newProperties);
            }
            newBuilder.setFilteredProperties(builder.getFilteredProperties());
            return newBuilder;
        }
    }
}

