/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.bind;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.json.JsonConfiguration;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.bind.JsonBeanPropertyBinderExceptionHandler;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
@Primary
final class JsonBeanPropertyBinder
implements BeanPropertyBinder {
    private final JsonMapper jsonMapper;
    private final int arraySizeThreshhold;
    private final BeanProvider<JsonBeanPropertyBinderExceptionHandler> exceptionHandlers;

    JsonBeanPropertyBinder(JsonMapper jsonMapper, JsonConfiguration configuration, BeanProvider<JsonBeanPropertyBinderExceptionHandler> exceptionHandlers) {
        this.jsonMapper = jsonMapper;
        this.arraySizeThreshhold = configuration.getArraySizeThreshold();
        this.exceptionHandlers = exceptionHandlers;
    }

    public ArgumentBinder.BindingResult<Object> bind(final ArgumentConversionContext<Object> context, Map<CharSequence, ? super Object> source) {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source.entrySet());
            Object result = this.jsonMapper.readValueFromTree(objectNode, context.getArgument());
            return () -> Optional.of(result);
        }
        catch (Exception e) {
            context.reject(e);
            return new ArgumentBinder.BindingResult<Object>(){

                public List<ConversionError> getConversionErrors() {
                    return CollectionUtils.iterableToList((Iterable)context);
                }

                public boolean isSatisfied() {
                    return false;
                }

                public Optional<Object> getValue() {
                    return Optional.empty();
                }
            };
        }
    }

    public <T2> T2 bind(Class<T2> type, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            return this.jsonMapper.readValueFromTree(objectNode, type);
        }
        catch (Exception e) {
            throw this.newConversionError(null, e);
        }
    }

    public <T2> T2 bind(T2 object, ArgumentConversionContext<T2> context, Set<? extends Map.Entry<? extends CharSequence, Object>> source) {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            this.jsonMapper.updateValueFromTree(object, objectNode);
        }
        catch (Exception e) {
            context.reject(e);
        }
        return object;
    }

    public <T2> T2 bind(T2 object, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            this.jsonMapper.updateValueFromTree(object, objectNode);
        }
        catch (Exception e) {
            throw this.newConversionError(object, e);
        }
        return object;
    }

    protected ConversionErrorException newConversionError(Object object, final Exception e) {
        for (JsonBeanPropertyBinderExceptionHandler exceptionHandler : this.exceptionHandlers) {
            Optional<ConversionErrorException> handled = exceptionHandler.toConversionError(object, e);
            if (!handled.isPresent()) continue;
            return handled.get();
        }
        ConversionError conversionError = new ConversionError(){

            public Exception getCause() {
                return e;
            }

            public Optional<Object> getOriginalValue() {
                return Optional.empty();
            }
        };
        Class type = object != null ? object.getClass() : Object.class;
        return new ConversionErrorException(Argument.of(type), conversionError);
    }

    private JsonNode buildSourceObjectNode(Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws IOException {
        ObjectBuilder rootNode = new ObjectBuilder();
        for (Map.Entry<? extends CharSequence, Object> entry : source) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            String property = key.toString();
            ValueBuilder current = rootNode;
            String index = null;
            Iterator tokenIterator = StringUtils.splitOmitEmptyStringsIterator((CharSequence)property, (char)'.');
            while (tokenIterator.hasNext()) {
                ValueBuilder jsonNode;
                ArrayBuilder arrayNode;
                ObjectBuilder objectNode;
                String token = (String)tokenIterator.next();
                int j = token.indexOf(91);
                if (j > -1 && token.endsWith("]")) {
                    index = token.substring(j + 1, token.length() - 1);
                    token = token.substring(0, j);
                }
                if (!tokenIterator.hasNext()) {
                    if (current instanceof ObjectBuilder) {
                        objectNode = current;
                        if (index != null) {
                            ValueBuilder existing = objectNode.values.get(index);
                            if (!(existing instanceof ObjectBuilder)) {
                                existing = new ObjectBuilder();
                                objectNode.values.put(index, existing);
                            }
                            ObjectBuilder node = (ObjectBuilder)existing;
                            node.values.put(token, new FixedValue(this.jsonMapper.writeValueToTree(value)));
                            index = null;
                            continue;
                        }
                        objectNode.values.put(token, new FixedValue(this.jsonMapper.writeValueToTree(value)));
                        continue;
                    }
                    if (!(current instanceof ArrayBuilder) || index == null) continue;
                    arrayNode = (ArrayBuilder)current;
                    int arrayIndex = Integer.parseInt(index);
                    if (arrayIndex < this.arraySizeThreshhold) {
                        if (arrayIndex >= arrayNode.values.size()) {
                            this.expandArrayToThreshold(arrayIndex, arrayNode);
                        }
                        if (!((jsonNode = arrayNode.values.get(arrayIndex)) instanceof ObjectBuilder)) {
                            jsonNode = new ObjectBuilder();
                            arrayNode.values.set(arrayIndex, jsonNode);
                        }
                        jsonNode.values.put(token, new FixedValue(this.jsonMapper.writeValueToTree(value)));
                    }
                    index = null;
                    continue;
                }
                if (current instanceof ObjectBuilder) {
                    objectNode = current;
                    ValueBuilder existing = objectNode.values.get(token);
                    if (index != null) {
                        if (StringUtils.isDigits((String)index)) {
                            ArrayBuilder arrayNode2;
                            int arrayIndex = Integer.parseInt(index);
                            if (!(existing instanceof ArrayBuilder)) {
                                ArrayBuilder arrayNode3 = new ArrayBuilder();
                                objectNode.values.put(token, arrayNode3);
                            } else {
                                arrayNode2 = (ArrayBuilder)existing;
                            }
                            this.expandArrayToThreshold(arrayIndex, arrayNode2);
                            jsonNode = this.getOrCreateNodeAtIndex(arrayNode2, arrayIndex);
                        } else {
                            if (!(existing instanceof ObjectBuilder)) {
                                existing = new ObjectBuilder();
                                objectNode.values.put(token, existing);
                            }
                            if (!((jsonNode = ((ObjectBuilder)existing).values.get(index)) instanceof ObjectBuilder)) {
                                jsonNode = new ObjectBuilder();
                                ((ObjectBuilder)existing).values.put(index, jsonNode);
                            }
                        }
                        current = jsonNode;
                        index = null;
                        continue;
                    }
                    if (!(existing instanceof ObjectBuilder)) {
                        existing = new ObjectBuilder();
                        objectNode.values.put(token, existing);
                    }
                    current = existing;
                    continue;
                }
                if (!(current instanceof ArrayBuilder) || !StringUtils.isDigits(index)) continue;
                arrayNode = (ArrayBuilder)current;
                int arrayIndex = Integer.parseInt(index);
                this.expandArrayToThreshold(arrayIndex, arrayNode);
                jsonNode = this.getOrCreateNodeAtIndex(arrayNode, arrayIndex);
                current = new ObjectBuilder();
                jsonNode.values.put(token, current);
                index = null;
            }
        }
        return rootNode.build();
    }

    private ObjectBuilder getOrCreateNodeAtIndex(ArrayBuilder arrayNode, int arrayIndex) {
        ValueBuilder jsonNode = arrayNode.values.get(arrayIndex);
        if (!(jsonNode instanceof ObjectBuilder)) {
            jsonNode = new ObjectBuilder();
            arrayNode.values.set(arrayIndex, jsonNode);
        }
        return (ObjectBuilder)jsonNode;
    }

    private void expandArrayToThreshold(int arrayIndex, ArrayBuilder arrayNode) {
        if (arrayIndex < this.arraySizeThreshhold) {
            while (arrayNode.values.size() != arrayIndex + 1) {
                arrayNode.values.add(FixedValue.NULL);
            }
        }
    }

    private static final class ObjectBuilder
    implements ValueBuilder {
        final Map<String, ValueBuilder> values = new LinkedHashMap<String, ValueBuilder>();

        private ObjectBuilder() {
        }

        @Override
        public JsonNode build() {
            LinkedHashMap<String, JsonNode> built = new LinkedHashMap<String, JsonNode>(this.values.size());
            for (Map.Entry<String, ValueBuilder> entry : this.values.entrySet()) {
                built.put(entry.getKey(), entry.getValue().build());
            }
            return JsonNode.createObjectNode(built);
        }
    }

    private static interface ValueBuilder {
        public JsonNode build();
    }

    private static final class FixedValue
    implements ValueBuilder {
        static final FixedValue NULL = new FixedValue(JsonNode.nullNode());
        final JsonNode value;

        FixedValue(JsonNode value) {
            this.value = value;
        }

        @Override
        public JsonNode build() {
            return this.value;
        }
    }

    private static final class ArrayBuilder
    implements ValueBuilder {
        final List<ValueBuilder> values = new ArrayList<ValueBuilder>();

        private ArrayBuilder() {
        }

        @Override
        public JsonNode build() {
            return JsonNode.createArrayNode(this.values.stream().map(ValueBuilder::build).collect(Collectors.toList()));
        }
    }
}

