/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.tree;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.json.tree.JsonScalar;

final class JsonNumber
extends JsonScalar {
    @NonNull
    private final Number value;

    JsonNumber(@NonNull Number value) {
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    @NonNull
    public Number getNumberValue() {
        return this.value;
    }

    @Override
    @NonNull
    public String coerceStringValue() {
        return this.value.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof JsonNumber)) return false;
        JsonNumber jn = (JsonNumber)o;
        if (!jn.value.equals(this.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

