/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.routes;

import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.routes.RouteDataCollector;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRoute;
import io.reactivex.Single;
import java.util.Comparator;
import java.util.stream.Stream;

@Endpoint(value="routes")
public class RoutesEndpoint {
    private final Router router;
    private final RouteDataCollector routeDataCollector;

    public RoutesEndpoint(Router router, RouteDataCollector routeDataCollector) {
        this.router = router;
        this.routeDataCollector = routeDataCollector;
    }

    @Read
    public Single getRoutes() {
        Stream<UriRoute> uriRoutes = this.router.uriRoutes().sorted(Comparator.comparing(r -> r.getUriMatchTemplate().toPathString()).thenComparing(r -> r.getHttpMethod().ordinal()));
        return Single.fromPublisher(this.routeDataCollector.getData(uriRoutes));
    }
}

