/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointSensitivityProcessor;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatchUtils;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Requires(property="micronaut.security.enabled", notEquals="true")
@Filter(value={"/**"})
public class EndpointsFilter
extends OncePerRequestHttpServerFilter {
    private final Map<ExecutableMethod, Boolean> endpointMethods;

    public EndpointsFilter(EndpointSensitivityProcessor endpointSensitivityProcessor) {
        this.endpointMethods = endpointSensitivityProcessor.getEndpointMethods();
    }

    protected Publisher<MutableHttpResponse<?>> doFilterOnce(HttpRequest<?> request, ServerFilterChain chain) {
        ExecutableMethod method;
        Optional routeMatch = RouteMatchUtils.findRouteMatch(request);
        if (routeMatch.isPresent() && routeMatch.get() instanceof MethodBasedRouteMatch && this.endpointMethods.getOrDefault(method = ((MethodBasedRouteMatch)routeMatch.get()).getExecutableMethod(), false).booleanValue()) {
            return Publishers.just((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
        }
        return chain.proceed(request);
    }
}

