/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.loggers;

import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.type.Argument;
import io.micronaut.logging.LogLevel;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import io.micronaut.management.endpoint.annotation.Write;
import io.micronaut.management.endpoint.loggers.LoggersManager;
import io.micronaut.management.endpoint.loggers.LoggingSystem;
import io.reactivex.Single;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;

@Endpoint(id="loggers", defaultEnabled=true, defaultSensitive=false)
public class LoggersEndpoint {
    public static final String NAME = "loggers";
    public static final String PREFIX = "endpoints.loggers";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_SENSITIVE = false;
    private final LoggingSystem loggingSystem;
    private final LoggersManager<Map<String, Object>> loggersManager;

    public LoggersEndpoint(LoggingSystem loggingSystem, LoggersManager<Map<String, Object>> loggersManager) {
        this.loggingSystem = loggingSystem;
        this.loggersManager = loggersManager;
    }

    @Read
    public Single<Map<String, Object>> loggers() {
        return Single.fromPublisher(this.loggersManager.getLoggers(this.loggingSystem));
    }

    @Read
    public Single<Map<String, Object>> logger(@NotBlank @Selector String name) {
        return Single.fromPublisher(this.loggersManager.getLogger(this.loggingSystem, name));
    }

    @Write
    public void setLogLevel(@NotBlank @Selector String name, @Nullable LogLevel configuredLevel) {
        try {
            this.loggersManager.setLogLevel(this.loggingSystem, name, configuredLevel != null ? configuredLevel : LogLevel.NOT_SPECIFIED);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsatisfiedArgumentException(Argument.of(LogLevel.class, (String)"configuredLevel"), "Invalid log level specified: " + configuredLevel);
        }
    }
}

