/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.beans.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.endpoint.beans.BeanDefinitionData;
import io.micronaut.management.endpoint.beans.BeanDefinitionDataCollector;
import io.micronaut.management.endpoint.beans.BeansEndpoint;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={BeansEndpoint.class})
public class RxJavaBeanDefinitionDataCollector
implements BeanDefinitionDataCollector<Map<String, Object>> {
    private BeanDefinitionData beanDefinitionData;
    private ExecutorService executorService;

    RxJavaBeanDefinitionDataCollector(BeanDefinitionData beanDefinitionData, @Named(value="io") ExecutorService executorService) {
        this.beanDefinitionData = beanDefinitionData;
        this.executorService = executorService;
    }

    @Override
    public Publisher<Map<String, Object>> getData(Collection<BeanDefinition<?>> beanDefinitions) {
        return this.getBeans(beanDefinitions).map(beans -> {
            LinkedHashMap<String, Map> beanData = new LinkedHashMap<String, Map>(1);
            beanData.put("beans", (Map)beans);
            return beanData;
        }).toFlowable();
    }

    protected Single<Map<String, Object>> getBeans(Collection<BeanDefinition<?>> definitions) {
        LinkedHashMap beans = new LinkedHashMap(definitions.size());
        return Flowable.fromIterable(definitions).subscribeOn(Schedulers.from((Executor)this.executorService)).collectInto(beans, (map, definition) -> map.put(definition.getClass().getName(), this.beanDefinitionData.getData((BeanDefinition<?>)definition)));
    }
}

