/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.loggers.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.loggers.LogLevel;
import io.micronaut.management.endpoint.loggers.LoggerConfiguration;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.loggers.LoggingSystem;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={LoggersEndpoint.class}), @Requires(classes={LoggerContext.class})})
@Replaces(value=io.micronaut.logging.impl.LogbackLoggingSystem.class)
public class LogbackLoggingSystem
implements LoggingSystem {
    @Override
    public Collection<LoggerConfiguration> getLoggers() {
        return LogbackLoggingSystem.getLoggerContext().getLoggerList().stream().map(LogbackLoggingSystem::toLoggerConfiguration).collect(Collectors.toList());
    }

    @Override
    public LoggerConfiguration getLogger(String name) {
        return LogbackLoggingSystem.toLoggerConfiguration(LogbackLoggingSystem.getLoggerContext().getLogger(name));
    }

    @Override
    @Deprecated
    public void setLogLevel(@NotBlank String name, @NotNull LogLevel level) {
        LogbackLoggingSystem.getLoggerContext().getLogger(name).setLevel(LogbackLoggingSystem.toLevel(io.micronaut.logging.LogLevel.valueOf((String)level.name())));
    }

    @Override
    public void setLogLevel(String name, io.micronaut.logging.LogLevel level) {
        LogbackLoggingSystem.getLoggerContext().getLogger(name).setLevel(LogbackLoggingSystem.toLevel(level));
    }

    private static LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    private static LoggerConfiguration toLoggerConfiguration(Logger logger) {
        return new LoggerConfiguration(logger.getName(), LogbackLoggingSystem.toLogLevel(logger.getLevel()), LogbackLoggingSystem.toLogLevel(logger.getEffectiveLevel()));
    }

    private static io.micronaut.logging.LogLevel toLogLevel(Level level) {
        if (level == null) {
            return io.micronaut.logging.LogLevel.NOT_SPECIFIED;
        }
        return io.micronaut.logging.LogLevel.valueOf((String)level.toString());
    }

    private static Level toLevel(io.micronaut.logging.LogLevel logLevel) {
        if (logLevel == io.micronaut.logging.LogLevel.NOT_SPECIFIED) {
            return null;
        }
        return Level.valueOf((String)logLevel.name());
    }
}

