/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.refresh;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Write;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.Map;
import java.util.Set;

@Endpoint(value="refresh")
public class RefreshEndpoint {
    private final Environment environment;
    private final ApplicationEventPublisher eventPublisher;

    public RefreshEndpoint(Environment environment, ApplicationEventPublisher eventPublisher) {
        this.environment = environment;
        this.eventPublisher = eventPublisher;
    }

    @Write
    public String[] refresh(@Nullable Boolean force) {
        if (force != null && force.booleanValue()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent());
            return new String[0];
        }
        Map changes = this.environment.refreshAndDiff();
        if (!changes.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent(changes));
        }
        Set keys = changes.keySet();
        return keys.toArray(new String[0]);
    }
}

