/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.routes.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MediaType;
import io.micronaut.management.endpoint.routes.RouteData;
import io.micronaut.management.endpoint.routes.RouteDataCollector;
import io.micronaut.management.endpoint.routes.RoutesEndpoint;
import io.micronaut.web.router.UriRoute;
import io.reactivex.Flowable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={RoutesEndpoint.class})
public class RxJavaRouteDataCollector
implements RouteDataCollector<Map<String, Object>> {
    private final RouteData routeData;

    public RxJavaRouteDataCollector(RouteData routeData) {
        this.routeData = routeData;
    }

    @Override
    public Publisher<Map<String, Object>> getData(Stream<UriRoute> routes) {
        List routeList = routes.collect(Collectors.toList());
        LinkedHashMap routeMap = new LinkedHashMap(routeList.size());
        return Flowable.fromIterable(routeList).collectInto(routeMap, (map, route) -> map.put(this.getRouteKey((UriRoute)route), this.routeData.getData((UriRoute)route))).toFlowable();
    }

    protected String getRouteKey(UriRoute route) {
        String produces = route.getProduces().stream().map(MediaType::toString).collect(Collectors.joining(" || "));
        return "{[" + route.getUriMatchTemplate() + "],method=[" + route.getHttpMethodName() + "],produces=[" + produces + "]}";
    }
}

