/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.loggers.impl;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.logging.LogLevel;
import io.micronaut.logging.LoggingSystem;
import io.micronaut.management.endpoint.loggers.LoggerConfiguration;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.loggers.ManagedLoggingSystem;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

@Singleton
@Requirements(value={@Requires(beans={LoggersEndpoint.class}), @Requires(classes={LoggerContext.class})})
@Replaces(value=io.micronaut.logging.impl.Log4jLoggingSystem.class)
public class Log4jLoggingSystem
implements ManagedLoggingSystem,
LoggingSystem {
    @Override
    @NonNull
    public Collection<LoggerConfiguration> getLoggers() {
        return this.getLog4jLoggerContext().getLoggers().stream().map(Log4jLoggingSystem::toLoggerConfiguration).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public LoggerConfiguration getLogger(String name) {
        return Log4jLoggingSystem.toLoggerConfiguration(LogManager.getLogger((String)name));
    }

    public void setLogLevel(String name, LogLevel level) {
        if (name.equalsIgnoreCase("root")) {
            Configurator.setRootLevel((Level)Log4jLoggingSystem.toLog4jLevel(level));
        } else {
            Configurator.setLevel((String)name, (Level)Log4jLoggingSystem.toLog4jLevel(level));
        }
    }

    private LoggerContext getLog4jLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    private static Level toLog4jLevel(LogLevel logLevel) {
        if (logLevel == LogLevel.NOT_SPECIFIED) {
            return null;
        }
        return Level.valueOf((String)logLevel.name());
    }

    private static LoggerConfiguration toLoggerConfiguration(Logger logger) {
        return new LoggerConfiguration(logger.getName(), Log4jLoggingSystem.toMicronautLogLevel(logger.getLevel()), Log4jLoggingSystem.toMicronautLogLevel(logger.getLevel()));
    }

    private static LogLevel toMicronautLogLevel(Level level) {
        if (level == null) {
            return LogLevel.NOT_SPECIFIED;
        }
        return LogLevel.valueOf((String)level.toString());
    }
}

