/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.management.endpoint.EndpointDefaultConfiguration;
import java.util.Optional;

@EachProperty(value="endpoints")
public class EndpointConfiguration {
    public static final String PREFIX = "endpoints";
    private Boolean enabled;
    private Boolean sensitive;
    private final String id;
    private EndpointDefaultConfiguration defaultConfiguration;

    public EndpointConfiguration(@Parameter String id, EndpointDefaultConfiguration defaultConfiguration) {
        this.id = id;
        this.defaultConfiguration = defaultConfiguration;
    }

    public String getId() {
        return this.id;
    }

    public Optional<Boolean> isEnabled() {
        if (this.enabled != null) {
            return Optional.of(this.enabled);
        }
        return this.defaultConfiguration.isEnabled();
    }

    public Optional<Boolean> isSensitive() {
        if (this.sensitive != null) {
            return Optional.of(this.sensitive);
        }
        return this.defaultConfiguration.isSensitive();
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }
}

