/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.loggers.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.logging.LogLevel;
import io.micronaut.logging.LoggingSystem;
import io.micronaut.management.endpoint.loggers.LoggerConfiguration;
import io.micronaut.management.endpoint.loggers.LoggersEndpoint;
import io.micronaut.management.endpoint.loggers.ManagedLoggingSystem;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={LoggersEndpoint.class}), @Requires(classes={LoggerContext.class})})
@Replaces(value=io.micronaut.logging.impl.LogbackLoggingSystem.class)
public class LogbackLoggingSystem
implements ManagedLoggingSystem,
LoggingSystem {
    @Override
    @NonNull
    public Collection<LoggerConfiguration> getLoggers() {
        return LogbackLoggingSystem.getLoggerContext().getLoggerList().stream().map(LogbackLoggingSystem::toLoggerConfiguration).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public LoggerConfiguration getLogger(String name) {
        return LogbackLoggingSystem.toLoggerConfiguration(LogbackLoggingSystem.getLoggerContext().getLogger(name));
    }

    public void setLogLevel(String name, LogLevel level) {
        LogbackLoggingSystem.getLoggerContext().getLogger(name).setLevel(LogbackLoggingSystem.toLevel(level));
    }

    private static LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    private static LoggerConfiguration toLoggerConfiguration(Logger logger) {
        return new LoggerConfiguration(logger.getName(), LogbackLoggingSystem.toLogLevel(logger.getLevel()), LogbackLoggingSystem.toLogLevel(logger.getEffectiveLevel()));
    }

    private static LogLevel toLogLevel(Level level) {
        if (level == null) {
            return LogLevel.NOT_SPECIFIED;
        }
        return LogLevel.valueOf((String)level.toString());
    }

    private static Level toLevel(LogLevel logLevel) {
        if (logLevel == LogLevel.NOT_SPECIFIED) {
            return null;
        }
        return Level.valueOf((String)logLevel.name());
    }
}

