/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.routes.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MediaType;
import io.micronaut.management.endpoint.routes.RouteData;
import io.micronaut.management.endpoint.routes.RouteDataCollector;
import io.micronaut.management.endpoint.routes.RoutesEndpoint;
import io.micronaut.web.router.UriRouteInfo;
import jakarta.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
@Requires(beans={RoutesEndpoint.class})
public class DefaultRouteDataCollector
implements RouteDataCollector<Map<String, Object>> {
    private final RouteData<Object> routeData;

    public DefaultRouteDataCollector(RouteData<Object> routeData) {
        this.routeData = routeData;
    }

    @Override
    public Map<String, Object> getData(Stream<UriRouteInfo<?, ?>> routes) {
        return routes.collect(Collectors.toMap(this::getRouteKey, this.routeData::getData, (e1, e2) -> e1, LinkedHashMap::new));
    }

    protected String getRouteKey(UriRouteInfo<?, ?> route) {
        String produces = route.getProduces().stream().map(MediaType::toString).collect(Collectors.joining(" || "));
        return "{[" + String.valueOf(route.getUriMatchTemplate()) + "],method=[" + route.getHttpMethodName() + "],produces=[" + produces + "]}";
    }
}

