/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.routes.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.management.endpoint.routes.RouteData;
import io.micronaut.management.endpoint.routes.RoutesEndpoint;
import io.micronaut.web.router.UriRouteInfo;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
@Requires(beans={RoutesEndpoint.class})
public class DefaultRouteData
implements RouteData<Map<String, String>> {
    @Override
    public Map<String, String> getData(UriRouteInfo<?, ?> routeInfo) {
        return Collections.singletonMap("method", this.getMethodString(routeInfo.getTargetMethod()));
    }

    protected String getMethodString(MethodExecutionHandle<?, ?> targetMethod) {
        return targetMethod.getReturnType().asArgument().getTypeString(false) + " " + targetMethod.getDeclaringType().getName() + "." + targetMethod.getMethodName() + "(" + Arrays.stream(targetMethod.getArguments()).map(argument -> argument.getType().getName() + " " + argument.getName()).collect(Collectors.joining(", ")) + ")";
    }
}

