/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthResult;
import java.util.Map;

@Introspected
@ReflectiveAccess
class DefaultHealthResult
implements HealthResult {
    private final String name;
    private final HealthStatus healthStatus;
    private final Object details;

    DefaultHealthResult(String name, HealthStatus healthStatus, Object details) {
        this.name = name;
        this.healthStatus = healthStatus;
        this.details = details;
    }

    @JsonCreator
    DefaultHealthResult(@JsonProperty(value="name") String name, @JsonProperty(value="status") String status, @JsonProperty(value="details") Map<String, Object> details) {
        this.name = name;
        switch (status) {
            case "DOWN": {
                this.healthStatus = HealthStatus.DOWN;
                break;
            }
            case "UP": {
                this.healthStatus = HealthStatus.UP;
                break;
            }
            default: {
                this.healthStatus = new HealthStatus(status);
            }
        }
        this.details = details;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HealthStatus getStatus() {
        return this.healthStatus;
    }

    @Override
    public Object getDetails() {
        return this.details;
    }
}

