/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.env;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import io.micronaut.management.endpoint.env.EnvironmentEndpointFilter;
import io.micronaut.management.endpoint.env.EnvironmentFilterSpecification;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Endpoint(id="env", defaultEnabled=false)
public class EnvironmentEndpoint {
    public static final String NAME = "env";
    private static final String ACTIVE_ENVIRONMENTS_KEY = "activeEnvironments";
    private static final String PACKAGES_KEY = "packages";
    private static final String PROPERTY_SOURCES_KEY = "propertySources";
    private static final List<String> DEFAULT_ACTIVE_SECTIONS = List.of("activeEnvironments", "packages", "propertySources");
    private static final String MASK_VALUE = "*****";
    private final Environment environment;
    private final EnvironmentEndpointFilter environmentFilter;
    private List<String> activeKeys = DEFAULT_ACTIVE_SECTIONS;

    public EnvironmentEndpoint(Environment environment) {
        this(environment, null);
    }

    @Inject
    public EnvironmentEndpoint(Environment environment, @Nullable EnvironmentEndpointFilter environmentFilter) {
        this.environment = environment;
        this.environmentFilter = environmentFilter;
    }

    public List<String> getActiveKeys() {
        return this.activeKeys;
    }

    public void setActiveKeys(List<String> activeKeys) {
        this.activeKeys = activeKeys;
    }

    @Read
    public Map<String, Object> getEnvironmentInfo() {
        EnvironmentFilterSpecification filter = this.createFilterSpecification();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<String> activeKeys = this.getActiveKeys();
        if (activeKeys.contains(ACTIVE_ENVIRONMENTS_KEY)) {
            result.put(ACTIVE_ENVIRONMENTS_KEY, this.environment.getActiveNames());
        }
        if (activeKeys.contains(PACKAGES_KEY)) {
            result.put(PACKAGES_KEY, this.environment.getPackages());
        }
        if (activeKeys.contains(PROPERTY_SOURCES_KEY)) {
            ArrayList propertySources = new ArrayList();
            this.environment.getPropertySources().stream().sorted(Comparator.comparing(Ordered::getOrder)).map(ps -> this.buildPropertySourceInfo((PropertySource)ps, filter)).forEach(propertySources::add);
            result.put(PROPERTY_SOURCES_KEY, propertySources);
        }
        return result;
    }

    @Read
    public Map<String, Object> getProperties(@Selector String propertySourceName) {
        EnvironmentFilterSpecification filter = this.createFilterSpecification();
        return this.environment.getPropertySources().stream().filter(ps -> ps.getName().equals(propertySourceName)).findFirst().map(ps -> this.buildPropertySourceInfo((PropertySource)ps, filter)).orElse(null);
    }

    private EnvironmentFilterSpecification createFilterSpecification() {
        EnvironmentFilterSpecification filter = new EnvironmentFilterSpecification();
        if (this.environmentFilter != null) {
            this.environmentFilter.specifyFiltering(filter);
        }
        return filter;
    }

    private Map<String, Object> getAllProperties(PropertySource propertySource, EnvironmentFilterSpecification filter) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        propertySource.forEach(k -> {
            EnvironmentFilterSpecification.FilterResult test = filter.test((String)k);
            if (test != EnvironmentFilterSpecification.FilterResult.HIDE) {
                properties.put((String)k, test == EnvironmentFilterSpecification.FilterResult.MASK ? MASK_VALUE : propertySource.get(k));
            }
        });
        return properties;
    }

    private Map<String, Object> buildPropertySourceInfo(PropertySource propertySource, EnvironmentFilterSpecification filter) {
        LinkedHashMap<String, Object> propertySourceInfo = new LinkedHashMap<String, Object>();
        propertySourceInfo.put("name", propertySource.getName());
        propertySourceInfo.put("order", propertySource.getOrder());
        propertySourceInfo.put("convention", propertySource.getConvention().name());
        propertySourceInfo.put("properties", this.getAllProperties(propertySource, filter));
        return propertySourceInfo;
    }
}

