/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.annotation.CircuitBreaker;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.retry.event.RetryEvent;
import io.micronaut.retry.intercept.AnnotationRetryStateBuilder;
import io.micronaut.retry.intercept.CircuitBreakerRetry;
import io.micronaut.retry.intercept.MutableRetryState;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
public class DefaultRetryInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRetryInterceptor.class);
    private static final int DEFAULT_CIRCUIT_BREAKER_TIMEOUT_IN_MILLIS = 20;
    private final ConversionService conversionService;
    private final ApplicationEventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final Map<ExecutableMethod, CircuitBreakerRetry> circuitContexts = new ConcurrentHashMap<ExecutableMethod, CircuitBreakerRetry>();

    public DefaultRetryInterceptor(ConversionService conversionService, ApplicationEventPublisher eventPublisher, @Named(value="scheduled") ExecutorService executorService) {
        this.conversionService = conversionService;
        this.eventPublisher = eventPublisher;
        this.executorService = (ScheduledExecutorService)executorService;
    }

    public int getOrder() {
        return InterceptPhase.RETRY.getPosition();
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        MutableRetryState retryState;
        Optional opt = context.findAnnotation(Retryable.class);
        if (opt.isEmpty()) {
            return context.proceed();
        }
        AnnotationValue retry = (AnnotationValue)opt.get();
        boolean isCircuitBreaker = context.hasStereotype(CircuitBreaker.class);
        AnnotationRetryStateBuilder retryStateBuilder = new AnnotationRetryStateBuilder((AnnotationMetadata)context);
        if (isCircuitBreaker) {
            long timeout = context.getValue(CircuitBreaker.class, "reset", Duration.class).map(Duration::toMillis).orElse(Duration.ofSeconds(20L).toMillis());
            boolean wrapException = context.getValue(CircuitBreaker.class, "throwWrappedException", Boolean.class).orElse(false);
            retryState = this.circuitContexts.computeIfAbsent(context.getExecutableMethod(), method -> new CircuitBreakerRetry(timeout, retryStateBuilder, (ExecutableMethod<?, ?>)context, this.eventPublisher, wrapException));
        } else {
            retryState = (MutableRetryState)retryStateBuilder.build();
        }
        MutableConvertibleValues attrs = context.getAttributes();
        attrs.put((CharSequence)RetryState.class.getName(), (Object)retry);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            retryState.open();
            Object result = this.retrySync(context, retryState, interceptedMethod);
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    Flux reactiveSequence = Flux.from((Publisher)((Publisher)result));
                    return interceptedMethod.handleResult((Object)reactiveSequence.onErrorResume(this.retryFlowable(context, retryState, (Flux<Object>)reactiveSequence)).doOnNext(o -> retryState.close(null)));
                }
                case COMPLETION_STAGE: {
                    CompletableFuture<Object> newFuture = new CompletableFuture<Object>();
                    Supplier<CompletionStage<?>> retrySupplier = () -> interceptedMethod.interceptResultAsCompletionStage((Interceptor)this);
                    ((CompletionStage)result).whenComplete(this.retryCompletable(context, retryState, newFuture, retrySupplier));
                    return interceptedMethod.handleResult(newFuture);
                }
                case SYNCHRONOUS: {
                    retryState.close(null);
                    return result;
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private BiConsumer<Object, ? super Throwable> retryCompletable(MethodInvocationContext<Object, Object> context, MutableRetryState retryState, CompletableFuture<Object> newFuture, Supplier<CompletionStage<?>> retryResultSupplier) {
        return (value, exception) -> {
            if (exception == null) {
                retryState.close(null);
                newFuture.complete(value);
                return;
            }
            if (retryState.canRetry((Throwable)exception)) {
                long delay = retryState.nextDelay();
                if (this.eventPublisher != null) {
                    try {
                        this.eventPublisher.publishEvent((Object)new RetryEvent(context, retryState, (Throwable)exception));
                    }
                    catch (Exception e) {
                        LOG.error("Error occurred publishing RetryEvent: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                this.executorService.schedule(() -> this.lambda$retryCompletable$3(context, delay, exception, (Supplier)retryResultSupplier, retryState, newFuture), delay, TimeUnit.MILLISECONDS);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", (Object)context);
                }
                retryState.close((Throwable)exception);
                newFuture.completeExceptionally((Throwable)exception);
            }
        };
    }

    private <T> Function<? super Throwable, ? extends Publisher<? extends T>> retryFlowable(MethodInvocationContext<Object, Object> context, MutableRetryState retryState, Flux<Object> observable) {
        return exception -> {
            if (retryState.canRetry((Throwable)exception)) {
                Flux retryObservable = observable.onErrorResume(this.retryFlowable(context, retryState, observable));
                long delay = retryState.nextDelay();
                if (this.eventPublisher != null) {
                    try {
                        this.eventPublisher.publishEvent((Object)new RetryEvent(context, retryState, (Throwable)exception));
                    }
                    catch (Exception e1) {
                        LOG.error("Error occurred publishing RetryEvent: {}", (Object)e1.getMessage(), (Object)e1);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delay, exception.getMessage(), exception});
                }
                return retryObservable.delaySubscription(Duration.of(delay, ChronoUnit.MILLIS));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", (Object)context);
            }
            retryState.close((Throwable)exception);
            return Flux.error((Throwable)exception);
        };
    }

    private Object retrySync(MethodInvocationContext<Object, Object> context, MutableRetryState retryState, InterceptedMethod interceptedMethod) {
        boolean firstCall = true;
        while (true) {
            try {
                if (firstCall) {
                    firstCall = false;
                    return interceptedMethod.interceptResult();
                }
                return interceptedMethod.interceptResult((Interceptor)this);
            }
            catch (Throwable e) {
                if (!retryState.getCapturedException().isAssignableFrom(e.getClass())) {
                    throw e;
                }
                if (!retryState.canRetry(e)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", context);
                    }
                    retryState.close(e);
                    throw e;
                }
                long delayMillis = retryState.nextDelay();
                try {
                    if (this.eventPublisher != null) {
                        try {
                            this.eventPublisher.publishEvent((Object)new RetryEvent(context, retryState, e));
                        }
                        catch (Exception e1) {
                            LOG.error("Error occurred publishing RetryEvent: {}", (Object)e1.getMessage(), (Object)e1);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delayMillis, e.getMessage()});
                    }
                    this.sleep(delayMillis);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        }
    }

    protected void sleep(long delayMillis) throws InterruptedException {
        Thread.sleep(delayMillis);
    }

    private /* synthetic */ void lambda$retryCompletable$3(MethodInvocationContext context, long delay, Throwable exception, Supplier retryResultSupplier, MutableRetryState retryState, CompletableFuture newFuture) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delay, exception.getMessage(), exception});
        }
        ((CompletionStage)retryResultSupplier.get()).whenComplete(this.retryCompletable((MethodInvocationContext<Object, Object>)context, retryState, newFuture, retryResultSupplier));
    }
}

