/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;

@Singleton
public class AnnotatedFilterRouteBuilder
extends DefaultRouteBuilder {
    private final BeanContext beanContext;

    public AnnotatedFilterRouteBuilder(BeanContext beanContext, ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.beanContext = beanContext;
    }

    @PostConstruct
    public void process() {
        Collection filterDefinitions = this.beanContext.getBeanDefinitions(Qualifiers.byStereotype(Filter.class));
        for (BeanDefinition beanDefinition : filterDefinitions) {
            Object[] patterns;
            if (HttpClientFilter.class.isAssignableFrom(beanDefinition.getBeanType()) || !ArrayUtils.isNotEmpty((Object[])(patterns = (String[])beanDefinition.getValue(Filter.class, String[].class).orElse(null)))) continue;
            Object[] methods = beanDefinition.getValue(Filter.class, "methods", HttpMethod[].class).orElse(null);
            Object first = patterns[0];
            FilterRoute filterRoute = this.addFilter((String)first, () -> (HttpFilter)this.beanContext.getBean(beanDefinition.getBeanType()));
            if (patterns.length > 1) {
                for (int i = 1; i < patterns.length; ++i) {
                    Object pattern = patterns[i];
                    filterRoute.pattern((String)pattern);
                }
            }
            if (!ArrayUtils.isNotEmpty((Object[])methods)) continue;
            filterRoute.methods((HttpMethod[])methods);
        }
    }
}

