/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultRouter
implements Router {
    private final UriRoute[][] routesByMethod = new UriRoute[HttpMethod.values().length][];
    private final Set<StatusRoute> statusRoutes = new HashSet<StatusRoute>();
    private final Collection<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
    private final Set<ErrorRoute> errorRoutes = new HashSet<ErrorRoute>();

    @Inject
    public DefaultRouter(Collection<RouteBuilder> builders) {
        ArrayList<UriRoute> getRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> putRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> postRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> patchRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> deleteRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> optionsRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> headRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> connectRoutes = new ArrayList<UriRoute>();
        ArrayList<UriRoute> traceRoutes = new ArrayList<UriRoute>();
        for (RouteBuilder builder : builders) {
            List<UriRoute> constructedRoutes = builder.getUriRoutes();
            for (UriRoute route : constructedRoutes) {
                switch (route.getHttpMethod()) {
                    case GET: {
                        getRoutes.add(route);
                        break;
                    }
                    case PUT: {
                        putRoutes.add(route);
                        break;
                    }
                    case POST: {
                        postRoutes.add(route);
                        break;
                    }
                    case PATCH: {
                        patchRoutes.add(route);
                        break;
                    }
                    case DELETE: {
                        deleteRoutes.add(route);
                        break;
                    }
                    case OPTIONS: {
                        optionsRoutes.add(route);
                        break;
                    }
                    case HEAD: {
                        headRoutes.add(route);
                        break;
                    }
                    case CONNECT: {
                        connectRoutes.add(route);
                        break;
                    }
                    case TRACE: {
                        traceRoutes.add(route);
                        break;
                    }
                }
            }
            this.statusRoutes.addAll(builder.getStatusRoutes());
            this.errorRoutes.addAll(builder.getErrorRoutes());
            this.filterRoutes.addAll(builder.getFilterRoutes());
        }
        block24: for (HttpMethod method : HttpMethod.values()) {
            switch (method) {
                case GET: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(getRoutes);
                    continue block24;
                }
                case PUT: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(putRoutes);
                    continue block24;
                }
                case POST: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(postRoutes);
                    continue block24;
                }
                case PATCH: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(patchRoutes);
                    continue block24;
                }
                case DELETE: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(deleteRoutes);
                    continue block24;
                }
                case OPTIONS: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(optionsRoutes);
                    continue block24;
                }
                case HEAD: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(headRoutes);
                    continue block24;
                }
                case CONNECT: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(connectRoutes);
                    continue block24;
                }
                case TRACE: {
                    this.routesByMethod[method.ordinal()] = this.finalizeRoutes(traceRoutes);
                    continue block24;
                }
            }
        }
    }

    public DefaultRouter(RouteBuilder ... builders) {
        this(Arrays.asList(builders));
    }

    @Override
    public <T, R> Stream<UriRouteMatch<T, R>> find(HttpMethod httpMethod, CharSequence uri) {
        UriRoute[] routes = this.routesByMethod[httpMethod.ordinal()];
        return Arrays.stream(routes).map(route -> route.match(uri.toString())).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public Stream<UriRoute> uriRoutes() {
        return Arrays.stream(this.routesByMethod).flatMap(Arrays::stream);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> route(HttpMethod httpMethod, CharSequence uri) {
        UriRoute[] routes = this.routesByMethod[httpMethod.ordinal()];
        Optional<UriRouteMatch> result = Arrays.stream(routes).map(route -> route.match(uri.toString())).filter(Optional::isPresent).map(Optional::get).findFirst();
        UriRouteMatch match = result.orElse(null);
        return Optional.ofNullable(match);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match;
            if (statusRoute.originatingType() != null || !(match = statusRoute.match(status)).isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(Class originatingClass, HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match = statusRoute.match(originatingClass, status);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(Class originatingClass, Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(originatingClass, error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            if (errorRoute.originatingType() != null) continue;
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public List<HttpFilter> findFilters(HttpRequest<?> request) {
        ArrayList httpFilters = new ArrayList();
        HttpMethod method = request.getMethod();
        URI uri = request.getUri();
        for (FilterRoute filterRoute : this.filterRoutes) {
            Optional<HttpFilter> match = filterRoute.match(method, uri);
            match.ifPresent(httpFilters::add);
        }
        if (!httpFilters.isEmpty()) {
            OrderUtil.sort(httpFilters);
            return Collections.unmodifiableList(httpFilters);
        }
        return Collections.emptyList();
    }

    @Override
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(CharSequence uri) {
        return Arrays.stream(this.routesByMethod).filter(Objects::nonNull).flatMap(Arrays::stream).map(route -> route.match(uri.toString())).filter(Optional::isPresent).map(Optional::get);
    }

    private UriRoute[] finalizeRoutes(List<UriRoute> routes) {
        Collections.sort(routes);
        Collections.reverse(routes);
        return routes.toArray(new UriRoute[0]);
    }

    private <T> Optional<RouteMatch<T>> findRouteMatch(Map<ErrorRoute, RouteMatch<T>> matchedRoutes, Throwable error) {
        if (matchedRoutes.size() == 1) {
            return matchedRoutes.values().stream().findFirst();
        }
        if (matchedRoutes.size() > 1) {
            int minCount = Integer.MAX_VALUE;
            Supplier<List> hierarchySupplier = () -> ClassUtils.resolveHierarchy(error.getClass());
            Optional<RouteMatch<T>> match = Optional.empty();
            Class<?> errorClass = error.getClass();
            for (Map.Entry<ErrorRoute, RouteMatch<T>> entry : matchedRoutes.entrySet()) {
                Class<? extends Throwable> exceptionType = entry.getKey().exceptionType();
                if (exceptionType.equals(errorClass)) {
                    match = Optional.of(entry.getValue());
                    break;
                }
                List hierarchy = hierarchySupplier.get();
                int index = hierarchy.indexOf(exceptionType);
                if (index <= -1 || index >= minCount) continue;
                minCount = index;
                match = Optional.of(entry.getValue());
            }
            return match;
        }
        return Optional.empty();
    }
}

