/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.web.router.UnresolvedArgument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface RouteMatch<R>
extends Callable<R>,
Predicate<HttpRequest>,
AnnotationMetadataProvider {
    public Class<?> getDeclaringType();

    public Map<String, Object> getVariableValues();

    public R execute(Map<String, Object> var1);

    public RouteMatch<R> fulfill(Map<String, Object> var1);

    public RouteMatch<R> decorate(Function<RouteMatch<R>, R> var1);

    public Optional<Argument<?>> getRequiredInput(String var1);

    public Optional<Argument<?>> getBodyArgument();

    public List<MediaType> getProduces();

    default public Collection<Argument> getRequiredArguments() {
        return Collections.emptyList();
    }

    public ReturnType<? extends R> getReturnType();

    default public R execute() {
        return this.execute(Collections.emptyMap());
    }

    @Override
    default public R call() throws Exception {
        return this.execute();
    }

    default public boolean isExecutable() {
        return this.getRequiredArguments().size() == 0;
    }

    default public boolean isRequiredInput(String name) {
        return this.getRequiredInput(name).isPresent();
    }

    public boolean accept(@Nullable MediaType var1);

    default public boolean isSatisfied(String name) {
        Object val = this.getVariableValues().get(name);
        return val != null && !(val instanceof UnresolvedArgument);
    }
}

