/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface Router {
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@Nonnull CharSequence var1);

    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod var1, @Nonnull CharSequence var2);

    @Nonnull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@Nonnull HttpRequest<?> var1);

    @Nonnull
    public Stream<UriRoute> uriRoutes();

    public <T, R> Optional<UriRouteMatch<T, R>> route(@Nonnull HttpMethod var1, @Nonnull CharSequence var2);

    public <R> Optional<RouteMatch<R>> route(@Nonnull HttpStatus var1);

    public <R> Optional<RouteMatch<R>> route(@Nonnull Class var1, @Nonnull HttpStatus var2);

    public <R> Optional<RouteMatch<R>> route(@Nonnull Throwable var1);

    public <R> Optional<RouteMatch<R>> route(@Nonnull Class var1, @Nonnull Throwable var2);

    @Nonnull
    public List<HttpFilter> findFilters(@Nonnull HttpRequest<?> var1);

    default public <T, R> Optional<UriRouteMatch<T, R>> GET(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.GET, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> POST(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.POST, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PUT(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.PUT, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PATCH(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.PATCH, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> DELETE(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.DELETE, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> OPTIONS(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.OPTIONS, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> HEAD(@Nonnull CharSequence uri) {
        return this.route(HttpMethod.HEAD, uri);
    }

    @Nonnull
    default public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull URI uri) {
        return this.find(httpMethod, uri.toString());
    }

    @Nonnull
    default public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpRequest<?> request) {
        return this.find(request.getMethod(), request.getPath());
    }
}

