/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.sse.Event;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UnresolvedArgument;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

abstract class AbstractRouteMatch<T, R>
implements MethodBasedRouteMatch<T, R> {
    protected final MethodExecutionHandle<T, R> executableMethod;
    protected final ConversionService<?> conversionService;
    protected final Map<String, Argument> requiredInputs;
    protected final DefaultRouteBuilder.AbstractRoute abstractRoute;
    protected final List<MediaType> acceptedMediaTypes;

    protected AbstractRouteMatch(DefaultRouteBuilder.AbstractRoute abstractRoute, ConversionService<?> conversionService) {
        this.abstractRoute = abstractRoute;
        this.executableMethod = abstractRoute.targetMethod;
        this.conversionService = conversionService;
        Argument[] requiredArguments = this.executableMethod.getArguments();
        this.requiredInputs = new LinkedHashMap<String, Argument>(requiredArguments.length);
        for (Argument requiredArgument : requiredArguments) {
            String inputName = this.resolveInputName(requiredArgument);
            this.requiredInputs.put(inputName, requiredArgument);
        }
        this.acceptedMediaTypes = abstractRoute.getConsumes();
    }

    public T getTarget() {
        return (T)this.executableMethod.getTarget();
    }

    @Nonnull
    public ExecutableMethod<?, R> getExecutableMethod() {
        return this.executableMethod.getExecutableMethod();
    }

    @Override
    public List<MediaType> getProduces() {
        Optional firstTypeVariable = this.executableMethod.getReturnType().getFirstTypeVariable();
        if (firstTypeVariable.isPresent() && Event.class.isAssignableFrom(((Argument)firstTypeVariable.get()).getType())) {
            return Collections.singletonList(MediaType.TEXT_EVENT_STREAM_TYPE);
        }
        return this.abstractRoute.getProduces();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.executableMethod.getAnnotationMetadata();
    }

    @Override
    public Optional<Argument<?>> getBodyArgument() {
        Argument<?> arg = this.abstractRoute.bodyArgument;
        if (arg != null) {
            return Optional.of(arg);
        }
        String bodyArgument = this.abstractRoute.bodyArgumentName;
        if (bodyArgument != null) {
            return Optional.ofNullable(this.requiredInputs.get(bodyArgument));
        }
        for (Argument argument : this.getArguments()) {
            if (!argument.getAnnotationMetadata().hasAnnotation(Body.class)) continue;
            return Optional.of(argument);
        }
        return Optional.empty();
    }

    @Override
    public boolean isRequiredInput(String name) {
        return this.requiredInputs.containsKey(name);
    }

    @Override
    public Optional<Argument<?>> getRequiredInput(String name) {
        return Optional.ofNullable(this.requiredInputs.get(name));
    }

    @Override
    public boolean isExecutable() {
        Map<String, Object> variables = this.getVariableValues();
        for (Map.Entry<String, Argument> entry : this.requiredInputs.entrySet()) {
            Object value = variables.get(entry.getKey());
            if (value != null && !(value instanceof UnresolvedArgument)) continue;
            return false;
        }
        Optional<Argument<?>> bodyArgument = this.getBodyArgument();
        if (bodyArgument.isPresent()) {
            Object value = variables.get(bodyArgument.get().getName());
            return value != null && !(value instanceof UnresolvedArgument);
        }
        return true;
    }

    public Method getTargetMethod() {
        return this.executableMethod.getTargetMethod();
    }

    public String getMethodName() {
        return this.executableMethod.getMethodName();
    }

    @Override
    public Class getDeclaringType() {
        return this.executableMethod.getDeclaringType();
    }

    public Argument[] getArguments() {
        return this.executableMethod.getArguments();
    }

    @Override
    public boolean test(HttpRequest request) {
        for (Predicate<HttpRequest<?>> condition : this.abstractRoute.conditions) {
            if (condition.test(request)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReturnType<R> getReturnType() {
        return this.executableMethod.getReturnType();
    }

    public R invoke(Object ... arguments) {
        ConversionService<?> conversionService = this.conversionService;
        Argument[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            return (R)this.executableMethod.invoke(new Object[0]);
        }
        ArrayList argumentList = new ArrayList();
        Map<String, Object> variables = this.getVariableValues();
        Iterator<Object> valueIterator = variables.values().iterator();
        int i = 0;
        for (Argument targetArgument : targetArguments) {
            Optional result;
            String name = targetArgument.getName();
            Object value = variables.get(name);
            if (value != null) {
                result = conversionService.convert(value, targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            if (valueIterator.hasNext()) {
                result = conversionService.convert(valueIterator.next(), targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            if (i < arguments.length) {
                result = conversionService.convert(arguments[i++], targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            throw new IllegalArgumentException("Wrong number of arguments to method: " + this.executableMethod);
        }
        return (R)this.executableMethod.invoke(argumentList.toArray());
    }

    @Override
    public R execute(Map<String, Object> argumentValues) {
        Argument[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            return (R)this.executableMethod.invoke(new Object[0]);
        }
        ConversionService<?> conversionService = this.conversionService;
        Map<String, Object> uriVariables = this.getVariableValues();
        ArrayList<Object> argumentList = new ArrayList<Object>();
        for (Map.Entry<String, Argument> entry : this.requiredInputs.entrySet()) {
            Argument argument = entry.getValue();
            String name = entry.getKey();
            Object value = DefaultRouteBuilder.NO_VALUE;
            if (uriVariables.containsKey(name)) {
                value = uriVariables.get(name);
            } else if (argumentValues.containsKey(name)) {
                value = argumentValues.get(name);
            }
            if (value instanceof UnresolvedArgument) {
                ConversionError conversionError;
                UnresolvedArgument unresolved = (UnresolvedArgument)value;
                ArgumentBinder.BindingResult bindingResult = (ArgumentBinder.BindingResult)unresolved.get();
                if (bindingResult.isPresentAndSatisfied()) {
                    Object resolved = bindingResult.get();
                    if (resolved instanceof ConversionError) {
                        conversionError = (ConversionError)resolved;
                        throw new ConversionErrorException(argument, conversionError);
                    }
                    ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
                    Optional result = conversionService.convert(resolved, argument.getType(), (ConversionContext)conversionContext);
                    argumentList.add(this.resolveValueOrError(argument, (ConversionContext)conversionContext, result));
                    continue;
                }
                if (argument.isNullable()) {
                    argumentList.add(null);
                    continue;
                }
                List conversionErrors = bindingResult.getConversionErrors();
                if (!conversionErrors.isEmpty()) {
                    conversionError = (ConversionError)conversionErrors.iterator().next();
                    throw new ConversionErrorException(argument, conversionError);
                }
                throw new UnsatisfiedRouteException(argument);
            }
            if (value instanceof ConversionError) {
                throw new ConversionErrorException(argument, (ConversionError)value);
            }
            if (value == DefaultRouteBuilder.NO_VALUE) {
                throw new UnsatisfiedRouteException(argument);
            }
            ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
            Optional result = conversionService.convert(value, argument.getType(), (ConversionContext)conversionContext);
            argumentList.add(this.resolveValueOrError(argument, (ConversionContext)conversionContext, result));
        }
        return (R)this.executableMethod.invoke(argumentList.toArray());
    }

    @Override
    public boolean accept(MediaType contentType) {
        return this.acceptedMediaTypes.isEmpty() || contentType == null || this.acceptedMediaTypes.contains(MediaType.ALL_TYPE) || this.explicitAccept(contentType);
    }

    @Override
    public boolean explicitAccept(MediaType contentType) {
        return this.acceptedMediaTypes.contains(contentType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RouteMatch<R> fulfill(Map<String, Object> argumentValues) {
        Map<String, Object> oldVariables = this.getVariableValues();
        LinkedHashMap<String, Object> newVariables = new LinkedHashMap<String, Object>(oldVariables);
        for (Argument argument : this.getArguments()) {
            Object result;
            void var7_8;
            Argument<?> a;
            Object value = argumentValues.get(argument.getName());
            Optional<Argument<?>> ba = this.getBodyArgument();
            if (ba.isPresent() && (a = ba.get()).getName().equals(argument.getName())) {
                Argument<?> argument2 = a;
            }
            if (value == null) continue;
            String name = this.resolveInputName((Argument)var7_8);
            if (value instanceof UnresolvedArgument) {
                newVariables.put(name, value);
                continue;
            }
            ArgumentConversionContext conversionContext = ConversionContext.of((Argument)var7_8);
            Optional converted = this.conversionService.convert(value, conversionContext);
            Object object = result = converted.isPresent() ? converted.get() : conversionContext.getLastError().orElse(null);
            if (result == null) continue;
            newVariables.put(name, result);
        }
        Set<String> argumentNames = argumentValues.keySet();
        List<Argument> requiredArguments = this.getRequiredArguments().stream().filter(arg -> !argumentNames.contains(arg.getName())).collect(Collectors.toList());
        return this.newFulfilled(newVariables, requiredArguments);
    }

    protected Object resolveValueOrError(Argument argument, ConversionContext conversionContext, Optional<?> result) {
        if (!result.isPresent()) {
            Optional lastError = conversionContext.getLastError();
            if (!lastError.isPresent() && argument.isDeclaredNullable()) {
                return null;
            }
            throw lastError.map(conversionError -> new ConversionErrorException(argument, conversionError)).orElseGet(() -> new UnsatisfiedRouteException(argument));
        }
        return result.get();
    }

    protected abstract RouteMatch<R> newFulfilled(Map<String, Object> var1, List<Argument> var2);

    private String resolveInputName(Argument requiredArgument) {
        String inputName = requiredArgument.getAnnotationMetadata().stringValue(Bindable.class).orElse(null);
        if (StringUtils.isEmpty((CharSequence)inputName)) {
            inputName = requiredArgument.getName();
        }
        return inputName;
    }
}

