/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.TypeConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.web.router.DefaultFilterRoute;
import io.micronaut.web.router.DefaultUriRouteMatch;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.ErrorRouteMatch;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.MethodBasedRoute;
import io.micronaut.web.router.ResourceRoute;
import io.micronaut.web.router.Route;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.StatusRouteMatch;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.RoutingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultRouteBuilder
implements RouteBuilder {
    public static final RouteBuilder.UriNamingStrategy CAMEL_CASE_NAMING_STRATEGY = new RouteBuilder.UriNamingStrategy(){};
    @Deprecated
    public static final RouteBuilder.UriNamingStrategy HYPHENATED_NAMING_STRATEGY = new RouteBuilder.UriNamingStrategy(){

        @Nonnull
        public String resolveUri(Class type) {
            return '/' + TypeConvention.CONTROLLER.asHyphenatedName(type);
        }

        @Override
        @Nonnull
        public String resolveUri(String property) {
            if (StringUtils.isEmpty((CharSequence)property)) {
                return "/";
            }
            if (property.charAt(0) != '/') {
                return '/' + NameUtils.hyphenate((String)property, (boolean)true);
            }
            return property;
        }
    };
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultRouteBuilder.class);
    static final Object NO_VALUE = new Object();
    protected final ExecutionHandleLocator executionHandleLocator;
    protected final RouteBuilder.UriNamingStrategy uriNamingStrategy;
    protected final ConversionService<?> conversionService;
    protected final Charset defaultCharset;
    private DefaultUriRoute currentParentRoute = null;
    private List<UriRoute> uriRoutes = new ArrayList<UriRoute>();
    private List<StatusRoute> statusRoutes = new ArrayList<StatusRoute>();
    private List<ErrorRoute> errorRoutes = new ArrayList<ErrorRoute>();
    private List<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator) {
        this(executionHandleLocator, CAMEL_CASE_NAMING_STRATEGY);
    }

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy) {
        this(executionHandleLocator, uriNamingStrategy, ConversionService.SHARED);
    }

    public DefaultRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService) {
        this.executionHandleLocator = executionHandleLocator;
        this.uriNamingStrategy = uriNamingStrategy;
        this.conversionService = conversionService;
        if (executionHandleLocator instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)executionHandleLocator;
            Environment environment = applicationContext.getEnvironment();
            this.defaultCharset = (Charset)environment.get((CharSequence)"micronaut.application.default-charset", Charset.class, (Object)StandardCharsets.UTF_8);
        } else {
            this.defaultCharset = StandardCharsets.UTF_8;
        }
    }

    @Override
    public List<FilterRoute> getFilterRoutes() {
        return this.filterRoutes;
    }

    @Override
    public FilterRoute addFilter(String pathPattern, Supplier<HttpFilter> filter) {
        DefaultFilterRoute route = new DefaultFilterRoute(pathPattern, filter);
        this.filterRoutes.add(route);
        return route;
    }

    @Override
    public List<StatusRoute> getStatusRoutes() {
        return Collections.unmodifiableList(this.statusRoutes);
    }

    @Override
    public List<ErrorRoute> getErrorRoutes() {
        return Collections.unmodifiableList(this.errorRoutes);
    }

    @Override
    public List<UriRoute> getUriRoutes() {
        return Collections.unmodifiableList(this.uriRoutes);
    }

    @Override
    public RouteBuilder.UriNamingStrategy getUriNamingStrategy() {
        return this.uriNamingStrategy;
    }

    @Override
    public ResourceRoute resources(Class cls) {
        return new DefaultResourceRoute(cls);
    }

    @Override
    public ResourceRoute single(Class cls) {
        return new DefaultSingleRoute(cls);
    }

    @Override
    public StatusRoute status(Class originatingClass, HttpStatus status, Class type, String method, Class[] parameterTypes) {
        if (this.statusRoutes.stream().anyMatch(route -> route.status() == status && route.originatingType() == originatingClass)) {
            throw new RoutingException("Attempted to register multiple local routes for http status " + String.valueOf(status.getCode()));
        }
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle executableHandle = (MethodExecutionHandle)executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultStatusRoute statusRoute = new DefaultStatusRoute(originatingClass, status, executableHandle, this.conversionService);
        this.statusRoutes.add(statusRoute);
        return statusRoute;
    }

    @Override
    public StatusRoute status(HttpStatus status, Class type, String method, Class[] parameterTypes) {
        if (this.statusRoutes.stream().anyMatch(route -> route.status() == status && route.originatingType() == null)) {
            throw new RoutingException("Attempted to register multiple global routes for http status " + String.valueOf(status.getCode()));
        }
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle executableHandle = (MethodExecutionHandle)executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultStatusRoute statusRoute = new DefaultStatusRoute(status, executableHandle, this.conversionService);
        this.statusRoutes.add(statusRoute);
        return statusRoute;
    }

    @Override
    public ErrorRoute error(Class originatingClass, Class<? extends Throwable> error, Class type, String method, Class[] parameterTypes) {
        if (this.errorRoutes.stream().anyMatch(route -> route.exceptionType() == error && route.originatingType() == originatingClass)) {
            throw new RoutingException("Attempted to register multiple local error routes for exception " + error.getName());
        }
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle executableHandle = (MethodExecutionHandle)executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultErrorRoute errorRoute = new DefaultErrorRoute(originatingClass, error, executableHandle, this.conversionService);
        this.errorRoutes.add(errorRoute);
        return errorRoute;
    }

    @Override
    public ErrorRoute error(Class<? extends Throwable> error, Class type, String method, Class[] parameterTypes) {
        if (this.errorRoutes.stream().anyMatch(route -> route.exceptionType() == error && route.originatingType() == null)) {
            throw new RoutingException("Attempted to register multiple global error routes for exception " + error.getName());
        }
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle executableHandle = (MethodExecutionHandle)executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        DefaultErrorRoute errorRoute = new DefaultErrorRoute(error, executableHandle, this.conversionService);
        this.errorRoutes.add(errorRoute);
        return errorRoute;
    }

    @Override
    public UriRoute GET(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.GET, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute GET(String uri, Class<?> type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.GET, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute POST(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.POST, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute POST(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.POST, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute PUT(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.PUT, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute PUT(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.PUT, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute PATCH(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.PATCH, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute PATCH(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.PATCH, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute DELETE(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.DELETE, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute DELETE(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.DELETE, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute OPTIONS(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.OPTIONS, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute OPTIONS(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.OPTIONS, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute HEAD(String uri, Object target, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.HEAD, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute HEAD(String uri, Class type, String method, Class ... parameterTypes) {
        return this.buildRoute(HttpMethod.HEAD, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute TRACE(String uri, Object target, String method, Class[] parameterTypes) {
        return this.buildRoute(HttpMethod.TRACE, uri, target.getClass(), method, parameterTypes);
    }

    @Override
    public UriRoute TRACE(String uri, Class type, String method, Class[] parameterTypes) {
        return this.buildRoute(HttpMethod.TRACE, uri, type, method, parameterTypes);
    }

    @Override
    public UriRoute GET(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.GET, uri, beanDefinition, method);
    }

    @Override
    public UriRoute POST(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.POST, uri, beanDefinition, method);
    }

    @Override
    public UriRoute PUT(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.PUT, uri, beanDefinition, method);
    }

    @Override
    public UriRoute PATCH(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.PATCH, uri, beanDefinition, method);
    }

    @Override
    public UriRoute DELETE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.DELETE, uri, beanDefinition, method);
    }

    @Override
    public UriRoute OPTIONS(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.OPTIONS, uri, beanDefinition, method);
    }

    @Override
    public UriRoute HEAD(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.HEAD, uri, beanDefinition, method);
    }

    @Override
    public UriRoute TRACE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.buildBeanRoute(HttpMethod.TRACE, uri, beanDefinition, method);
    }

    protected UriRoute buildRoute(HttpMethod httpMethod, String uri, Class<?> type, String method, Class ... parameterTypes) {
        Optional executionHandle = this.executionHandleLocator.findExecutionHandle(type, method, parameterTypes);
        MethodExecutionHandle executableHandle = (MethodExecutionHandle)executionHandle.orElseThrow(() -> new RoutingException("No such route: " + type.getName() + "." + method));
        return this.buildRoute(httpMethod, uri, executableHandle);
    }

    protected UriRoute buildRoute(HttpMethod httpMethod, String uri, MethodExecutionHandle<?, Object> executableHandle) {
        DefaultUriRoute route;
        if (this.currentParentRoute != null) {
            route = new DefaultUriRoute(httpMethod, this.currentParentRoute.uriMatchTemplate.nest((CharSequence)uri), executableHandle);
            this.currentParentRoute.nestedRoutes.add(route);
        } else {
            route = new DefaultUriRoute(httpMethod, uri, executableHandle);
        }
        this.uriRoutes.add(route);
        return route;
    }

    private UriRoute buildBeanRoute(HttpMethod httpMethod, String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Qualifier qualifier = beanDefinition.getAnnotationTypeByStereotype(javax.inject.Qualifier.class).map(aClass -> Qualifiers.byAnnotation((AnnotationMetadata)beanDefinition, (Class)aClass)).orElse(null);
        if (qualifier == null && beanDefinition.isIterable() && beanDefinition instanceof NameResolver) {
            qualifier = ((NameResolver)beanDefinition).resolveName().map(Qualifiers::byName).orElse(null);
        }
        MethodExecutionHandle executionHandle = (MethodExecutionHandle)this.executionHandleLocator.findExecutionHandle(beanDefinition.getBeanType(), qualifier, method.getMethodName(), method.getArgumentTypes()).orElseThrow(() -> new RoutingException("No such route: " + beanDefinition.getBeanType().getName() + "." + method));
        return this.buildRoute(httpMethod, uri, executionHandle);
    }

    class DefaultResourceRoute
    implements ResourceRoute {
        private final Map<HttpMethod, Route> resourceRoutes;
        private final DefaultUriRoute getRoute;

        DefaultResourceRoute(Map<HttpMethod, Route> resourceRoutes, DefaultUriRoute getRoute) {
            this.resourceRoutes = resourceRoutes;
            this.getRoute = getRoute;
        }

        DefaultResourceRoute(Class type) {
            Map<HttpMethod, Route> routeMap = this.resourceRoutes = new LinkedHashMap<HttpMethod, Route>();
            this.getRoute = this.buildGetRoute(type, routeMap);
            this.buildRemainingRoutes(type, routeMap);
        }

        @Override
        public ResourceRoute consumes(MediaType ... mediaTypes) {
            if (mediaTypes != null) {
                for (Route route : this.resourceRoutes.values()) {
                    route.produces(mediaTypes);
                }
            }
            return this;
        }

        @Override
        public Route acceptAll() {
            return this.consumes(MediaType.EMPTY_ARRAY);
        }

        @Override
        public ResourceRoute nest(Runnable nested) {
            DefaultUriRoute previous = DefaultRouteBuilder.this.currentParentRoute;
            DefaultRouteBuilder.this.currentParentRoute = this.getRoute;
            try {
                nested.run();
            }
            finally {
                DefaultRouteBuilder.this.currentParentRoute = previous;
            }
            return this;
        }

        @Override
        public ResourceRoute where(Predicate<HttpRequest<?>> condition) {
            for (Route route : this.resourceRoutes.values()) {
                route.where(condition);
            }
            return this;
        }

        @Override
        public ResourceRoute produces(MediaType ... mediaType) {
            if (mediaType != null) {
                for (Route route : this.resourceRoutes.values()) {
                    route.produces(mediaType);
                }
            }
            return this;
        }

        @Override
        public ResourceRoute body(String argument) {
            return this;
        }

        @Override
        public Route body(Argument<?> argument) {
            return this;
        }

        @Override
        public ResourceRoute readOnly(boolean readOnly) {
            List<HttpMethod> excluded = Arrays.asList(HttpMethod.DELETE, HttpMethod.PATCH, HttpMethod.POST, HttpMethod.PUT);
            return this.handleExclude(excluded);
        }

        @Override
        public ResourceRoute exclude(HttpMethod ... methods) {
            return this.handleExclude(Arrays.asList(methods));
        }

        protected ResourceRoute newResourceRoute(Map<HttpMethod, Route> newMap, DefaultUriRoute getRoute) {
            return new DefaultResourceRoute(newMap, getRoute);
        }

        protected DefaultUriRoute buildGetRoute(Class type, Map<HttpMethod, Route> routeMap) {
            DefaultUriRoute getRoute = (DefaultUriRoute)DefaultRouteBuilder.this.GET(type, RouteBuilder.ID);
            routeMap.put(HttpMethod.GET, getRoute);
            return getRoute;
        }

        protected void buildRemainingRoutes(Class type, Map<HttpMethod, Route> routeMap) {
            routeMap.put(HttpMethod.GET, DefaultRouteBuilder.this.GET(type));
            routeMap.put(HttpMethod.POST, DefaultRouteBuilder.this.POST(type));
            routeMap.put(HttpMethod.DELETE, DefaultRouteBuilder.this.DELETE(type, RouteBuilder.ID));
            routeMap.put(HttpMethod.PATCH, DefaultRouteBuilder.this.PATCH(type, RouteBuilder.ID));
            routeMap.put(HttpMethod.PUT, DefaultRouteBuilder.this.PUT(type, RouteBuilder.ID));
        }

        private ResourceRoute handleExclude(List<HttpMethod> excluded) {
            LinkedHashMap<HttpMethod, Route> newMap = new LinkedHashMap<HttpMethod, Route>();
            this.resourceRoutes.forEach((key, value) -> {
                if (excluded.contains(key)) {
                    DefaultRouteBuilder.this.uriRoutes.remove(value);
                } else {
                    newMap.put((HttpMethod)key, (Route)value);
                }
            });
            return this.newResourceRoute(newMap, this.getRoute);
        }
    }

    class DefaultSingleRoute
    extends DefaultResourceRoute {
        DefaultSingleRoute(Map<HttpMethod, Route> resourceRoutes, DefaultUriRoute getRoute) {
            super(resourceRoutes, getRoute);
        }

        DefaultSingleRoute(Class type) {
            super(type);
        }

        @Override
        protected ResourceRoute newResourceRoute(Map<HttpMethod, Route> newMap, DefaultUriRoute getRoute) {
            return new DefaultSingleRoute(newMap, getRoute);
        }

        @Override
        protected DefaultUriRoute buildGetRoute(Class type, Map<HttpMethod, Route> routeMap) {
            DefaultUriRoute getRoute = (DefaultUriRoute)DefaultRouteBuilder.this.GET(type);
            routeMap.put(HttpMethod.GET, getRoute);
            return getRoute;
        }

        @Override
        protected void buildRemainingRoutes(Class type, Map<HttpMethod, Route> routeMap) {
            routeMap.put(HttpMethod.POST, DefaultRouteBuilder.this.POST(type));
            routeMap.put(HttpMethod.DELETE, DefaultRouteBuilder.this.DELETE(type));
            routeMap.put(HttpMethod.PATCH, DefaultRouteBuilder.this.PATCH(type));
            routeMap.put(HttpMethod.PUT, DefaultRouteBuilder.this.PUT(type));
        }
    }

    class DefaultUriRoute
    extends AbstractRoute
    implements UriRoute {
        final HttpMethod httpMethod;
        final UriMatchTemplate uriMatchTemplate;
        final List<DefaultUriRoute> nestedRoutes;

        DefaultUriRoute(HttpMethod httpMethod, CharSequence uriTemplate, MethodExecutionHandle targetMethod) {
            this(httpMethod, uriTemplate, MediaType.APPLICATION_JSON_TYPE, targetMethod);
        }

        DefaultUriRoute(HttpMethod httpMethod, CharSequence uriTemplate, MediaType mediaType, MethodExecutionHandle targetMethod) {
            this(httpMethod, new UriMatchTemplate(uriTemplate), Collections.singletonList(mediaType), targetMethod);
        }

        DefaultUriRoute(HttpMethod httpMethod, UriMatchTemplate uriTemplate, MethodExecutionHandle targetMethod) {
            this(httpMethod, uriTemplate, Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), targetMethod);
        }

        DefaultUriRoute(HttpMethod httpMethod, UriMatchTemplate uriTemplate, List<MediaType> mediaTypes, MethodExecutionHandle targetMethod) {
            super(targetMethod, ConversionService.SHARED, mediaTypes);
            this.nestedRoutes = new ArrayList<DefaultUriRoute>(2);
            this.httpMethod = httpMethod;
            this.uriMatchTemplate = uriTemplate;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder((CharSequence)this.httpMethod);
            return builder.append(' ').append(this.uriMatchTemplate).append(" -> ").append(this.targetMethod.getDeclaringType().getSimpleName()).append('#').append(this.targetMethod).append(" (").append(String.join((CharSequence)",", this.acceptedMediaTypes)).append(" )").toString();
        }

        @Override
        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public UriRoute body(String argument) {
            return (UriRoute)super.body(argument);
        }

        @Override
        public UriRoute consumes(MediaType ... mediaTypes) {
            return (UriRoute)super.consumes(mediaTypes);
        }

        @Override
        public UriRoute produces(MediaType ... mediaType) {
            return (UriRoute)super.produces(mediaType);
        }

        @Override
        public UriRoute acceptAll() {
            return (UriRoute)super.acceptAll();
        }

        @Override
        public UriRoute nest(Runnable nested) {
            DefaultUriRoute previous = DefaultRouteBuilder.this.currentParentRoute;
            DefaultRouteBuilder.this.currentParentRoute = this;
            try {
                nested.run();
            }
            finally {
                DefaultRouteBuilder.this.currentParentRoute = previous;
            }
            return this;
        }

        @Override
        public UriRoute where(Predicate<HttpRequest<?>> condition) {
            return (UriRoute)super.where(condition);
        }

        @Override
        public Optional<UriRouteMatch> match(String uri) {
            Optional matchInfo = this.uriMatchTemplate.match(uri);
            return matchInfo.map(info -> new DefaultUriRouteMatch((UriMatchInfo)info, this, DefaultRouteBuilder.this.defaultCharset, (ConversionService<?>)this.conversionService));
        }

        @Override
        public UriMatchTemplate getUriMatchTemplate() {
            return this.uriMatchTemplate;
        }

        @Override
        public int compareTo(UriRoute o) {
            return this.uriMatchTemplate.compareTo((UriTemplate)o.getUriMatchTemplate());
        }

        @Override
        protected boolean permitsRequestBody() {
            return HttpMethod.permitsRequestBody((HttpMethod)this.httpMethod);
        }
    }

    class DefaultStatusRoute
    extends AbstractRoute
    implements StatusRoute {
        private final HttpStatus status;
        private final Class originatingClass;

        public DefaultStatusRoute(HttpStatus status, MethodExecutionHandle targetMethod, ConversionService<?> conversionService) {
            this(null, status, targetMethod, conversionService);
        }

        public DefaultStatusRoute(Class originatingClass, HttpStatus status, MethodExecutionHandle targetMethod, ConversionService<?> conversionService) {
            super(targetMethod, conversionService, Collections.emptyList());
            this.originatingClass = originatingClass;
            this.status = status;
        }

        @Override
        @Nullable
        public Class<?> originatingType() {
            return this.originatingClass;
        }

        @Override
        public HttpStatus status() {
            return this.status;
        }

        @Override
        public <T> Optional<RouteMatch<T>> match(Class originatingClass, HttpStatus status) {
            if (originatingClass == this.originatingClass && this.status == status) {
                return Optional.of(new StatusRouteMatch(status, this, this.conversionService));
            }
            return Optional.empty();
        }

        @Override
        public <T> Optional<RouteMatch<T>> match(HttpStatus status) {
            if (this.originatingClass == null && this.status == status) {
                return Optional.of(new StatusRouteMatch(status, this, this.conversionService));
            }
            return Optional.empty();
        }

        @Override
        public StatusRoute consumes(MediaType ... mediaType) {
            return this;
        }

        @Override
        public Route acceptAll() {
            return this;
        }

        @Override
        public StatusRoute nest(Runnable nested) {
            return this;
        }

        @Override
        public StatusRoute where(Predicate<HttpRequest<?>> condition) {
            return (StatusRoute)super.where(condition);
        }

        public HttpStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultStatusRoute that = (DefaultStatusRoute)o;
            if (this.status != null ? !this.status.equals((Object)that.status) : that.status != null) {
                return false;
            }
            return this.originatingClass != null ? this.originatingClass.equals(that.originatingClass) : that.originatingClass == null;
        }

        public int hashCode() {
            int result = this.status != null ? this.status.hashCode() : 0;
            result = 31 * result + (this.originatingClass != null ? this.originatingClass.hashCode() : 0);
            return result;
        }
    }

    class DefaultErrorRoute
    extends AbstractRoute
    implements ErrorRoute {
        private final Class<? extends Throwable> error;
        private final Class originatingClass;

        public DefaultErrorRoute(Class<? extends Throwable> error, MethodExecutionHandle targetMethod, ConversionService<?> conversionService) {
            this(null, error, targetMethod, conversionService);
        }

        public DefaultErrorRoute(Class originatingClass, Class<? extends Throwable> error, MethodExecutionHandle targetMethod, ConversionService<?> conversionService) {
            super(targetMethod, conversionService, Collections.emptyList());
            this.originatingClass = originatingClass;
            this.error = error;
        }

        @Override
        @Nullable
        public Class<?> originatingType() {
            return this.originatingClass;
        }

        @Override
        public Class<? extends Throwable> exceptionType() {
            return this.error;
        }

        @Override
        public <T> Optional<RouteMatch<T>> match(Class originatingClass, Throwable exception) {
            if (originatingClass == this.originatingClass && this.error.isInstance(exception)) {
                return Optional.of(new ErrorRouteMatch(exception, (AbstractRoute)this, this.conversionService));
            }
            return Optional.empty();
        }

        @Override
        public <T> Optional<RouteMatch<T>> match(Throwable exception) {
            if (this.originatingClass == null && this.error.isInstance(exception)) {
                return Optional.of(new ErrorRouteMatch(exception, (AbstractRoute)this, this.conversionService));
            }
            return Optional.empty();
        }

        @Override
        public ErrorRoute consumes(MediaType ... mediaType) {
            return this;
        }

        @Override
        public Route acceptAll() {
            return this;
        }

        @Override
        public ErrorRoute nest(Runnable nested) {
            return this;
        }

        @Override
        public ErrorRoute where(Predicate<HttpRequest<?>> condition) {
            return (ErrorRoute)super.where(condition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultErrorRoute that = (DefaultErrorRoute)o;
            if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
                return false;
            }
            return this.originatingClass != null ? this.originatingClass.equals(that.originatingClass) : that.originatingClass == null;
        }

        public int hashCode() {
            int result = this.error != null ? this.error.hashCode() : 0;
            result = 31 * result + (this.originatingClass != null ? this.originatingClass.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            return builder.append(' ').append(this.error.getName()).append(" -> ").append(this.targetMethod.getDeclaringType().getSimpleName()).append('#').append(this.targetMethod).toString();
        }
    }

    abstract class AbstractRoute
    implements MethodBasedRoute {
        protected final List<Predicate<HttpRequest<?>>> conditions = new ArrayList();
        protected final MethodExecutionHandle targetMethod;
        protected final ConversionService<?> conversionService;
        protected List<MediaType> acceptedMediaTypes;
        protected List<MediaType> producesMediaTypes;
        protected String bodyArgumentName;
        protected Argument<?> bodyArgument;

        AbstractRoute(MethodExecutionHandle targetMethod, ConversionService<?> conversionService, List<MediaType> mediaTypes) {
            this.targetMethod = targetMethod;
            this.conversionService = conversionService;
            this.acceptedMediaTypes = mediaTypes;
            Object[] types = MediaType.of((CharSequence[])targetMethod.stringValues(Produces.class));
            if (ArrayUtils.isNotEmpty((Object[])types)) {
                this.producesMediaTypes = Arrays.asList(types);
            }
        }

        @Override
        public Route consumes(MediaType ... mediaTypes) {
            if (mediaTypes != null) {
                this.acceptedMediaTypes = Collections.unmodifiableList(Arrays.asList(mediaTypes));
            }
            return this;
        }

        @Override
        public List<MediaType> getConsumes() {
            return this.acceptedMediaTypes;
        }

        @Override
        public Route acceptAll() {
            this.acceptedMediaTypes = Collections.emptyList();
            return this;
        }

        @Override
        public Route where(Predicate<HttpRequest<?>> condition) {
            if (condition != null) {
                this.conditions.add(condition);
            }
            return this;
        }

        @Override
        public Route body(String argument) {
            this.bodyArgumentName = argument;
            return this;
        }

        @Override
        public Route body(Argument<?> argument) {
            this.bodyArgument = argument;
            return this;
        }

        @Override
        public Route produces(MediaType ... mediaType) {
            if (mediaType != null) {
                this.producesMediaTypes = Arrays.asList(mediaType);
            }
            return this;
        }

        @Override
        public List<MediaType> getProduces() {
            if (this.producesMediaTypes != null) {
                return Collections.unmodifiableList(this.producesMediaTypes);
            }
            return DEFAULT_PRODUCES;
        }

        @Override
        public MethodExecutionHandle getTargetMethod() {
            return this.targetMethod;
        }

        protected boolean permitsRequestBody() {
            return true;
        }
    }
}

