/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.exceptions;

import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.web.router.exceptions.RoutingException;
import java.util.Optional;

public class UnsatisfiedRouteException
extends RoutingException {
    private final Argument<?> argument;

    public UnsatisfiedRouteException(Argument<?> argument) {
        super(UnsatisfiedRouteException.buildMessage(argument));
        this.argument = argument;
    }

    public Argument<?> getArgument() {
        return this.argument;
    }

    private static String buildMessage(Argument<?> argument) {
        Optional classOptional = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (classOptional.isPresent()) {
            Class clazz = (Class)classOptional.get();
            Optional valOptional = argument.getAnnotationMetadata().getValue(clazz);
            if (valOptional.isPresent()) {
                return "Required " + clazz.getSimpleName() + " [" + valOptional.get().toString() + "] not specified";
            }
            return "Required " + clazz.getSimpleName() + " [" + argument + "] not specified";
        }
        return "Required argument [" + argument + "] not specified";
    }
}

