/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultRouter
implements Router {
    private final Map<String, List<UriRoute>> routesByMethod = new HashMap<String, List<UriRoute>>();
    private final Set<StatusRoute> statusRoutes = new HashSet<StatusRoute>();
    private final Collection<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
    private final Set<ErrorRoute> errorRoutes = new HashSet<ErrorRoute>();
    private final Set<Integer> exposedPorts;
    private List<Integer> defaultPorts;

    @Inject
    public DefaultRouter(Collection<RouteBuilder> builders) {
        HashSet<Integer> exposedPorts = new HashSet<Integer>(5);
        for (RouteBuilder builder : builders) {
            List<UriRoute> constructedRoutes = builder.getUriRoutes();
            for (UriRoute route : constructedRoutes) {
                String key = route.getHttpMethodName();
                this.routesByMethod.computeIfAbsent(key, x -> new ArrayList()).add(route);
            }
            this.statusRoutes.addAll(builder.getStatusRoutes());
            this.errorRoutes.addAll(builder.getErrorRoutes());
            this.filterRoutes.addAll(builder.getFilterRoutes());
            exposedPorts.addAll(builder.getExposedPorts());
        }
        this.exposedPorts = CollectionUtils.isNotEmpty(exposedPorts) ? exposedPorts : Collections.emptySet();
        this.routesByMethod.values().forEach(this::finalizeRoutes);
    }

    public DefaultRouter(RouteBuilder ... builders) {
        this(Arrays.asList(builders));
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void applyDefaultPorts(List<Integer> ports) {
        Predicate<HttpRequest> portMatches = httpRequest -> ports.contains(httpRequest.getServerAddress().getPort());
        this.routesByMethod.values().forEach(routes -> {
            for (int i = 0; i < routes.size(); ++i) {
                UriRoute route = (UriRoute)routes.get(i);
                if (route.getPort() != null) continue;
                routes.set(i, route.where(portMatches));
            }
        });
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri) {
        return this.find(httpMethod.name(), uri).stream();
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpRequest request, @Nonnull CharSequence uri) {
        return this.find(request.getMethodName(), uri).stream();
    }

    @Override
    @Nonnull
    @Deprecated
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull URI uri) {
        return this.find(httpMethod.name(), (CharSequence)uri.toString()).stream();
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpRequest<?> request) {
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        return this.find(request, (CharSequence)request.getPath()).filter(match -> match.test(request) && (!permitsBody || match.accept(request.getContentType().orElse(null))));
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri, @Nullable HttpRequest<?> context) {
        return this.find(httpMethod, uri);
    }

    @Override
    public Stream<UriRoute> uriRoutes() {
        return this.routesByMethod.values().stream().flatMap(Collection::stream);
    }

    @Override
    @Nonnull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@Nonnull HttpRequest<?> request) {
        HttpMethod httpMethod = request.getMethod();
        MediaType contentType = request.getContentType().orElse(null);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        List<UriRouteMatch<T, R>> uriRoutes = this.find(request.getMethodName(), (CharSequence)request.getPath());
        uriRoutes.removeIf(routeMatch -> !routeMatch.test(request) || permitsBody && !routeMatch.accept(contentType));
        int routeCount = uriRoutes.size();
        if (routeCount > 1 && permitsBody) {
            ArrayList<UriRouteMatch<T, R>> explicitAcceptRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            ArrayList<UriRouteMatch<T, R>> acceptRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (UriRouteMatch<T, R> match : uriRoutes) {
                if (match.explicitAccept(contentType != null ? contentType : MediaType.ALL_TYPE)) {
                    explicitAcceptRoutes.add(match);
                }
                if (!explicitAcceptRoutes.isEmpty() || !match.accept(contentType)) continue;
                acceptRoutes.add(match);
            }
            List<UriRouteMatch<T, R>> list = uriRoutes = explicitAcceptRoutes.isEmpty() ? acceptRoutes : explicitAcceptRoutes;
        }
        if ((routeCount = uriRoutes.size()) > 1) {
            long variableCount = 0L;
            long rawLength = 0L;
            ArrayList<UriRouteMatch<T, R>> closestMatches = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (int i = 0; i < routeCount; ++i) {
                UriRouteMatch<T, R> match = uriRoutes.get(i);
                UriMatchTemplate template = match.getRoute().getUriMatchTemplate();
                long variable = template.getPathVariableSegmentCount();
                long raw = template.getRawSegmentLength();
                if (i == 0) {
                    variableCount = variable;
                    rawLength = raw;
                }
                if (variable > variableCount || raw < rawLength) break;
                closestMatches.add(match);
            }
            uriRoutes = closestMatches;
        }
        return uriRoutes;
    }

    @Override
    @Nonnull
    public <T, R> Optional<UriRouteMatch<T, R>> route(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri) {
        List routes = this.routesByMethod.getOrDefault(httpMethod.name(), Collections.emptyList());
        Optional<UriRouteMatch> result = routes.stream().map(route -> route.match(uri.toString())).filter(Optional::isPresent).map(Optional::get).findFirst();
        UriRouteMatch match = result.orElse(null);
        return Optional.ofNullable(match);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match;
            if (statusRoute.originatingType() != null || !(match = statusRoute.match(status)).isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Class originatingClass, @Nonnull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match = statusRoute.match(originatingClass, status);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Class originatingClass, @Nonnull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(originatingClass, error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            if (errorRoute.originatingType() != null) continue;
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    @Nonnull
    public List<HttpFilter> findFilters(@Nonnull HttpRequest<?> request) {
        ArrayList httpFilters = new ArrayList(this.filterRoutes.size());
        HttpMethod method = request.getMethod();
        URI uri = request.getUri();
        for (FilterRoute filterRoute : this.filterRoutes) {
            Optional<HttpFilter> match = filterRoute.match(method, uri);
            match.ifPresent(httpFilters::add);
        }
        if (!httpFilters.isEmpty()) {
            OrderUtil.sort(httpFilters);
            return Collections.unmodifiableList(httpFilters);
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@Nonnull CharSequence uri) {
        return this.findAny(uri, null);
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@Nonnull CharSequence uri, @Nullable HttpRequest<?> context) {
        ArrayList<UriRouteMatch> matchedRoutes = new ArrayList<UriRouteMatch>(5);
        String uriStr = uri.toString();
        for (List<UriRoute> routes : this.routesByMethod.values()) {
            for (UriRoute route : routes) {
                UriRouteMatch match = route.match(uriStr).orElse(null);
                if (match == null || !match.test(context)) continue;
                matchedRoutes.add(match);
            }
        }
        return matchedRoutes.stream();
    }

    private <T, R> List<UriRouteMatch<T, R>> find(String httpMethodName, CharSequence uri) {
        List routes = this.routesByMethod.getOrDefault(httpMethodName, Collections.emptyList());
        if (CollectionUtils.isNotEmpty(routes)) {
            String uriStr = uri.toString();
            ArrayList<UriRouteMatch<T, R>> routeMatches = new ArrayList<UriRouteMatch<T, R>>(routes.size());
            for (UriRoute route : routes) {
                UriRouteMatch match = route.match(uriStr).orElse(null);
                if (match == null) continue;
                routeMatches.add(match);
            }
            return routeMatches;
        }
        return Collections.EMPTY_LIST;
    }

    private UriRoute[] finalizeRoutes(List<UriRoute> routes) {
        Collections.sort(routes);
        return routes.toArray(new UriRoute[0]);
    }

    private <T> Optional<RouteMatch<T>> findRouteMatch(Map<ErrorRoute, RouteMatch<T>> matchedRoutes, Throwable error) {
        if (matchedRoutes.size() == 1) {
            return matchedRoutes.values().stream().findFirst();
        }
        if (matchedRoutes.size() > 1) {
            int minCount = Integer.MAX_VALUE;
            Supplier<List> hierarchySupplier = () -> ClassUtils.resolveHierarchy(error.getClass());
            Optional<RouteMatch<T>> match = Optional.empty();
            Class<?> errorClass = error.getClass();
            for (Map.Entry<ErrorRoute, RouteMatch<T>> entry : matchedRoutes.entrySet()) {
                Class<? extends Throwable> exceptionType = entry.getKey().exceptionType();
                if (exceptionType.equals(errorClass)) {
                    match = Optional.of(entry.getValue());
                    break;
                }
                List hierarchy = hierarchySupplier.get();
                int index = hierarchy.indexOf(exceptionType);
                if (index <= -1 || index >= minCount) continue;
                minCount = index;
                match = Optional.of(entry.getValue());
            }
            return match;
        }
        return Optional.empty();
    }
}

