/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.filter;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.filter.RouteMatchFilter;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilteredRouter
implements Router {
    private final Router router;
    private final RouteMatchFilter routeFilter;

    public FilteredRouter(Router router, RouteMatchFilter routeFilter) {
        this.router = router;
        this.routeFilter = routeFilter;
    }

    @Override
    @Nonnull
    @Deprecated
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@Nonnull CharSequence uri) {
        return this.router.findAny(uri, null);
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@Nonnull CharSequence uri, @Nullable HttpRequest<?> context) {
        Stream matchStream = this.router.findAny(uri, context);
        if (context != null) {
            return matchStream.filter(this.routeFilter.filter(context));
        }
        return matchStream;
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.router.getExposedPorts();
    }

    @Override
    public void applyDefaultPorts(List<Integer> ports) {
        this.router.applyDefaultPorts(ports);
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri) {
        return this.router.find(httpMethod, uri, null);
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri, @Nullable HttpRequest<?> context) {
        Stream matchStream = this.router.find(httpMethod, uri, context);
        if (context != null) {
            return matchStream.filter(this.routeFilter.filter(context));
        }
        return matchStream;
    }

    @Override
    @Nonnull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@Nonnull HttpRequest<?> request) {
        List closestMatches = this.router.findAllClosest(request);
        return closestMatches.stream().filter(this.routeFilter.filter(request)).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpRequest request, @Nonnull CharSequence uri) {
        return this.router.find(request, uri);
    }

    @Override
    @Nonnull
    public Stream<UriRoute> uriRoutes() {
        return this.router.uriRoutes();
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> route(@Nonnull HttpMethod httpMethod, @Nonnull CharSequence uri) {
        return this.router.route(httpMethod, uri);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull HttpStatus status) {
        return this.router.route(status);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Class originatingClass, @Nonnull HttpStatus status) {
        return this.router.route(originatingClass, status);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Throwable error) {
        return this.router.route(error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@Nonnull Class originatingClass, @Nonnull Throwable error) {
        return this.router.route(originatingClass, error);
    }

    @Override
    @Nonnull
    public List<HttpFilter> findFilters(@Nonnull HttpRequest<?> request) {
        return this.router.findFilters(request);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> GET(@Nonnull CharSequence uri) {
        return this.router.GET(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> POST(@Nonnull CharSequence uri) {
        return this.router.POST(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> PUT(@Nonnull CharSequence uri) {
        return this.router.PUT(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> PATCH(@Nonnull CharSequence uri) {
        return this.router.PATCH(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> DELETE(@Nonnull CharSequence uri) {
        return this.router.DELETE(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> OPTIONS(@Nonnull CharSequence uri) {
        return this.router.OPTIONS(uri);
    }

    @Override
    public <T, R> Optional<UriRouteMatch<T, R>> HEAD(@Nonnull CharSequence uri) {
        return this.router.HEAD(uri);
    }

    @Override
    @Nonnull
    @Deprecated
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpMethod httpMethod, @Nonnull URI uri) {
        return this.router.find(httpMethod, uri, null);
    }

    @Override
    @Nonnull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@Nonnull HttpRequest<?> request) {
        Stream matches = this.router.find(request);
        return matches.filter(this.routeFilter.filter(request));
    }
}

