/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.version.resolution;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.web.router.version.RoutesVersioningConfiguration;
import io.micronaut.web.router.version.resolution.ParameterVersionResolverConfiguration;
import io.micronaut.web.router.version.resolution.RequestVersionResolver;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Requires(beans={RoutesVersioningConfiguration.class, ParameterVersionResolverConfiguration.class})
public class ParameterVersionResolver
implements RequestVersionResolver {
    private final List<String> parameterNames;

    @Inject
    public ParameterVersionResolver(ParameterVersionResolverConfiguration configuration) {
        this.parameterNames = configuration.getNames();
    }

    @Override
    public Optional<String> resolve(HttpRequest<?> request) {
        return this.parameterNames.stream().map(name -> (String)request.getParameters().get((CharSequence)name)).filter(Objects::nonNull).findFirst();
    }
}

