/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import java.util.concurrent.CompletionStage;

@Internal
public class ReactiveMetadata {
    private final boolean isFuture;
    private final boolean isReactiveReturnType;
    private final boolean isKotlinSuspendingFunction;
    private final boolean isKotlinFunctionReturnTypeUnit;
    private final boolean isSingle;

    public ReactiveMetadata(RouteMatch<?> routeMatch) {
        ReturnType<?> genericReturnType = routeMatch.getReturnType();
        Class javaReturnType = genericReturnType.getType();
        this.isFuture = CompletionStage.class.isAssignableFrom(javaReturnType);
        boolean bl = this.isReactiveReturnType = Publishers.isConvertibleToPublisher((Class)javaReturnType) || this.isFuture;
        if (routeMatch instanceof MethodBasedRouteMatch) {
            MethodBasedRouteMatch methodRouteMatch = (MethodBasedRouteMatch)routeMatch;
            this.isKotlinSuspendingFunction = methodRouteMatch.getExecutableMethod().isSuspend();
            this.isKotlinFunctionReturnTypeUnit = this.isKotlinSuspendingFunction && KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)methodRouteMatch.getExecutableMethod());
        } else {
            this.isKotlinSuspendingFunction = false;
            this.isKotlinFunctionReturnTypeUnit = false;
        }
        this.isSingle = this.isReactiveReturnType && Publishers.isSingle((Class)javaReturnType) || this.isResponsePublisher(genericReturnType, javaReturnType) || this.isFuture || routeMatch.getAnnotationMetadata().booleanValue(Produces.class, "single").orElse(false) != false || this.isKotlinSuspendingFunction;
    }

    private boolean isResponsePublisher(ReturnType<?> genericReturnType, Class<?> javaReturnType) {
        return Publishers.isConvertibleToPublisher(javaReturnType) && genericReturnType.getFirstTypeVariable().map(arg -> HttpResponse.class.isAssignableFrom(arg.getType())).orElse(false) != false;
    }

    public boolean isFuture() {
        return this.isFuture;
    }

    public boolean isReactiveReturnType() {
        return this.isReactiveReturnType;
    }

    public boolean isKotlinSuspendingFunction() {
        return this.isKotlinSuspendingFunction;
    }

    public boolean isKotlinFunctionReturnTypeUnit() {
        return this.isKotlinFunctionReturnTypeUnit;
    }

    public boolean isSingle() {
        return this.isSingle;
    }
}

