/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.MethodConvention;
import io.micronaut.core.naming.conventions.PropertyConvention;
import io.micronaut.core.naming.conventions.TypeConvention;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.ResourceRoute;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.UriRoute;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

@Indexed(value=RouteBuilder.class)
public interface RouteBuilder {
    public static final PropertyConvention ID = PropertyConvention.ID;

    public Set<Integer> getExposedPorts();

    public List<FilterRoute> getFilterRoutes();

    public List<UriRoute> getUriRoutes();

    public List<StatusRoute> getStatusRoutes();

    public List<ErrorRoute> getErrorRoutes();

    public UriNamingStrategy getUriNamingStrategy();

    public FilterRoute addFilter(String var1, Supplier<HttpFilter> var2);

    public ResourceRoute resources(Class var1);

    default public ResourceRoute resources(Object instance) {
        return this.resources(instance.getClass());
    }

    public ResourceRoute single(Class var1);

    default public ResourceRoute single(Object instance) {
        return this.single(instance.getClass());
    }

    default public StatusRoute status(HttpStatus status, Object instance, String method) {
        return this.status(status, instance.getClass(), method, ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    public StatusRoute status(HttpStatus var1, Class var2, String var3, Class ... var4);

    public StatusRoute status(Class var1, HttpStatus var2, Class var3, String var4, Class ... var5);

    public ErrorRoute error(Class<? extends Throwable> var1, Class var2, String var3, Class ... var4);

    public ErrorRoute error(Class var1, Class<? extends Throwable> var2, Class var3, String var4, Class ... var5);

    default public ErrorRoute error(Class<? extends Throwable> error, Class type) {
        return this.error(error, type, NameUtils.decapitalize((String)NameUtils.trimSuffix((String)type.getSimpleName(), (String[])new String[]{"Exception", "Error"})), ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    default public ErrorRoute error(Class<? extends Throwable> error, Object instance) {
        return this.error(error, instance.getClass(), NameUtils.decapitalize((String)NameUtils.trimSuffix((String)error.getSimpleName(), (String[])new String[]{"Exception", "Error"})), error);
    }

    default public ErrorRoute error(Class<? extends Throwable> error, Object instance, String method) {
        return this.error(error, instance.getClass(), method, error);
    }

    default public ErrorRoute error(Class<? extends Throwable> error, Object instance, String method, Class ... parameterTypes) {
        return this.error(error, instance.getClass(), method, parameterTypes);
    }

    default public UriRoute GET(String uri, Object target) {
        return this.GET(uri, target, MethodConvention.INDEX.methodName(), new Class[0]);
    }

    default public UriRoute GET(Object target) {
        Class<?> type = target.getClass();
        return this.GET(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute GET(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.GET(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.SHOW.methodName(), Object.class);
    }

    default public UriRoute GET(Class type) {
        return this.GET(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.INDEX.methodName(), new Class[0]);
    }

    default public UriRoute GET(Class type, PropertyConvention id) {
        return this.GET(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.SHOW.methodName(), Object.class);
    }

    default public UriRoute GET(String uri, ExecutableMethod<?, ?> method) {
        return this.GET(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute GET(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.GET(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute GET(String var1, Object var2, String var3, Class ... var4);

    public UriRoute GET(String var1, Class<?> var2, String var3, Class ... var4);

    default public UriRoute POST(String uri, Object target, Class ... parameterTypes) {
        return this.POST(uri, target, MethodConvention.SAVE.methodName(), parameterTypes);
    }

    default public UriRoute POST(Object target) {
        Class<?> type = target.getClass();
        return this.POST(this.getUriNamingStrategy().resolveUri(type), target, new Class[0]);
    }

    default public UriRoute POST(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.POST(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.UPDATE.methodName(), new Class[0]);
    }

    default public UriRoute POST(Class type) {
        return this.POST(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.SAVE.methodName(), new Class[0]);
    }

    default public UriRoute POST(Class type, PropertyConvention id) {
        return this.POST(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.UPDATE.methodName(), new Class[0]);
    }

    default public UriRoute POST(String uri, ExecutableMethod<?, ?> method) {
        return this.POST(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute POST(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.POST(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute POST(String var1, Object var2, String var3, Class ... var4);

    public UriRoute POST(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute PUT(String uri, Object target) {
        return this.PUT(uri, target, MethodConvention.UPDATE.methodName(), new Class[0]);
    }

    default public UriRoute PUT(Object target) {
        Class<?> type = target.getClass();
        return this.PUT(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute PUT(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.PUT(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PUT(Class type) {
        return this.PUT(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PUT(Class type, PropertyConvention id) {
        return this.PUT(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PUT(String uri, ExecutableMethod<?, ?> method) {
        return this.PUT(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute PUT(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.PUT(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute PUT(String var1, Object var2, String var3, Class ... var4);

    public UriRoute PUT(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute PATCH(String uri, Object target) {
        return this.PATCH(uri, target, MethodConvention.UPDATE.methodName(), new Class[0]);
    }

    default public UriRoute PATCH(Object target) {
        Class<?> type = target.getClass();
        return this.PATCH(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute PATCH(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.PATCH(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PATCH(Class type) {
        return this.PATCH(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PATCH(Class type, PropertyConvention id) {
        return this.PATCH(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.UPDATE.methodName(), Object.class);
    }

    default public UriRoute PATCH(String uri, ExecutableMethod<?, ?> method) {
        return this.PATCH(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute PATCH(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.PATCH(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute PATCH(String var1, Object var2, String var3, Class ... var4);

    public UriRoute PATCH(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute DELETE(String uri, Object target) {
        return this.DELETE(uri, target, MethodConvention.DELETE.methodName(), Object.class);
    }

    default public UriRoute DELETE(Object target) {
        Class<?> type = target.getClass();
        return this.DELETE(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute DELETE(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.DELETE(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.DELETE.methodName(), Object.class);
    }

    default public UriRoute DELETE(Class type) {
        return this.DELETE(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.DELETE.methodName(), Object.class);
    }

    default public UriRoute DELETE(Class type, PropertyConvention id) {
        return this.DELETE(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.DELETE.methodName(), Object.class);
    }

    default public UriRoute DELETE(String uri, ExecutableMethod<?, ?> method) {
        return this.DELETE(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute DELETE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.DELETE(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute DELETE(String var1, Object var2, String var3, Class ... var4);

    public UriRoute DELETE(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute OPTIONS(String uri, Object target) {
        return this.OPTIONS(uri, target, MethodConvention.OPTIONS.methodName(), new Class[0]);
    }

    default public UriRoute OPTIONS(Object target) {
        Class<?> type = target.getClass();
        return this.OPTIONS(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute OPTIONS(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.OPTIONS(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.OPTIONS.methodName(), new Class[0]);
    }

    default public UriRoute OPTIONS(Class type) {
        return this.OPTIONS(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.OPTIONS.methodName(), new Class[0]);
    }

    default public UriRoute OPTIONS(Class type, PropertyConvention id) {
        return this.OPTIONS(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.OPTIONS.methodName(), new Class[0]);
    }

    default public UriRoute OPTIONS(String uri, ExecutableMethod<?, ?> method) {
        return this.OPTIONS(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute OPTIONS(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.OPTIONS(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute OPTIONS(String var1, Object var2, String var3, Class ... var4);

    public UriRoute OPTIONS(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute HEAD(String uri, Object target) {
        return this.HEAD(uri, target, MethodConvention.HEAD.methodName(), new Class[0]);
    }

    default public UriRoute HEAD(Object target) {
        Class<?> type = target.getClass();
        return this.HEAD(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute HEAD(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.HEAD(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.HEAD.methodName(), new Class[0]);
    }

    default public UriRoute HEAD(Class type) {
        return this.HEAD(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.HEAD.methodName(), new Class[0]);
    }

    default public UriRoute HEAD(Class type, PropertyConvention id) {
        return this.HEAD(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.HEAD.methodName(), new Class[0]);
    }

    default public UriRoute HEAD(String uri, ExecutableMethod<?, ?> method) {
        return this.HEAD(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute HEAD(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.HEAD(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute HEAD(String var1, Object var2, String var3, Class ... var4);

    public UriRoute HEAD(String var1, Class var2, String var3, Class ... var4);

    default public UriRoute TRACE(String uri, Object target) {
        return this.TRACE(uri, target, MethodConvention.TRACE.methodName(), new Class[0]);
    }

    default public UriRoute TRACE(Object target) {
        Class<?> type = target.getClass();
        return this.TRACE(this.getUriNamingStrategy().resolveUri(type), target);
    }

    default public UriRoute TRACE(Object target, PropertyConvention id) {
        Class<?> type = target.getClass();
        return this.TRACE(this.getUriNamingStrategy().resolveUri(type, id), target, MethodConvention.TRACE.methodName(), new Class[0]);
    }

    default public UriRoute TRACE(Class type) {
        return this.TRACE(this.getUriNamingStrategy().resolveUri(type), type, MethodConvention.TRACE.methodName(), new Class[0]);
    }

    default public UriRoute TRACE(Class type, PropertyConvention id) {
        return this.HEAD(this.getUriNamingStrategy().resolveUri(type, id), type, MethodConvention.TRACE.methodName(), new Class[0]);
    }

    default public UriRoute TRACE(String uri, ExecutableMethod<?, ?> method) {
        return this.TRACE(uri, method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
    }

    default public UriRoute TRACE(String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        return this.TRACE(uri, beanDefinition.getBeanType(), method.getMethodName(), method.getArgumentTypes());
    }

    public UriRoute TRACE(String var1, Object var2, String var3, Class ... var4);

    public UriRoute TRACE(String var1, Class var2, String var3, Class ... var4);

    public static interface UriNamingStrategy {
        default public String resolveUri(Class<?> type) {
            Controller annotation = type.getAnnotation(Controller.class);
            String uri = this.normalizeUri(annotation != null ? annotation.value() : null);
            if (uri != null) {
                return uri;
            }
            return '/' + TypeConvention.CONTROLLER.asPropertyName(type);
        }

        @NonNull
        default public String resolveUri(BeanDefinition<?> beanDefinition) {
            Class beanType;
            String uri = beanDefinition.stringValue(UriMapping.class).orElseGet(() -> beanDefinition.stringValue(Controller.class).orElse("/"));
            if ((uri = this.normalizeUri(uri)) != null) {
                return uri;
            }
            if (beanDefinition instanceof ProxyBeanDefinition) {
                ProxyBeanDefinition pbd = (ProxyBeanDefinition)beanDefinition;
                beanType = pbd.getTargetType();
            } else {
                beanType = beanDefinition.getBeanType();
            }
            return '/' + TypeConvention.CONTROLLER.asPropertyName(beanType);
        }

        @NonNull
        default public String resolveUri(String property) {
            if (StringUtils.isEmpty((CharSequence)property)) {
                return "/";
            }
            if (property.charAt(0) != '/') {
                return '/' + NameUtils.decapitalize((String)property);
            }
            return property;
        }

        @NonNull
        default public String resolveUri(Class type, PropertyConvention id) {
            return this.resolveUri(type) + "/{" + id.lowerCaseName() + "}";
        }

        default public String normalizeUri(@Nullable String uri) {
            if (uri != null) {
                int len = uri.length();
                if (len > 0 && uri.charAt(0) != '/') {
                    uri = '/' + uri;
                }
                if (len > 1 && uri.charAt(uri.length() - 1) == '/') {
                    uri = uri.substring(0, uri.length() - 1);
                }
                if (len > 0) {
                    return uri;
                }
            }
            return null;
        }
    }
}

