/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.naming;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.TypeConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.RouteBuilder;
import javax.inject.Singleton;

@Singleton
@Primary
public class HyphenatedUriNamingStrategy
implements RouteBuilder.UriNamingStrategy {
    public String resolveUri(Class type) {
        return '/' + TypeConvention.CONTROLLER.asHyphenatedName(type);
    }

    @Override
    @NonNull
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        String uri = beanDefinition.stringValue(UriMapping.class).orElseGet(() -> beanDefinition.stringValue(Controller.class).orElse("/"));
        return this.normalizeUri(uri);
    }

    @Override
    @NonNull
    public String resolveUri(String property) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            return "/";
        }
        if (property.charAt(0) != '/') {
            return '/' + NameUtils.hyphenate((String)property, (boolean)true);
        }
        return property;
    }
}

