/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.naming;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.naming.conventions.PropertyConvention;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.naming.HyphenatedUriNamingStrategy;
import javax.inject.Singleton;

@Primary
@Singleton
@Replaces(value=HyphenatedUriNamingStrategy.class)
@Requires(property="micronaut.server.context-path")
public class ConfigurableUriNamingStrategy
extends HyphenatedUriNamingStrategy {
    private final String contextPath;

    public ConfigurableUriNamingStrategy(@Value(value="${micronaut.server.context-path}") String contextPath) {
        this.contextPath = this.normalizeContextPath(contextPath);
    }

    @Override
    public String resolveUri(Class type) {
        return this.contextPath + super.resolveUri(type);
    }

    @Override
    @NonNull
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        return this.contextPath + super.resolveUri(beanDefinition);
    }

    @Override
    @NonNull
    public String resolveUri(String property) {
        return this.contextPath + super.resolveUri(property);
    }

    @Override
    @NonNull
    public String resolveUri(Class type, PropertyConvention id) {
        return this.contextPath + super.resolveUri(type, id);
    }

    private String normalizeContextPath(String contextPath) {
        if (contextPath.charAt(0) != '/') {
            contextPath = '/' + contextPath;
        }
        if (contextPath.charAt(contextPath.length() - 1) == '/') {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }
}

