/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.processor.BeanDefinitionProcessor;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AnnotatedFilterRouteBuilder
extends DefaultRouteBuilder
implements BeanDefinitionProcessor<Filter> {
    private final ServerContextPathProvider contextPathProvider;

    @Inject
    public AnnotatedFilterRouteBuilder(BeanContext beanContext, ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService, @Nullable ServerContextPathProvider contextPathProvider) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.contextPathProvider = contextPathProvider;
    }

    public void process(BeanDefinition<?> beanDefinition, BeanContext beanContext) {
        if (HttpClientFilter.class.isAssignableFrom(beanDefinition.getBeanType())) {
            return;
        }
        Object[] patterns = this.getPatterns(beanDefinition);
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            Object[] methods = (HttpMethod[])beanDefinition.enumValues(Filter.class, "methods", HttpMethod.class);
            Object first = patterns[0];
            FilterRoute filterRoute = this.addFilter((String)first, (BeanLocator)beanContext, beanDefinition);
            if (patterns.length > 1) {
                for (int i = 1; i < patterns.length; ++i) {
                    Object pattern = patterns[i];
                    filterRoute.pattern((String)pattern);
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])methods)) {
                filterRoute.methods((HttpMethod[])methods);
            }
        }
    }

    protected String[] getPatterns(BeanDefinition<?> beanDefinition) {
        String contextPath;
        String[] values = beanDefinition.stringValues(Filter.class);
        String string = contextPath = this.contextPathProvider != null ? this.contextPathProvider.getContextPath() : null;
        if (contextPath != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i].startsWith(contextPath)) continue;
                String newValue = StringUtils.prependUri((String)contextPath, (String)values[i]);
                if (newValue.charAt(0) != '/') {
                    newValue = "/" + newValue;
                }
                values[i] = newValue;
            }
        }
        return values;
    }
}

