/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.filter.HttpServerFilterResolver;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.MethodBasedRoute;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.RoutingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultRouter
implements Router,
HttpServerFilterResolver<RouteMatch<?>> {
    private final Map<String, List<UriRoute>> routesByMethod = new HashMap<String, List<UriRoute>>();
    private final List<StatusRoute> statusRoutes = new ArrayList<StatusRoute>();
    private final Collection<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
    private final List<ErrorRoute> errorRoutes = new ArrayList<ErrorRoute>();
    private final Set<Integer> exposedPorts;

    @Inject
    public DefaultRouter(Collection<RouteBuilder> builders) {
        HashSet<Integer> exposedPorts = new HashSet<Integer>(5);
        for (RouteBuilder builder : builders) {
            MethodBasedRoute existing;
            List<UriRoute> constructedRoutes = builder.getUriRoutes();
            for (UriRoute route : constructedRoutes) {
                String key = route.getHttpMethodName();
                this.routesByMethod.computeIfAbsent(key, x -> new ArrayList()).add(route);
            }
            for (StatusRoute statusRoute : builder.getStatusRoutes()) {
                if (this.statusRoutes.contains(statusRoute)) {
                    existing = this.statusRoutes.stream().filter(r -> r.equals(statusRoute)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for http status [" + statusRoute.status() + "]. New route: " + statusRoute + ". Existing: " + existing);
                }
                this.statusRoutes.add(statusRoute);
            }
            for (ErrorRoute errorRoute : builder.getErrorRoutes()) {
                if (this.errorRoutes.contains(errorRoute)) {
                    existing = this.errorRoutes.stream().filter(r -> r.equals(errorRoute)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for error [" + errorRoute.exceptionType().getSimpleName() + "]. New route: " + errorRoute + ". Existing: " + existing);
                }
                this.errorRoutes.add(errorRoute);
            }
            this.filterRoutes.addAll(builder.getFilterRoutes());
            exposedPorts.addAll(builder.getExposedPorts());
        }
        this.exposedPorts = CollectionUtils.isNotEmpty(exposedPorts) ? exposedPorts : Collections.emptySet();
        this.routesByMethod.values().forEach(this::finalizeRoutes);
    }

    public DefaultRouter(RouteBuilder ... builders) {
        this(Arrays.asList(builders));
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void applyDefaultPorts(List<Integer> ports) {
        Predicate<HttpRequest> portMatches = httpRequest -> ports.contains(httpRequest.getServerAddress().getPort());
        this.routesByMethod.values().forEach(routes -> {
            for (int i = 0; i < routes.size(); ++i) {
                UriRoute route = (UriRoute)routes.get(i);
                if (route.getPort() != null) continue;
                routes.set(i, route.where(portMatches));
            }
        });
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request, @NonNull CharSequence uri) {
        return this.find(request.getMethodName(), uri).stream();
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request) {
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        return this.find(request, (CharSequence)request.getPath()).filter(match -> match.test(request) && (!permitsBody || match.doesConsume(request.getContentType().orElse(null))));
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri, @Nullable HttpRequest<?> context) {
        return this.find(httpMethod.name(), uri).stream();
    }

    @Override
    @NonNull
    public Stream<UriRoute> uriRoutes() {
        return this.routesByMethod.values().stream().flatMap(Collection::stream);
    }

    @Override
    @NonNull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@NonNull HttpRequest<?> request) {
        HttpMethod httpMethod = request.getMethod();
        MediaType contentType = request.getContentType().orElse(null);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        Collection acceptedProducedTypes = request.accept();
        List<UriRouteMatch<T, R>> uriRoutes = this.find(request.getMethodName(), (CharSequence)request.getPath());
        uriRoutes.removeIf(routeMatch -> !routeMatch.test(request) || permitsBody && !routeMatch.doesConsume(contentType) || !routeMatch.doesProduce(acceptedProducedTypes));
        int routeCount = uriRoutes.size();
        if (routeCount <= 1) {
            return uriRoutes;
        }
        if (CollectionUtils.isNotEmpty((Collection)acceptedProducedTypes)) {
            MediaType mediaType = (MediaType)acceptedProducedTypes.iterator().next();
            List mostSpecific = uriRoutes.stream().filter(routeMatch -> routeMatch.doesProduce(mediaType)).collect(Collectors.toList());
            if (!mostSpecific.isEmpty() || !acceptedProducedTypes.contains(MediaType.ALL_TYPE)) {
                uriRoutes = mostSpecific;
            }
        }
        if ((routeCount = uriRoutes.size()) > 1 && permitsBody) {
            ArrayList<UriRouteMatch<T, R>> explicitlyConsumedRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            ArrayList<UriRouteMatch<T, R>> consumesRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (UriRouteMatch<T, R> match : uriRoutes) {
                if (match.explicitlyConsumes(contentType != null ? contentType : MediaType.ALL_TYPE)) {
                    explicitlyConsumedRoutes.add(match);
                }
                if (!explicitlyConsumedRoutes.isEmpty() || !match.doesConsume(contentType)) continue;
                consumesRoutes.add(match);
            }
            List<UriRouteMatch<T, R>> list = uriRoutes = explicitlyConsumedRoutes.isEmpty() ? consumesRoutes : explicitlyConsumedRoutes;
        }
        if ((routeCount = uriRoutes.size()) > 1) {
            long variableCount = 0L;
            long rawLength = 0L;
            ArrayList<UriRouteMatch<T, R>> closestMatches = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (int i = 0; i < routeCount; ++i) {
                UriRouteMatch<T, R> match = uriRoutes.get(i);
                UriMatchTemplate template = match.getRoute().getUriMatchTemplate();
                long variable = template.getPathVariableSegmentCount();
                long raw = template.getRawSegmentLength();
                if (i == 0) {
                    variableCount = variable;
                    rawLength = raw;
                }
                if (variable > variableCount || raw < rawLength) break;
                closestMatches.add(match);
            }
            uriRoutes = closestMatches;
        }
        return uriRoutes;
    }

    @Override
    @NonNull
    public <T, R> Optional<UriRouteMatch<T, R>> route(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri) {
        List routes = this.routesByMethod.getOrDefault(httpMethod.name(), Collections.emptyList());
        Optional<UriRouteMatch> result = routes.stream().map(route -> route.match(uri.toString())).filter(Optional::isPresent).map(Optional::get).findFirst();
        UriRouteMatch match = result.orElse(null);
        return Optional.ofNullable(match);
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match;
            if (statusRoute.originatingType() != null || !(match = statusRoute.match(status)).isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class originatingClass, @NonNull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match = statusRoute.match(originatingClass, status);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class originatingClass, @NonNull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(originatingClass, error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(originatingClass, error, request);
    }

    private <R> Optional<RouteMatch<R>> findErrorRouteInternal(@Nullable Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            LinkedHashMap matchedRoutes = new LinkedHashMap();
            for (ErrorRoute errorRoute : this.errorRoutes) {
                RouteMatch match = errorRoute.match(originatingClass, error).orElse(null);
                if (match == null || !match.doesProduce(accept)) continue;
                matchedRoutes.put(errorRoute, match);
            }
            return this.findRouteMatch(matchedRoutes, error);
        }
        LinkedHashMap producesAllMatchedRoutes = new LinkedHashMap();
        LinkedHashMap producesSpecificMatchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            RouteMatch match = errorRoute.match(originatingClass, error).orElse(null);
            if (match == null) continue;
            List<MediaType> produces = match.getProduces();
            if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                producesAllMatchedRoutes.put(errorRoute, match);
                continue;
            }
            producesSpecificMatchedRoutes.put(errorRoute, match);
        }
        if (producesAllMatchedRoutes.isEmpty()) {
            return this.findRouteMatch(producesSpecificMatchedRoutes, error);
        }
        return this.findRouteMatch(producesAllMatchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(null, error, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(originatingClass, status, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(null, status, request);
    }

    private <R> Optional<RouteMatch<R>> findStatusInternal(@Nullable Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            for (StatusRoute statusRoute : this.statusRoutes) {
                RouteMatch match = statusRoute.match(originatingClass, status).orElse(null);
                if (match == null || !match.doesProduce(accept)) continue;
                return Optional.of(match);
            }
        } else {
            RouteMatch firstMatch = null;
            for (StatusRoute errorRoute : this.statusRoutes) {
                RouteMatch match = errorRoute.match(originatingClass, status).orElse(null);
                if (match == null) continue;
                List<MediaType> produces = match.getProduces();
                if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                    return Optional.of(match);
                }
                if (firstMatch != null) continue;
                firstMatch = match;
            }
            return Optional.ofNullable(firstMatch);
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            if (errorRoute.originatingType() != null) continue;
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    @NonNull
    public List<HttpFilter> findFilters(@NonNull HttpRequest<?> request) {
        if (!this.filterRoutes.isEmpty()) {
            Object o = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH).orElse(null);
            if (o instanceof RouteMatch) {
                RouteMatch routeMatch = o;
                return this.resolveFilters(request, this.filterRouteStream(routeMatch));
            }
            ArrayList httpFilters = new ArrayList(this.filterRoutes.size());
            HttpMethod method = request.getMethod();
            URI uri = request.getUri();
            for (FilterRoute filterRoute : this.filterRoutes) {
                Optional<HttpFilter> match = filterRoute.match(method, uri);
                match.ifPresent(httpFilters::add);
            }
            if (!httpFilters.isEmpty()) {
                OrderUtil.sort(httpFilters);
                return Collections.unmodifiableList(httpFilters);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@NonNull CharSequence uri, @Nullable HttpRequest<?> context) {
        ArrayList<UriRouteMatch> matchedRoutes = new ArrayList<UriRouteMatch>(5);
        String uriStr = uri.toString();
        for (List<UriRoute> routes : this.routesByMethod.values()) {
            for (UriRoute route : routes) {
                UriRouteMatch match = route.match(uriStr).orElse(null);
                if (match == null || !match.test(context)) continue;
                matchedRoutes.add(match);
            }
        }
        return matchedRoutes.stream();
    }

    private <T, R> List<UriRouteMatch<T, R>> find(String httpMethodName, CharSequence uri) {
        List routes = this.routesByMethod.getOrDefault(httpMethodName, Collections.emptyList());
        if (CollectionUtils.isNotEmpty(routes)) {
            String uriStr = uri.toString();
            ArrayList<UriRouteMatch<T, R>> routeMatches = new ArrayList<UriRouteMatch<T, R>>(routes.size());
            for (UriRoute route : routes) {
                UriRouteMatch match = route.match(uriStr).orElse(null);
                if (match == null) continue;
                routeMatches.add(match);
            }
            return routeMatches;
        }
        return Collections.emptyList();
    }

    private UriRoute[] finalizeRoutes(List<UriRoute> routes) {
        Collections.sort(routes);
        return routes.toArray(new UriRoute[0]);
    }

    private <T> Optional<RouteMatch<T>> findRouteMatch(Map<ErrorRoute, RouteMatch<T>> matchedRoutes, Throwable error) {
        if (matchedRoutes.size() == 1) {
            return matchedRoutes.values().stream().findFirst();
        }
        if (matchedRoutes.size() > 1) {
            int minCount = Integer.MAX_VALUE;
            Supplier<List> hierarchySupplier = () -> ClassUtils.resolveHierarchy(error.getClass());
            Optional<RouteMatch<T>> match = Optional.empty();
            Class<?> errorClass = error.getClass();
            for (Map.Entry<ErrorRoute, RouteMatch<T>> entry : matchedRoutes.entrySet()) {
                Class<? extends Throwable> exceptionType = entry.getKey().exceptionType();
                if (exceptionType.equals(errorClass)) {
                    match = Optional.of(entry.getValue());
                    break;
                }
                List hierarchy = hierarchySupplier.get();
                int index = hierarchy.indexOf(exceptionType);
                if (index <= -1 || index >= minCount) continue;
                minCount = index;
                match = Optional.of(entry.getValue());
            }
            return match;
        }
        return Optional.empty();
    }

    public List<HttpFilterResolver.FilterEntry<HttpFilter>> resolveFilterEntries(RouteMatch<?> context) {
        return this.filterRouteStream(context).collect(Collectors.toList());
    }

    public List<HttpFilter> resolveFilters(HttpRequest<?> request, List<HttpFilterResolver.FilterEntry<HttpFilter>> filterEntries) {
        Stream entryStream = filterEntries.stream();
        return this.resolveFilters(request, entryStream);
    }

    private List<HttpFilter> resolveFilters(HttpRequest<?> request, Stream<? extends HttpFilterResolver.FilterEntry<HttpFilter>> entryStream) {
        return entryStream.filter(entry -> {
            if (entry.hasMethods() && !entry.getFilterMethods().contains(request.getMethod())) {
                return false;
            }
            if (entry.hasPatterns()) {
                String[] patterns;
                String path = request.getPath();
                for (String pattern : patterns = entry.getPatterns()) {
                    if (!"/**".equals(pattern) && !PathMatcher.ANT.matches(pattern, path)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }).map(HttpFilterResolver.FilterEntry::getFilter).sorted(OrderUtil.COMPARATOR).collect(Collectors.toList());
    }

    private Stream<FilterRoute> filterRouteStream(RouteMatch<?> context) {
        return this.filterRoutes.stream().filter(filterRoute -> {
            String filterAnnotation;
            boolean matches;
            AnnotationMetadata annotationMetadata = filterRoute.getAnnotationMetadata();
            boolean bl = matches = !annotationMetadata.hasStereotype(FilterMatcher.NAME);
            if (!matches && (filterAnnotation = (String)annotationMetadata.getAnnotationNameByStereotype(FilterMatcher.NAME).orElse(null)) != null) {
                matches = context.getAnnotationMetadata().hasStereotype(filterAnnotation);
            }
            return matches;
        });
    }
}

