/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.resource;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.util.AntPathMatcher;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.web.router.resource.StaticResourceConfiguration;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class StaticResourceResolver {
    private static final String INDEX_PAGE = "index.html";
    private final AntPathMatcher pathMatcher;
    private final Map<String, List<ResourceLoader>> resourceMappings = new LinkedHashMap<String, List<ResourceLoader>>();

    StaticResourceResolver(List<StaticResourceConfiguration> configurations) {
        this.pathMatcher = PathMatcher.ANT;
        if (CollectionUtils.isNotEmpty(configurations)) {
            for (StaticResourceConfiguration config : configurations) {
                if (!config.isEnabled()) continue;
                this.resourceMappings.put(config.getMapping(), config.getResourceLoaders());
            }
        }
    }

    public Optional<URL> resolve(String resourcePath) {
        for (Map.Entry<String, List<ResourceLoader>> entry : this.resourceMappings.entrySet()) {
            List<ResourceLoader> loaders = entry.getValue();
            String mapping = entry.getKey();
            if (loaders.isEmpty() || !this.pathMatcher.matches(mapping, resourcePath)) continue;
            String path = this.pathMatcher.extractPathWithinPattern(mapping, resourcePath);
            if (StringUtils.isEmpty((CharSequence)path)) {
                path = INDEX_PAGE;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (ResourceLoader loader : loaders) {
                Optional resource = loader.getResource(path);
                if (resource.isPresent()) {
                    return resource;
                }
                if (path.indexOf(46) != -1) continue;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (!(resource = loader.getResource(path = path + INDEX_PAGE)).isPresent()) continue;
                return resource;
            }
        }
        return Optional.empty();
    }
}

