/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.DefaultRequestMatcher;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.StatusRouteInfo;
import io.micronaut.web.router.StatusRouteMatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

@Internal
public final class DefaultStatusRouteInfo<T, R>
extends DefaultRequestMatcher<T, R>
implements StatusRouteInfo<T, R> {
    private final Class<?> originatingType;
    private final HttpStatus status;
    private final ConversionService conversionService;

    public DefaultStatusRouteInfo(Class<?> originatingType, HttpStatus status, MethodExecutionHandle<T, R> targetMethod, @Nullable String bodyArgumentName, @Nullable Argument<?> bodyArgument, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, List<Predicate<HttpRequest<?>>> predicates, ConversionService conversionService, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        super(targetMethod, bodyArgument, bodyArgumentName, consumesMediaTypes, producesMediaTypes, true, true, predicates, messageBodyHandlerRegistry);
        this.originatingType = originatingType;
        this.status = status;
        this.conversionService = conversionService;
    }

    @Override
    public Class<?> originatingType() {
        return this.originatingType;
    }

    @Override
    public HttpStatus status() {
        return this.status;
    }

    @Override
    public HttpStatus findStatus(HttpStatus defaultStatus) {
        return super.findStatus(this.status);
    }

    @Override
    public Optional<RouteMatch<R>> match(Class<?> originatingClass, HttpStatus status) {
        if (originatingClass == this.originatingType && this.status == status) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    public Optional<RouteMatch<R>> match(HttpStatus status) {
        if (this.originatingType == null && this.status == status) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return ObjectUtils.hash((Object)super.hashCode(), (Object)this.status, this.originatingType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultStatusRouteInfo)) {
            return false;
        }
        DefaultStatusRouteInfo that = (DefaultStatusRouteInfo)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.status == that.status && Objects.equals(this.originatingType, that.originatingType);
    }

    public String toString() {
        return "" + ' ' + (CharSequence)this.status + " -> " + this.getTargetMethod().getDeclaringType().getSimpleName() + '#' + this.getTargetMethod();
    }
}

