/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.DefaultRequestMatcher;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.StatusRouteInfo;
import io.micronaut.web.router.StatusRouteMatch;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

@Internal
public final class DefaultStatusRouteInfo<T, R>
extends DefaultRequestMatcher<T, R>
implements StatusRouteInfo<T, R> {
    private final Class<?> originatingType;
    private final int statusCode;
    private final ConversionService conversionService;

    public DefaultStatusRouteInfo(Class<?> originatingType, int statusCode, MethodExecutionHandle<T, R> targetMethod, @Nullable String bodyArgumentName, @Nullable Argument<?> bodyArgument, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, List<Predicate<HttpRequest<?>>> predicates, ConversionService conversionService, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        super(targetMethod, bodyArgument, bodyArgumentName, consumesMediaTypes, producesMediaTypes, true, true, predicates, messageBodyHandlerRegistry);
        this.originatingType = originatingType;
        this.statusCode = statusCode;
        this.conversionService = conversionService;
    }

    @Override
    public Class<?> originatingType() {
        return this.originatingType;
    }

    @Override
    public HttpStatus status() {
        return HttpStatus.valueOf((int)this.statusCode);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @NonNull
    public HttpStatus findStatus(HttpStatus defaultStatus) {
        return super.findStatus(this.status());
    }

    @Override
    public Optional<RouteMatch<R>> match(Class<?> originatingClass, HttpStatus status) {
        if (originatingClass == this.originatingType && this.statusCode == status.getCode()) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    public Optional<RouteMatch<R>> match(HttpStatus status) {
        if (this.originatingType == null && this.statusCode == status.getCode()) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    public Optional<RouteMatch<R>> match(int statusCode) {
        if (this.originatingType == null && this.statusCode == statusCode) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    @Override
    public Optional<RouteMatch<R>> match(Class<?> originatingClass, int statusCode) {
        if (originatingClass == this.originatingType && this.statusCode == statusCode) {
            return Optional.of(new StatusRouteMatch(this, this.conversionService));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return ObjectUtils.hash((Object)super.hashCode(), (Object)this.statusCode, this.originatingType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultStatusRouteInfo)) {
            return false;
        }
        DefaultStatusRouteInfo that = (DefaultStatusRouteInfo)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.statusCode == that.statusCode && Objects.equals(this.originatingType, that.originatingType);
    }

    public String toString() {
        return " " + this.statusCode + " -> " + this.getTargetMethod().getDeclaringType().getSimpleName() + "#" + this.getTargetMethod();
    }
}

