/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.scheduling.executor.ThreadSelection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public interface RouteInfo<R>
extends AnnotationMetadataProvider {
    public static final List<MediaType> DEFAULT_PRODUCES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);

    @Nullable
    default public MessageBodyWriter<R> getMessageBodyWriter() {
        return null;
    }

    @Nullable
    default public MessageBodyReader<?> getMessageBodyReader() {
        return null;
    }

    public ReturnType<? extends R> getReturnType();

    @NonNull
    public Argument<?> getResponseBodyType();

    default public boolean isResponseBodyJsonFormattable() {
        Argument<?> argument = this.getResponseBodyType();
        return argument.getType() != byte[].class && !ByteBuffer.class.isAssignableFrom(argument.getType());
    }

    @Deprecated(since="4.0", forRemoval=true)
    default public Argument<?> getBodyType() {
        return this.getResponseBodyType();
    }

    public Optional<Argument<?>> getRequestBodyType();

    @Deprecated(since="4.0", forRemoval=true)
    default public Optional<Argument<?>> getBodyArgument() {
        return this.getRequestBodyType();
    }

    @Internal
    default public Optional<Argument<?>> getFullRequestBodyType() {
        return this.getRequestBodyType().filter(argument -> {
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (annotationMetadata.hasAnnotation(Body.class)) {
                return annotationMetadata.stringValue(Body.class).isEmpty();
            }
            return false;
        });
    }

    public Class<?> getDeclaringType();

    public List<MediaType> getProduces();

    public List<MediaType> getConsumes();

    default public boolean consumesAll() {
        return false;
    }

    public boolean doesConsume(@Nullable MediaType var1);

    default public boolean producesAll() {
        return false;
    }

    public boolean doesProduce(@Nullable Collection<MediaType> var1);

    public boolean doesProduce(@Nullable MediaType var1);

    public boolean explicitlyConsumes(@Nullable MediaType var1);

    public boolean explicitlyProduces(@Nullable MediaType var1);

    public boolean isSuspended();

    default public boolean isImperative() {
        return false;
    }

    public boolean isReactive();

    public boolean isSingleResult();

    public boolean isSpecifiedSingle();

    public boolean isCompletable();

    public boolean isAsync();

    public boolean isAsyncOrReactive();

    public boolean isVoid();

    public boolean isErrorRoute();

    @NonNull
    public HttpStatus findStatus(HttpStatus var1);

    public boolean isWebSocketRoute();

    public boolean isPermitsRequestBody();

    @Nullable
    public ExecutorService getExecutor(@Nullable ThreadSelection var1);

    public boolean needsRequestBody();
}

