/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch.osx;

import com.sun.jna.Library;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.io.watch.FileWatchCondition;
import io.micronaut.scheduling.io.watch.WatchServiceFactory;
import java.io.IOException;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(property="micronaut.io.watch.enabled", value="true", defaultValue="true"), @Requires(condition=FileWatchCondition.class), @Requires(classes={MacOSXListeningWatchService.class, Library.class})})
@Factory
public class MacOsWatchServiceFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchServiceFactory.class);

    @Bean(preDestroy="close")
    @Prototype
    @Requirements(value={@Requires(classes={MacOSXListeningWatchService.class, Library.class}), @Requires(property="micronaut.io.watch.enabled", value="true", defaultValue="true"), @Requires(property="micronaut.io.watch.paths")})
    @Primary
    protected WatchService macWatchService() throws IOException {
        try {
            return new MacOSXListeningWatchService();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unable to create Mac OS X specific watch service. Falling back to default polling strategy: {}", (Object)e.getMessage(), (Object)e);
            }
            return new WatchServiceFactory().watchService();
        }
    }
}

