/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.jcache;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.DefaultCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.jcache.JCacheSyncCache;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.cache.Cache;
import javax.inject.Named;

@Replaces(value=DefaultCacheManager.class)
@Requirements(value={@Requires(beans={javax.cache.CacheManager.class}), @Requires(property="micronaut.jcache.enabled", value="true", defaultValue="true")})
@Primary
public class JCacheManager
implements CacheManager<Cache> {
    public static final String JCACHE_ENABLED = "micronaut.jcache.enabled";
    private final javax.cache.CacheManager cacheManager;
    private final ConversionService<?> conversionService;
    private final ExecutorService executorService;

    protected JCacheManager(@Nonnull javax.cache.CacheManager cacheManager, @Nonnull @Named(value="io") ExecutorService executorService, @Nonnull ConversionService<?> conversionService) {
        this.cacheManager = cacheManager;
        this.conversionService = conversionService;
        this.executorService = executorService;
    }

    @Override
    @Nonnull
    public Set<String> getCacheNames() {
        return CollectionUtils.iterableToSet((Iterable)this.cacheManager.getCacheNames());
    }

    @Override
    @Nonnull
    public SyncCache<Cache> getCache(String name) {
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            throw new ConfigurationException("No cache configured for name: " + name);
        }
        return new JCacheSyncCache(cache, this.conversionService, this.executorService);
    }

    @Nonnull
    public javax.cache.CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

