/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.ReactiveInstrumenter;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.List;

@Internal
final class RxInstrumentedCompletableObserver
implements CompletableObserver,
Disposable,
RxInstrumentedComponent {
    private final CompletableObserver downstream;
    private Disposable upstream;
    private final List<RunnableInstrumenter> instrumentations;

    RxInstrumentedCompletableObserver(CompletableObserver downstream, List<RunnableInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = instrumentations;
    }

    RxInstrumentedCompletableObserver(CompletableObserver downstream, Collection<ReactiveInstrumenter> instrumentations) {
        this.downstream = downstream;
        this.instrumentations = this.toRunnableInstrumenters(instrumentations);
    }

    public void onSubscribe(Disposable d) {
        if (!this.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onError(Throwable t) {
        Runnable onError = () -> this.downstream.onError(t);
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onError = instrumentation.instrument(onError);
        }
        onError.run();
    }

    public void onComplete() {
        Runnable onComplete = () -> ((CompletableObserver)this.downstream).onComplete();
        for (RunnableInstrumenter instrumentation : this.instrumentations) {
            onComplete = instrumentation.instrument(onComplete);
        }
        onComplete.run();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void dispose() {
        this.upstream.dispose();
    }
}

