/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.CacheConfiguration;
import io.micronaut.cache.CacheInfo;
import io.micronaut.cache.DefaultCacheConfiguration;
import io.micronaut.cache.SyncCache;
import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.caffeine.cache.Policy;
import io.micronaut.caffeine.cache.Weigher;
import io.micronaut.caffeine.cache.stats.CacheStats;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.reactivex.Flowable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.reactivestreams.Publisher;

@EachBean(value=CacheConfiguration.class)
public class DefaultSyncCache
implements SyncCache<Cache> {
    private final CacheConfiguration cacheConfiguration;
    private final Cache cache;
    private final ApplicationContext applicationContext;
    private final ConversionService<?> conversionService;

    public DefaultSyncCache(DefaultCacheConfiguration cacheConfiguration, ApplicationContext applicationContext, ConversionService<?> conversionService) {
        this((CacheConfiguration)cacheConfiguration, applicationContext, conversionService);
    }

    @Inject
    public DefaultSyncCache(CacheConfiguration cacheConfiguration, ApplicationContext applicationContext, ConversionService<?> conversionService) {
        this.cacheConfiguration = cacheConfiguration;
        this.applicationContext = applicationContext;
        this.conversionService = conversionService;
        this.cache = this.buildCache(cacheConfiguration);
    }

    @Override
    public Publisher<CacheInfo> getCacheInfo() {
        return Flowable.just((Object)new CacheInfo(){

            @Nonnull
            public String getName() {
                return DefaultSyncCache.this.cacheConfiguration.getCacheName();
            }

            @Override
            @Nonnull
            public Map<String, Object> get() {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(2);
                data.put("implementationClass", DefaultSyncCache.this.getNativeCache().getClass().getName());
                data.put("caffeine", DefaultSyncCache.this.getCaffeineCacheData(DefaultSyncCache.this.cache));
                return data;
            }
        });
    }

    @Override
    public String getName() {
        return this.cacheConfiguration.getCacheName();
    }

    @Override
    public Cache getNativeCache() {
        return this.cache;
    }

    @Override
    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            return this.conversionService.convert(value, ConversionContext.of(requiredType));
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        Object value = this.cache.get(key, o -> supplier.get());
        if (value != null) {
            Optional converted = this.conversionService.convert(value, ConversionContext.of(requiredType));
            return converted.orElseThrow(() -> new IllegalArgumentException("Cache supplier returned a value that cannot be converted to type: " + requiredType.getName()));
        }
        return (T)value;
    }

    @Override
    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void put(@Nonnull Object key, @Nullable Object value) {
        if (value == null) {
            this.cache.invalidate(key);
        } else {
            this.cache.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> putIfAbsent(Object key, T value) {
        T previous = this.cache.asMap().putIfAbsent(key, value);
        return Optional.ofNullable(previous);
    }

    protected Cache buildCache(CacheConfiguration cacheConfiguration) {
        Caffeine builder = Caffeine.newBuilder();
        cacheConfiguration.getExpireAfterAccess().ifPresent(duration -> builder.expireAfterAccess(duration.toMillis(), TimeUnit.MILLISECONDS));
        cacheConfiguration.getExpireAfterWrite().ifPresent(duration -> builder.expireAfterWrite(duration.toMillis(), TimeUnit.MILLISECONDS));
        cacheConfiguration.getInitialCapacity().ifPresent(arg_0 -> ((Caffeine)builder).initialCapacity(arg_0));
        cacheConfiguration.getMaximumSize().ifPresent(arg_0 -> ((Caffeine)builder).maximumSize(arg_0));
        cacheConfiguration.getMaximumWeight().ifPresent(weight -> {
            builder.maximumWeight(weight);
            builder.weigher(this.findWeigher());
        });
        if (cacheConfiguration.isRecordStats()) {
            builder.recordStats();
        }
        if (cacheConfiguration.isTestMode()) {
            builder.executor(Runnable::run);
        }
        return builder.build();
    }

    private Weigher<Object, Object> findWeigher() {
        return this.applicationContext.findBean(Weigher.class, Qualifiers.byName((String)this.cacheConfiguration.getCacheName())).orElseGet(() -> this.applicationContext.findBean(Weigher.class).orElse(Weigher.singletonWeigher()));
    }

    private Map<String, Object> getCaffeineCacheData(Cache caffeineCache) {
        Policy policy = caffeineCache.policy();
        Optional eviction = policy.eviction();
        Policy.Expiration expireAfterAccess = policy.expireAfterAccess().orElse(null);
        Policy.Expiration expireAfterWrite = policy.expireAfterWrite().orElse(null);
        Long maximumSize = eviction.filter(e -> !e.isWeighted()).map(e -> e.getMaximum()).orElse(null);
        Long maximumWeight = eviction.filter(e -> e.isWeighted()).map(e -> e.getMaximum()).orElse(null);
        Long weightedSize = eviction.flatMap(e -> e.weightedSize().isPresent() ? Optional.of(e.weightedSize().getAsLong()) : Optional.empty()).orElse(null);
        boolean isRecordingStats = policy.isRecordingStats();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(8);
        values.put("estimatedSize", caffeineCache.estimatedSize());
        values.put("maximumSize", maximumSize);
        values.put("maximumWeight", maximumWeight);
        values.put("weightedSize", weightedSize);
        values.put("expireAfterAccess", this.getExpiresAfter(expireAfterAccess));
        values.put("expireAfterWrite", this.getExpiresAfter(expireAfterWrite));
        values.put("recordingStats", isRecordingStats);
        if (isRecordingStats) {
            values.put("stats", this.getStatsData(caffeineCache.stats()));
        }
        return values;
    }

    private Long getExpiresAfter(Policy.Expiration expiration) {
        return expiration != null ? Long.valueOf(expiration.getExpiresAfter(TimeUnit.MILLISECONDS)) : null;
    }

    private Map<String, Object> getStatsData(CacheStats stats) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(13);
        values.put("requestCount", stats.requestCount());
        values.put("hitCount", stats.hitCount());
        values.put("hitRate", stats.hitRate());
        values.put("missCount", stats.missCount());
        values.put("missRate", stats.missRate());
        values.put("evictionCount", stats.evictionCount());
        values.put("evictionWeight", stats.evictionWeight());
        return values;
    }
}

