/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.Cache;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface SyncCache<C>
extends Cache<C> {
    @Nonnull
    public <T> Optional<T> get(@Nonnull Object var1, @Nonnull Argument<T> var2);

    public <T> T get(@Nonnull Object var1, @Nonnull Argument<T> var2, @Nonnull Supplier<T> var3);

    @Nonnull
    public <T> Optional<T> putIfAbsent(@Nonnull Object var1, @Nonnull T var2);

    public void put(@Nonnull Object var1, @Nonnull Object var2);

    public void invalidate(@Nonnull Object var1);

    public void invalidateAll();

    default public <T> T get(@Nonnull Object key, @Nonnull Class<T> requiredType, @Nonnull Supplier<T> supplier) {
        return this.get(key, Argument.of(requiredType), supplier);
    }

    @Nonnull
    default public <T> Optional<T> get(@Nonnull Object key, @Nonnull Class<T> requiredType) {
        return this.get(key, Argument.of(requiredType));
    }

    @Nonnull
    default public AsyncCache<C> async() {
        return new AsyncCache<C>(){

            @Override
            public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.get(key, requiredType));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.get(key, requiredType, supplier));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.putIfAbsent(key, value));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public String getName() {
                return SyncCache.this.getName();
            }

            @Override
            public C getNativeCache() {
                return SyncCache.this.getNativeCache();
            }

            @Override
            public CompletableFuture<Boolean> put(Object key, Object value) {
                try {
                    SyncCache.this.put(key, value);
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public CompletableFuture<Boolean> invalidate(Object key) {
                try {
                    SyncCache.this.invalidate(key);
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public CompletableFuture<Boolean> invalidateAll() {
                try {
                    SyncCache.this.invalidateAll();
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            private <T> CompletableFuture<T> handleException(Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        };
    }
}

